/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.ui.editor.glossary;

public class Levenshtein {
    private final int initialSize = 20;
    private int[] d = null;
    private int x = 0;
    private int y = 0;

    Levenshtein() {
        this.setMatrixSize(20, 20);
    }

    int getDistance(String s, String t, int limit) {
        if (s == null || t == null || s.isEmpty() || t.isEmpty()) {
            return -1;
        }
        int k = 0;
        int best = 0;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int cost = Math.abs(n - m);
        if (cost > limit) {
            return -1;
        }
        int l1 = n++;
        int l2 = m++;
        if (n > this.x || m > this.y) {
            this.setMatrixSize(n, m);
        }
        int g = 0;
        int i = 1;
        while (i < n) {
            k = i;
            int f = 0;
            best = limit;
            int j = 1;
            while (j < m) {
                int h = k;
                int min = this.d[h] + 1;
                int b = this.d[(k += this.x) - 1] + 1;
                if (s.charAt(g) == t.charAt(f)) {
                    cost = 0;
                } else {
                    int tr;
                    cost = 1;
                    if (i < l1 && j < l2 && s.charAt(i) == t.charAt(f) && s.charAt(g) == t.charAt(j) && (tr = this.d[h - 1]) < min) {
                        min = tr;
                    }
                }
                int c = this.d[h - 1] + cost;
                if (b < min) {
                    min = b;
                }
                if (c < min) {
                    this.d[k] = c;
                    if (c < best) {
                        best = c;
                    }
                } else {
                    this.d[k] = min;
                    if (min < best) {
                        best = min;
                    }
                }
                f = j++;
            }
            if (best > limit) {
                return -1;
            }
            g = i++;
        }
        return this.d[k];
    }

    private void setMatrixSize(int n, int m) {
        ++m;
        if (this.x < ++n) {
            this.x = n;
        }
        if (this.y < m) {
            this.y = m;
        }
        this.d = new int[this.x * this.y];
        int k = 0;
        while (k < this.x) {
            this.d[k] = k;
            ++k;
        }
        k = this.x;
        int i = 1;
        while (i < this.y) {
            this.d[k] = i++;
            k += this.x;
        }
    }
}

