/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.ui.editor.glossary;

import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.fortiss.af3.mira.model.ContextElement;
import org.fortiss.af3.mira.model.Requirement;
import org.fortiss.af3.mira.model.RequirementsContainer;
import org.fortiss.af3.mira.model.RequirementsPackage;
import org.fortiss.af3.mira.model.glossary.Glossary;
import org.fortiss.af3.mira.model.glossary.GlossaryEntry;
import org.fortiss.af3.mira.ui.AF3MiraUIActivator;
import org.fortiss.af3.mira.utils.MiraUtils;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;

public class OverviewLabelProvider
implements ITableLabelProvider {
    private static Image requirementsContainerIcon = OverviewLabelProvider.createImage(ResourceLocator.imageDescriptorFromBundle((String)AF3MiraUIActivator.PLUGIN_ID, (String)"icons/Icon_RequirementsContainer.png"));
    private static Image requirementsPackageIcon = OverviewLabelProvider.createImage(ResourceLocator.imageDescriptorFromBundle((String)AF3MiraUIActivator.PLUGIN_ID, (String)"icons/Icon_RequirementsPackage.png"));
    private static Image requirementIcon = OverviewLabelProvider.createImage(ResourceLocator.imageDescriptorFromBundle((String)AF3MiraUIActivator.PLUGIN_ID, (String)"icons/Icon_Document.png"));
    private static Image glossaryIcon = OverviewLabelProvider.createImage(ResourceLocator.imageDescriptorFromBundle((String)AF3MiraUIActivator.PLUGIN_ID, (String)"icons/Icon_Glossary.png"));
    private static Image entryIcon = OverviewLabelProvider.createImage(ResourceLocator.imageDescriptorFromBundle((String)AF3MiraUIActivator.PLUGIN_ID, (String)"icons/Icon_Glossary_Entry.png"));

    private static Image createImage(Optional<ImageDescriptor> imgDescr) {
        if (imgDescr.isPresent()) {
            return imgDescr.get().createImage();
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof RequirementsContainer) {
                return requirementsContainerIcon;
            }
            if (element instanceof RequirementsPackage) {
                return requirementsPackageIcon;
            }
            if (element instanceof Requirement) {
                return requirementIcon;
            }
            if (element instanceof Glossary) {
                return glossaryIcon;
            }
            if (element instanceof GlossaryEntry) {
                return entryIcon;
            }
        }
        return null;
    }

    private static String getColumnText(Requirement requirement, int columnIndex) {
        if (columnIndex == 0) {
            return MiraUtils.getDisplayTypeFor((EObject)requirement);
        }
        if (columnIndex == 1) {
            return requirement.getStatus().getLiteral();
        }
        if (columnIndex == 2) {
            return requirement.getRequirementName();
        }
        if (columnIndex == 3) {
            return requirement.getDescription();
        }
        if (columnIndex == 4) {
            return requirement.getComment();
        }
        return null;
    }

    private String getColumnText(ContextElement element, int columnIndex) {
        if (columnIndex == 0) {
            return MiraUtils.getDisplayTypeFor((EObject)element);
        }
        if (columnIndex == 1) {
            return element.getStatus().getLiteral();
        }
        if (columnIndex == 2) {
            return MiraUtils.getContextElementName((ContextElement)element);
        }
        if (columnIndex == 3) {
            return element.getDefinition();
        }
        if (columnIndex == 4) {
            return element.getComment();
        }
        return null;
    }

    private static String getColumnText(INamedCommentedElement element, int columnIndex) {
        if (columnIndex == 0) {
            return MiraUtils.getDisplayTypeFor((EObject)element);
        }
        if (columnIndex == 1) {
            return "-";
        }
        if (columnIndex == 2) {
            return element.getName();
        }
        if (columnIndex == 3) {
            return "-";
        }
        if (columnIndex == 4) {
            return element.getComment();
        }
        return null;
    }

    public void addOverviewContentFor(List<String> overviewList, Object obj) {
        int columnIndex = 0;
        while (columnIndex < 5) {
            overviewList.add(this.getColumnText(obj, columnIndex));
            ++columnIndex;
        }
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof Requirement) {
            text = OverviewLabelProvider.getColumnText((Requirement)element, columnIndex);
        } else if (element instanceof ContextElement) {
            text = this.getColumnText((ContextElement)element, columnIndex);
        } else if (element instanceof INamedCommentedElement) {
            text = OverviewLabelProvider.getColumnText((INamedCommentedElement)element, columnIndex);
        }
        if (text == null) {
            text = "";
        }
        return text;
    }
}

