/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.ui.editor.highlight;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.fortiss.af3.mira.model.Analysis;
import org.fortiss.af3.mira.model.ContextElement;
import org.fortiss.af3.mira.model.Requirement;
import org.fortiss.af3.mira.model.WordElement;
import org.fortiss.af3.mira.model.glossary.Glossary;
import org.fortiss.af3.mira.model.glossary.GlossaryEntry;
import org.fortiss.af3.mira.ui.utils.HighlightUtils;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;

public class ConnectionContentAssistProcessor
implements IContentAssistProcessor {
    private final Analysis analysis;

    public ConnectionContentAssistProcessor(Analysis analysis) {
        this.analysis = analysis;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        IRegion curRegion = HighlightUtils.findWord(viewer.getDocument(), documentOffset - 1);
        if (curRegion != null) {
            try {
                int len = curRegion.getLength();
                String curWord = viewer.getDocument().get(curRegion.getOffset(), len);
                for (Glossary glossary : this.analysis.getGlossariesList()) {
                    for (IHierarchicElement entryElt : glossary.getContainedElements()) {
                        GlossaryEntry entry = (GlossaryEntry)entryElt;
                        this.addElementNamesToProposals(proposals, curWord, curRegion, viewer, (ContextElement)entry);
                    }
                }
                for (Requirement req : this.analysis.getRequirementsList()) {
                    this.addElementToProposals(proposals, curWord, curRegion, viewer, (INamedCommentedElement)req);
                }
                Comparator<ICompletionProposal> alphabeticallyComparator = new Comparator<ICompletionProposal>(){

                    @Override
                    public int compare(ICompletionProposal o1, ICompletionProposal o2) {
                        String str2 = o2.getDisplayString();
                        return o1.getDisplayString().compareToIgnoreCase(str2);
                    }
                };
                Collections.sort(proposals, alphabeticallyComparator);
                HighlightUtils.removeDuplicateICompletionProposal(proposals);
                ICompletionProposal[] result = new ICompletionProposal[proposals.size()];
                proposals.toArray(result);
                return result;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void addElementToProposals(List<ICompletionProposal> proposals, String currentWord, IRegion currentWordRegion, ITextViewer viewer, INamedCommentedElement element) {
        int pos = -1;
        pos = HighlightUtils.match(currentWord, element.getName(), viewer, currentWordRegion, true);
        if (pos >= 0) {
            int repltOffset = currentWordRegion.getOffset() - pos;
            int repltLen = currentWordRegion.getLength() + pos;
            int length = element.getName().length();
            proposals.add((ICompletionProposal)new CompletionProposal(element.getName(), repltOffset, repltLen, length));
        }
    }

    private void addElementNamesToProposals(List<ICompletionProposal> proposals, String currentWord, IRegion currentWordRegion, ITextViewer viewer, ContextElement element) {
        int len;
        int pos = -1;
        this.addElementToProposals(proposals, currentWord, currentWordRegion, viewer, (INamedCommentedElement)element);
        int repltOffset = currentWordRegion.getOffset() - pos;
        int repltLen = currentWordRegion.getLength() + pos;
        for (WordElement syn : element.getSynonyms()) {
            pos = HighlightUtils.match(currentWord, syn.getText(), viewer, currentWordRegion, true);
            if (pos < 0) continue;
            len = syn.getText().length();
            proposals.add((ICompletionProposal)new CompletionProposal(syn.getText(), repltOffset, repltLen, len));
        }
        for (WordElement abbr : element.getAbbreviations()) {
            pos = HighlightUtils.match(currentWord, abbr.getText(), viewer, currentWordRegion, true);
            if (pos < 0) continue;
            len = abbr.getText().length();
            proposals.add((ICompletionProposal)new CompletionProposal(abbr.getText(), repltOffset, repltLen, len));
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        Object allLetters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        allLetters = (String)allLetters + "\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc\u1e9e";
        return ((String)allLetters).toCharArray();
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

