/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.ui.editor.highlight;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.fortiss.af3.mira.model.Analysis;
import org.fortiss.af3.mira.model.ContextElement;
import org.fortiss.af3.mira.model.IImageContainer;
import org.fortiss.af3.mira.model.ImageItem;
import org.fortiss.af3.mira.model.WordElement;
import org.fortiss.af3.mira.model.glossary.Glossary;
import org.fortiss.af3.mira.model.glossary.GlossaryEntry;
import org.fortiss.af3.mira.ui.utils.ContextUtils;
import org.fortiss.af3.mira.ui.utils.HighlightUtils;
import org.fortiss.af3.mira.ui.utils.ImageUtils;
import org.fortiss.tooling.kernel.model.INamedElement;

public class ConnectionTextHover
extends DefaultTextHover
implements ITextHoverExtension2 {
    private Analysis analysis;

    public ConnectionTextHover(ISourceViewer sourceViewer, Analysis analysis) {
        super(sourceViewer);
        this.analysis = analysis;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        StringBuilder hoverText = new StringBuilder();
        List<ConnectionSearchResult> resultList = this.searchConnections(textViewer, hoverRegion);
        if (resultList.size() > 0) {
            Collections.sort(resultList);
            for (ConnectionSearchResult resultListEntry : resultList) {
                INamedElement resultListEntryElement = resultListEntry.getElement();
                if (resultListEntryElement == null) continue;
                ResultType resultListEntryType = resultListEntry.getType();
                if (!(resultListEntryElement instanceof GlossaryEntry)) continue;
                this.hoverText(hoverText, resultListEntryElement, "Glossary Entry", resultListEntry.getMatchingPropertyText(), ((GlossaryEntry)resultListEntryElement).getImages().size() > 0, resultListEntryType.equals((Object)ResultType.GABBREVIATION), resultListEntryType.equals((Object)ResultType.GSYNONYM), true);
            }
            return hoverText.toString();
        }
        return "";
    }

    private void hoverText(StringBuilder hoverText, INamedElement element, String title, String text, boolean hasImage, boolean isAbbreviation, boolean isSynonym, boolean hasLine) {
        if (hoverText.indexOf(title) != -1) {
            return;
        }
        hoverText.append("<p><h4> " + title + " </h4></p>");
        if (hasImage && element instanceof IImageContainer) {
            hoverText.append("<div style='width:150px; font-size:80%; text-align:center;float:right;margin-left:15px;margin-bottom:10px'><div><img src='" + ImageUtils.getImageFile((ImageItem)((IImageContainer)element).getImages().get(0)).getAbsolutePath() + "' width='150' /></div>" + (((ImageItem)((IImageContainer)element).getImages().get(0)).getName() != null ? ((ImageItem)((IImageContainer)element).getImages().get(0)).getName() : "") + "</div>");
        }
        hoverText.append("<span style='margin-right:10px;'><b><a href='id:" + element.getId() + "'>" + text + "</a></b></span>");
        if (isAbbreviation) {
            hoverText.append("<i>Abbreviation of " + element.getName() + "</i>");
        }
        if (isSynonym) {
            hoverText.append("<i>Synonym of " + element.getName() + "</i>");
        }
        if (element instanceof ContextElement) {
            hoverText.append("<p> Definition: " + ((ContextElement)element).getDefinition() + "</p>");
        }
        if (hasLine) {
            hoverText.append("<hr style='clear:right'>");
        }
    }

    private List<ConnectionSearchResult> searchConnections(ITextViewer textViewer, IRegion hoverRegion) {
        ArrayList<ConnectionSearchResult> resultList = new ArrayList<ConnectionSearchResult>();
        List<String> pluralEndings = ContextUtils.getPluralEndings();
        String pluralEnding = "";
        try {
            String hoveredWord = textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength()).trim();
            String[] words = hoveredWord.split("_");
            int listSize = 0;
            String[] stringArray = words;
            int n = words.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if (!word.isEmpty()) {
                    String wordSaved = word;
                    listSize = resultList.size();
                    int i = -1;
                    while (i < pluralEndings.size()) {
                        if (i != -1) {
                            if (listSize != resultList.size()) break;
                            pluralEnding = pluralEndings.get(i);
                            word = wordSaved.endsWith(pluralEnding) ? wordSaved.substring(0, wordSaved.length() - pluralEnding.length()) : wordSaved;
                        }
                        for (Glossary glossary : this.analysis.getGlossariesList()) {
                            for (GlossaryEntry entry : glossary.getGlossaryEntryList()) {
                                this.searchAllMatching((ContextElement)entry, textViewer, hoverRegion, word, ResultType.GNAME, ResultType.GABBREVIATION, ResultType.GSYNONYM, resultList);
                            }
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        Collections.sort(resultList);
        return resultList;
    }

    private void searchNameMatching(INamedElement element, ITextViewer textViewer, IRegion hoverRegion, String hoveredWord, ResultType nameType, List<ConnectionSearchResult> resultList) {
        if (HighlightUtils.match(hoveredWord, element.getName(), textViewer, hoverRegion, false) >= 0) {
            resultList.add(new ConnectionSearchResult(element, nameType, element.getName()));
        }
    }

    private void searchAllMatching(ContextElement element, ITextViewer textViewer, IRegion hoverRegion, String hoveredWord, ResultType nameType, ResultType abbreviationType, ResultType synonymType, List<ConnectionSearchResult> resultList) {
        this.searchNameMatching((INamedElement)element, textViewer, hoverRegion, hoveredWord, nameType, resultList);
        for (WordElement abbreviation : element.getAbbreviations()) {
            if (HighlightUtils.match(hoveredWord, abbreviation.getText(), textViewer, hoverRegion, false) < 0) continue;
            resultList.add(new ConnectionSearchResult((INamedElement)element, abbreviationType, abbreviation.getText()));
        }
        for (WordElement synonym : element.getSynonyms()) {
            if (HighlightUtils.match(hoveredWord, synonym.getText(), textViewer, hoverRegion, false) < 0) continue;
            resultList.add(new ConnectionSearchResult((INamedElement)element, synonymType, synonym.getText()));
        }
    }

    private static class ConnectionSearchResult
    implements Comparable<ConnectionSearchResult> {
        private INamedElement element;
        private ResultType type;
        private String matchingPropertyText;

        public ConnectionSearchResult(INamedElement element, ResultType type, String matchingPropertyText) {
            this.element = element;
            this.type = type;
            this.matchingPropertyText = matchingPropertyText;
        }

        public INamedElement getElement() {
            return this.element;
        }

        public String getMatchingPropertyText() {
            return this.matchingPropertyText;
        }

        public ResultType getType() {
            return this.type;
        }

        @Override
        public int compareTo(ConnectionSearchResult otherResult) {
            if (otherResult == null) {
                return -1;
            }
            if (this.type.getLevel() != otherResult.getType().getLevel()) {
                return this.type.getLevel() - otherResult.getType().getLevel();
            }
            return this.matchingPropertyText.compareTo(otherResult.getMatchingPropertyText());
        }
    }

    private static enum ResultType {
        SNAME(0),
        SSYNONYM(1),
        SABBREVIATION(2),
        SCONTACT(3),
        DNAME(4),
        DSYNONYM(5),
        DABBREVIATION(6),
        ENAME(7),
        ESYNONYM(8),
        EABBREVIATION(9),
        GNAME(10),
        GSYNONYM(11),
        GABBREVIATION(12),
        MNAME(13),
        SIGNAME(14),
        PARNAME(15);

        private int level;

        private ResultType(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

