/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.ui.editor.highlight;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.fortiss.af3.mira.ui.utils.ContextUtils;

public class MiraWordRule
extends WordRule {
    private StringBuffer fBuffer = new StringBuffer();
    private StringBuffer nextPart = new StringBuffer();
    private Map<String, Integer> maxWordsMap = new HashMap<String, Integer>();
    private String specialCharsWithBlank = ContextUtils.getSpecialCharsWithBlank();
    private String regex = ContextUtils.getSpecialCharsWithBlankAsRegex();
    private List<String> pluralEndings = ContextUtils.getPluralEndings();

    public MiraWordRule(IWordDetector detector) {
        super(detector);
    }

    public void addWord(String wordString, IToken token) {
        if (wordString == null) {
            return;
        }
        wordString = wordString.toLowerCase();
        super.addWord(wordString, token);
        String[] words = wordString.split(this.regex);
        int maxWordCounts = 0;
        if (words.length != 0) {
            int i = 0;
            while (i < words.length) {
                if (!words[i].isEmpty()) {
                    ++maxWordCounts;
                }
                ++i;
            }
            if (this.maxWordsMap.containsKey(words[0])) {
                maxWordCounts = Math.max(maxWordCounts, this.maxWordsMap.get(words[0]));
            }
            this.maxWordsMap.put(words[0], maxWordCounts);
        }
    }

    public IToken evaluate(ICharacterScanner scanner) {
        IToken foundToken = null;
        int maxWords = 0;
        int wordsRead = 0;
        int longestDetectedTokenLength = 0;
        boolean firstRun = true;
        String buffer = "";
        scanner.unread();
        int c = scanner.read();
        if (!Character.isLetterOrDigit(c)) {
            c = scanner.read();
            if (c != -1 && this.fDetector.isWordStart((char)c)) {
                this.fBuffer.setLength(0);
                scanner.unread();
                do {
                    IToken token;
                    String nextPart = this.readNextPartIntoBuffer(scanner);
                    this.fBuffer.append(nextPart);
                    buffer = this.fBuffer.toString().toLowerCase();
                    if (!this.specialCharsWithBlank.contains(nextPart) || nextPart.isEmpty()) {
                        ++wordsRead;
                    }
                    if ((token = (IToken)this.fWords.get(buffer)) == null && !buffer.isEmpty() && this.pluralEndings != null) {
                        for (String pluralEnding : this.pluralEndings) {
                            String cutBuffer = "";
                            if (buffer.endsWith(pluralEnding)) {
                                cutBuffer = buffer.substring(0, buffer.length() - pluralEnding.length());
                            }
                            if (!cutBuffer.isEmpty()) {
                                token = (IToken)this.fWords.get(cutBuffer);
                            }
                            if (token == null) continue;
                            buffer = cutBuffer;
                            break;
                        }
                    }
                    if (token != null) {
                        foundToken = token;
                        longestDetectedTokenLength = buffer.length();
                    }
                    if (!firstRun) continue;
                    firstRun = false;
                    maxWords = this.maxWordsMap.containsKey(buffer) ? this.maxWordsMap.get(buffer) : 0;
                } while (wordsRead < maxWords + 1);
                if (foundToken != null) {
                    this.unread(scanner, this.fBuffer.length() - longestDetectedTokenLength);
                    return foundToken;
                }
                if (this.fDefaultToken.isUndefined()) {
                    this.unread(scanner, this.fBuffer.length());
                }
                return this.fDefaultToken;
            }
            scanner.unread();
        }
        return Token.UNDEFINED;
    }

    /*
     * Unable to fully structure code
     */
    private String readNextPartIntoBuffer(ICharacterScanner scanner) {
        this.nextPart.setLength(0);
        c = scanner.read();
        if (c == -1 || !this.specialCharsWithBlank.contains(String.valueOf((char)c))) ** GOTO lbl10
        this.nextPart.append((char)c);
        return this.nextPart.toString().toLowerCase();
lbl-1000:
        // 1 sources

        {
            this.nextPart.append((char)c);
            c = scanner.read();
lbl10:
            // 2 sources

            ** while (c != -1 && this.fDetector.isWordPart((char)((char)c)))
        }
lbl11:
        // 1 sources

        scanner.unread();
        return this.nextPart.toString().toLowerCase();
    }

    private void unread(ICharacterScanner scanner, int number) {
        int i = 0;
        while (i < number) {
            scanner.unread();
            ++i;
        }
    }
}

