/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.ui.editor.highlight;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.fortiss.af3.mira.model.Analysis;
import org.fortiss.af3.mira.model.ContextElement;
import org.fortiss.af3.mira.model.Requirement;
import org.fortiss.af3.mira.model.WordElement;
import org.fortiss.af3.mira.model.glossary.Glossary;
import org.fortiss.af3.mira.model.glossary.GlossaryEntry;
import org.fortiss.af3.mira.ui.editor.highlight.ConnectionHighlightColorConstants;
import org.fortiss.af3.mira.ui.editor.highlight.ConnectionHighlightScanner;
import org.fortiss.af3.mira.ui.editor.highlight.MiraWordRule;
import org.fortiss.af3.mira.ui.utils.ContextUtils;
import org.fortiss.tooling.kernel.model.INamedElement;

public class ScannerManager {
    public static final IToken elementToken = new Token((Object)new TextAttribute(ConnectionHighlightColorConstants.ELEMENT_COLOR));
    public static final IToken reqToken = new Token((Object)new TextAttribute(ConnectionHighlightColorConstants.REQ_COLOR));
    public static final IToken synonymToken = new Token((Object)new TextAttribute(ConnectionHighlightColorConstants.SYNONYM_COLOR));
    private static final IWordDetector wordDetector = new IWordDetector(){
        private String specialChars = ContextUtils.getSpecialChars();

        public boolean isWordStart(char c) {
            return Character.isLetterOrDigit(c) && !Character.isWhitespace(c) || this.specialChars.indexOf(c) >= 0;
        }

        public boolean isWordPart(char c) {
            return Character.isLetterOrDigit(c) && !Character.isWhitespace(c);
        }
    };

    public static ConnectionHighlightScanner getScanner(Analysis analysis) {
        ConnectionHighlightScanner scanner = new ConnectionHighlightScanner();
        scanner.setWordRule(ScannerManager.createNewWordRule(analysis));
        return scanner;
    }

    public static MiraWordRule createNewWordRule(Analysis analysis) {
        MiraWordRule wordRule = new MiraWordRule(wordDetector);
        for (Glossary glossary : analysis.getGlossariesList()) {
            for (GlossaryEntry entry : glossary.getGlossaryEntryList()) {
                if (entry.getName() == null) continue;
                ScannerManager.addAllWord(wordRule, (ContextElement)entry);
            }
        }
        for (Requirement req : analysis.getRequirementsList()) {
            ScannerManager.addNameWord(wordRule, (INamedElement)req, reqToken);
        }
        return wordRule;
    }

    private static void addNameWord(MiraWordRule wordRule, INamedElement element, IToken token) {
        wordRule.addWord(element.getName(), token);
    }

    private static void addAllWord(MiraWordRule wordRule, ContextElement element) {
        ScannerManager.addNameWord(wordRule, (INamedElement)element, elementToken);
        for (WordElement abbreviation : element.getAbbreviations()) {
            wordRule.addWord(abbreviation.getText(), elementToken);
        }
        for (WordElement synonym : element.getSynonyms()) {
            wordRule.addWord(synonym.getText(), synonymToken);
        }
    }
}

