/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.ui.editor.images;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.TextStyledTextActionHandler;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.fortiss.af3.mira.model.IImageContainer;
import org.fortiss.af3.mira.model.ImageItem;
import org.fortiss.af3.mira.model.Requirement;
import org.fortiss.af3.mira.model.glossary.GlossaryEntry;
import org.fortiss.af3.mira.ui.utils.HighlightUtils;
import org.fortiss.af3.mira.ui.utils.ImageUtils;
import org.fortiss.af3.project.utils.FileUtils;
import org.fortiss.tooling.kernel.model.FortissToolingKernelPackage;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.ui.util.DataBindingUtils;

public class ImageBox {
    private Composite composite;
    private FormToolkit toolkit;
    private ImageItem imageItem;
    private IImageContainer editedObject;
    private Image image;
    private final DataBindingContext dbc;
    private ScrolledForm form;
    private List<SourceViewer> registeredSourceViewers;

    public ImageBox(Composite composite, FormToolkit toolkit, ImageItem imageItem, IImageContainer editedObject, DataBindingContext dbc, ScrolledForm form, List<SourceViewer> registeredSourceViewers) {
        this.composite = composite;
        this.toolkit = toolkit;
        this.imageItem = imageItem;
        this.editedObject = editedObject;
        this.dbc = dbc;
        this.form = form;
        this.registeredSourceViewers = registeredSourceViewers;
    }

    public boolean createBox(final TextStyledTextActionHandler textStyledTextActionHandler) {
        try {
            if (SystemUtils.IS_OS_UNIX) {
                String absolutePath = ImageUtils.getImageFile(this.imageItem).getAbsolutePath();
                absolutePath = absolutePath.replace("images", "Images");
                Path imgPath = new Path(absolutePath);
                Object[] parts = imgPath.toOSString().split("\\\\");
                String fixedSegments = StringUtils.concat((Object[])parts, (String)File.separator);
                this.image = new Image((Device)this.composite.getDisplay(), fixedSegments);
            } else {
                Path imgPath = new Path(ImageUtils.getImageFile(this.imageItem).getAbsolutePath());
                this.image = new Image((Device)this.composite.getDisplay(), imgPath.toOSString());
            }
        }
        catch (Exception e) {
            return false;
        }
        final Canvas canvas = new Canvas(this.composite, 2048);
        final Rectangle imageSize = this.calcImageSize(this.image.getBounds(), 800, 200);
        GridDataFactory.swtDefaults().hint(imageSize.width, imageSize.height).applyTo((Control)canvas);
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ImageBox.this.image != null) {
                    e.gc.drawImage(ImageBox.this.image, 0, 0, ImageBox.this.image.getBounds().width, ImageBox.this.image.getBounds().height, 0, 0, imageSize.width, imageSize.height);
                }
            }
        });
        canvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                try {
                    Desktop.getDesktop().open(new File(FileUtils.getDefaultGeneralProjectPath(), ImageBox.this.imageItem.getUri()));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        final Composite rightOfPicture = this.toolkit.createComposite(this.composite);
        rightOfPicture.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)rightOfPicture);
        Label descriptionLabel = this.toolkit.createLabel(rightOfPicture, "Description: ", 8);
        GridDataFactory.swtDefaults().align(131072, 0x1000000).applyTo((Control)descriptionLabel);
        final SourceViewer descriptionInput = this.editedObject instanceof Requirement ? HighlightUtils.createSourceViewer(this.form, rightOfPicture, 2048, ((Requirement)this.editedObject).getAnalysis()) : (this.editedObject instanceof GlossaryEntry ? HighlightUtils.createSourceViewer(this.form, rightOfPicture, 2048, ((GlossaryEntry)this.editedObject).getGlossary().getAnalysis()) : null);
        this.registeredSourceViewers.add(descriptionInput);
        if (descriptionInput == null) {
            return false;
        }
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo(descriptionInput.getControl());
        DataBindingUtils.bind((DataBindingContext)this.dbc, (Control)descriptionInput.getTextWidget(), (EObject)this.imageItem, (EStructuralFeature)FortissToolingKernelPackage.Literals.INAMED_ELEMENT__NAME);
        if (textStyledTextActionHandler != null) {
            textStyledTextActionHandler.addText(descriptionInput.getTextWidget());
        }
        Button removePictureButton = this.toolkit.createButton(rightOfPicture, "Remove", 0x800000);
        GridDataFactory.swtDefaults().align(16384, 0x1000000).applyTo((Control)removePictureButton);
        removePictureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageBox.this.registeredSourceViewers.remove(descriptionInput);
                if (textStyledTextActionHandler != null) {
                    textStyledTextActionHandler.removeText(descriptionInput.getTextWidget());
                }
                canvas.dispose();
                rightOfPicture.dispose();
                ImageBox.this.remove();
            }
        });
        return true;
    }

    private void remove() {
        this.image.dispose();
        this.image = null;
        ICommandStackService.getInstance().runAsCommand((EObject)this.editedObject, new Runnable(){

            @Override
            public void run() {
                ImageBox.this.editedObject.getImages().remove((Object)ImageBox.this.imageItem);
            }
        });
        this.imageItem = null;
        this.composite.getParent().layout();
        this.composite.getParent().getParent().getParent().layout();
        this.form.reflow(true);
    }

    private Rectangle calcImageSize(Rectangle imageBounds, int maxWidth, int maxHeight) {
        double scaleFactor = Math.min((double)maxWidth / (double)this.image.getBounds().width, (double)maxHeight / (double)this.image.getBounds().height);
        return new Rectangle(0, 0, (int)((double)imageBounds.width * scaleFactor), (int)((double)imageBounds.height * scaleFactor));
    }
}

