/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.ui.editor.images;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.fortiss.af3.mira.model.IImageContainer;
import org.fortiss.af3.mira.model.ImageItem;
import org.fortiss.af3.mira.ui.editor.images.ImageBox;
import org.fortiss.af3.mira.ui.utils.MiraLayoutUtils;
import org.fortiss.af3.mira.utils.MiraModelElementFactory;
import org.fortiss.af3.project.utils.FileUtils;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.ui.extension.base.EditorBase;

public class ImageSection {
    private EditorBase<? extends EObject> editorBase;
    private Composite composite;
    private FormToolkit toolkit;
    private IImageContainer editedObject;
    private final DataBindingContext dbc;
    private ScrolledForm form;
    private List<SourceViewer> registeredSourceViewers;
    private Composite imagesComposite;

    public ImageSection(EditorBase<? extends EObject> editorBase, Composite composite, IImageContainer editedObject, FormToolkit toolkit, DataBindingContext dbc, ScrolledForm form, List<SourceViewer> registeredSourceViewers) {
        this.editorBase = editorBase;
        this.composite = composite;
        this.toolkit = toolkit;
        this.editedObject = editedObject;
        this.dbc = dbc;
        this.form = form;
        this.registeredSourceViewers = registeredSourceViewers;
        this.createSectionElements();
    }

    private void createSectionElements() {
        Label label = this.toolkit.createLabel(this.composite, "Images ", 8);
        MiraLayoutUtils.multiLineLabelFactory.applyTo((Control)label);
        Button addPictureButton = this.toolkit.createButton(this.composite, "Add image", 0x800000);
        addPictureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filenameStr = ImageSection.this.openFileDialog(ImageSection.this.composite.getShell());
                if (filenameStr != null) {
                    ImageItem newItem = MiraModelElementFactory.createImageItem();
                    Path filename = new Path(filenameStr);
                    File sourceFile = new File(filename.toOSString());
                    File imageFolder = new File(FileUtils.getDefaultGeneralProjectPath(), "Images");
                    if (!imageFolder.exists() || !imageFolder.isDirectory()) {
                        imageFolder.mkdir();
                    }
                    File destFile = new File(imageFolder, sourceFile.getName());
                    try {
                        if (!destFile.exists()) {
                            FileSystemUtils.copyFile((File)sourceFile, (File)destFile);
                        }
                    }
                    catch (IOException ioe) {
                        MessageDialog.openInformation((Shell)ImageSection.this.composite.getShell(), (String)"Copy error", (String)"The image could not be copied into the project directory. ");
                        return;
                    }
                    String uri = new File("Images", destFile.getName()).getPath();
                    newItem.setUri(uri);
                    ICommandStackService.getInstance().runAsCommand((EObject)ImageSection.this.editedObject, () -> ImageSection.this.editedObject.getImages().add((Object)newItem));
                    new ImageBox(ImageSection.this.imagesComposite, ImageSection.this.toolkit, newItem, ImageSection.this.editedObject, ImageSection.this.dbc, ImageSection.this.form, ImageSection.this.registeredSourceViewers).createBox(ImageSection.this.editorBase.getTextStyledTextActionHandler());
                    ImageSection.this.composite.layout();
                    ImageSection.this.composite.getParent().getParent().layout();
                    ImageSection.this.form.reflow(true);
                }
            }
        });
        this.toolkit.createLabel(this.composite, " ", 8);
        this.imagesComposite = this.toolkit.createComposite(this.composite);
        this.imagesComposite.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)this.imagesComposite);
        ArrayList<ImageItem> toRemove = new ArrayList<ImageItem>();
        for (ImageItem item : this.editedObject.getImages()) {
            ImageBox box = new ImageBox(this.imagesComposite, this.toolkit, item, this.editedObject, this.dbc, this.form, this.registeredSourceViewers);
            if (box.createBox(null) || !this.askIfDelete(item)) continue;
            toRemove.add(item);
        }
        if (!toRemove.isEmpty()) {
            ICommandStackService.getInstance().runAsCommand((EObject)this.editedObject, () -> this.editedObject.getImages().removeAll((Collection)toRemove));
        }
    }

    private boolean askIfDelete(ImageItem item) {
        return MessageDialog.openQuestion((Shell)this.composite.getShell(), (String)"Image could not be opened", (String)("The image " + item.getUri() + " could not be opened. Perhaps it was deleted or the AF3 image folder is not accessible.\nDo you want to delete the reference to this image?"));
    }

    private String openFileDialog(Shell shell) {
        FileDialog fileChooser = new FileDialog(shell, 4096);
        fileChooser.setText("Open image file");
        fileChooser.setFilterExtensions(new String[]{"*.gif;*.jpg;*.jpeg;*.png;*.ico;*.bmp"});
        fileChooser.setFilterNames(new String[]{"Image file (gif, jpg, jpeg, png, ico, bmp)"});
        return fileChooser.open();
    }
}

