/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.ui.editor.overview;

import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.layout.BorderPane;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.fortiss.af3.mira.model.RequirementStatus;
import org.fortiss.af3.mira.model.glossary.Glossary;
import org.fortiss.af3.mira.ui.editor.overview.RequirementsOverviewEditorContentProvider;
import org.fortiss.af3.mira.ui.editor.overview.RequirementsOverviewEditorUIProvider;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableViewer;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.IDoubleClickHandler;
import org.fortiss.tooling.kernel.ui.extension.base.FXEditorBase;
import org.fortiss.tooling.kernel.ui.service.IModelEditorBindingService;
import org.fortiss.tooling.kernel.ui.service.INavigatorService;
import org.fortiss.tooling.kernel.utils.KernelServiceBasedModelListenerBase;

public class RequirementsOverviewEditor<T extends IHierarchicElement>
extends FXEditorBase<T> {
    private DynamicTreeTableViewer<IHierarchicElement> treeTableViewer;
    private TextField filterWidget;
    private KernelServiceBasedModelListenerBase<T> modelListener;

    protected Parent createSceneRoot() {
        IHierarchicElement edited = (IHierarchicElement)this.getEditedObject();
        this.modelListener = new KernelServiceBasedModelListenerBase<T>(edited){

            public void updateComplete(List<Notification> notifications) {
                RequirementsOverviewEditor.this.treeTableViewer.update();
                RequirementsOverviewEditor.this.treeTableViewer.expandAllItems();
            }
        };
        this.modelListener.register();
        RequirementsOverviewEditorContentProvider contentProvider = new RequirementsOverviewEditorContentProvider();
        RequirementsOverviewEditorUIProvider uiProvider = new RequirementsOverviewEditorUIProvider();
        this.filterWidget = new TextField();
        this.filterWidget.textProperty().addListener((obs, oVal, nVal) -> {
            contentProvider.setFilterExpression((String)nVal);
            this.treeTableViewer.update();
            this.treeTableViewer.expandAllItems();
        });
        this.filterWidget.setTooltip(new Tooltip("type filter text"));
        this.filterWidget.setPromptText("type filter text");
        this.treeTableViewer = new DynamicTreeTableViewer((Object)edited, true, 3, (DynamicTreeContentProviderBase)contentProvider, (DynamicTreeTableUIProviderBase)uiProvider);
        this.treeTableViewer.addColumn("Type", 300);
        TreeMap<RequirementStatus, String> map = new TreeMap<RequirementStatus, String>(new Comparator<RequirementStatus>(){

            @Override
            public int compare(RequirementStatus r1, RequirementStatus r2) {
                return Integer.compare(r1.getValue(), r2.getValue());
            }
        });
        RequirementStatus[] requirementStatusArray = RequirementStatus.values();
        int n = requirementStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            RequirementStatus value = requirementStatusArray[n2];
            map.put(value, value.getName());
            ++n2;
        }
        TreeTableColumn statusColumn = this.treeTableViewer.addComboColumn("Status", 160, e -> map);
        TreeTableColumn idColumn = this.treeTableViewer.addColumn("ID", 100);
        this.treeTableViewer.addColumn("Title", 250);
        this.treeTableViewer.addColumn("Description", 400);
        this.treeTableViewer.addColumn("Comment", 250);
        if (this.editedObject instanceof Glossary) {
            statusColumn.setVisible(false);
            idColumn.setVisible(false);
        }
        this.treeTableViewer.setDoubleClickHandler(new IDoubleClickHandler(){

            public void doubleClicked(Object value) {
                if (value instanceof EObject) {
                    IModelEditorBindingService.getInstance().openInEditor((EObject)value);
                }
            }
        });
        BorderPane pane = new BorderPane();
        pane.setTop((Node)this.filterWidget);
        pane.setCenter((Node)this.treeTableViewer.getControl());
        this.treeTableViewer.expandAllItems();
        return pane;
    }

    public void dispose() {
        this.modelListener.unregister();
        super.dispose();
    }

    public void navigateToFX(EObject element) {
        if (element instanceof IHierarchicElement) {
            this.treeTableViewer.navigateTo((Object)((IHierarchicElement)element));
            INavigatorService.getInstance().setCurrentSelection((ISelection)new StructuredSelection((Object)element));
        }
    }
}

