/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.ui.editor.overview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.fortiss.af3.mira.model.Analysis;
import org.fortiss.af3.mira.model.Requirement;
import org.fortiss.af3.mira.model.glossary.GlossaryEntry;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;

public class RequirementsOverviewEditorContentProvider
extends DynamicTreeContentProviderBase<IHierarchicElement> {
    protected Collection<? extends IHierarchicElement> getChildren(IHierarchicElement parent) {
        ArrayList result = new ArrayList();
        if (parent instanceof Analysis) {
            Analysis analysis = (Analysis)parent;
            result.addAll(analysis.getRequirementsContainersList());
            result.addAll(analysis.getGlossariesList());
        } else {
            result.addAll(parent.getContainedElements());
        }
        return result;
    }

    protected boolean filter(IHierarchicElement element, String filterValue) {
        if (element == null) {
            return false;
        }
        if (filterValue == null) {
            return true;
        }
        if (element instanceof Analysis) {
            return true;
        }
        if (element instanceof Requirement) {
            Requirement req = (Requirement)element;
            String checkStr = req.getName() + req.getDescription() + req.getComment() + req.getStatus().getName() + req.getId();
            return checkStr.toLowerCase().contains(filterValue.toLowerCase());
        }
        if (element instanceof GlossaryEntry) {
            GlossaryEntry ge = (GlossaryEntry)element;
            String checkString = ge.getName() + ge.getDefinition() + ge.getStatus().getName();
            return checkString.toLowerCase().contains(filterValue.toLowerCase());
        }
        List filteredElem = element.getContainedElements().stream().filter(g -> this.filter((IHierarchicElement)g, filterValue)).collect(Collectors.toList());
        return filteredElem.size() > 0;
    }
}

