/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.ui.editor.overview;

import javafx.scene.Node;
import javafx.scene.input.Dragboard;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.mira.model.Analysis;
import org.fortiss.af3.mira.model.Requirement;
import org.fortiss.af3.mira.model.RequirementStatus;
import org.fortiss.af3.mira.model.RequirementsContainer;
import org.fortiss.af3.mira.model.RequirementsPackage;
import org.fortiss.af3.mira.model.glossary.Glossary;
import org.fortiss.af3.mira.model.glossary.GlossaryEntry;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.ui.utils.FXDNDUtils;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;

public class RequirementsOverviewEditorUIProvider
extends DynamicTreeTableUIProviderBase<IHierarchicElement> {
    private static final int COL_TYPE = 0;
    private static final int COL_STATUS = 1;
    private static final int COL_ID = 2;
    private static final int COL_TITLE = 3;
    private static final int COL_DESCRIPTION = 4;
    private static final int COL_COMMENT = 5;

    public String getLabel(IHierarchicElement element, int column) {
        if (element instanceof Analysis) {
            if (column == 0) {
                return "All elements";
            }
        } else if (element instanceof RequirementsContainer) {
            if (column == 0) {
                return "Requirements Container";
            }
        } else if (element instanceof Glossary) {
            if (column == 0) {
                return "Glossary";
            }
        } else if (element instanceof Requirement) {
            Requirement req = (Requirement)element;
            switch (column) {
                case 0: {
                    return "Requirement";
                }
                case 1: {
                    return req.getStatus().toString();
                }
                case 2: {
                    return req.getReqId();
                }
                case 4: {
                    return req.getDescription();
                }
            }
        } else if (element instanceof RequirementsPackage) {
            if (column == 0) {
                return "Requirements Package";
            }
        } else if (element instanceof GlossaryEntry) {
            GlossaryEntry glos = (GlossaryEntry)element;
            switch (column) {
                case 0: {
                    return "Glossary Entry";
                }
                case 4: {
                    return glos.getDefinition();
                }
            }
        }
        if (element instanceof INamedCommentedElement) {
            INamedCommentedElement ncElem = (INamedCommentedElement)element;
            switch (column) {
                case 3: {
                    return ncElem.getName();
                }
                case 5: {
                    return ncElem.getComment();
                }
            }
        }
        return null;
    }

    public boolean isEditable(int column) {
        return column > 0;
    }

    public boolean isElementEditable(int column, IHierarchicElement element) {
        if (element instanceof Requirement) {
            return column >= 1;
        }
        if (element instanceof GlossaryEntry) {
            return column >= 3;
        }
        if (element instanceof INamedCommentedElement) {
            return column == 3 || column == 5;
        }
        return false;
    }

    public void updateValue(IHierarchicElement element, int column, Object value) {
        ICommandStackService css = ICommandStackService.getInstance();
        if (element instanceof GlossaryEntry) {
            GlossaryEntry gEntry = (GlossaryEntry)element;
            if (column == 4) {
                css.runAsCommand((EObject)gEntry, () -> gEntry.setDefinition((String)value));
            }
        } else if (element instanceof Requirement) {
            Requirement req = (Requirement)element;
            switch (column) {
                case 1: {
                    css.runAsCommand((EObject)req, () -> req.setStatus((RequirementStatus)value));
                    break;
                }
                case 2: {
                    css.runAsCommand((EObject)req, () -> req.setReqId((String)value));
                    break;
                }
                case 4: {
                    css.runAsCommand((EObject)req, () -> req.setDescription((String)value));
                }
            }
        }
        if (element instanceof INamedCommentedElement) {
            INamedCommentedElement ncElem = (INamedCommentedElement)element;
            switch (column) {
                case 3: {
                    css.runAsCommand((EObject)ncElem, () -> ncElem.setName((String)value));
                    break;
                }
                case 5: {
                    css.runAsCommand((EObject)ncElem, () -> ncElem.setComment((String)value));
                }
            }
        }
        super.updateValue((Object)element, column, value);
    }

    public Node getIconNode(IHierarchicElement element, int column) {
        if (column == 0) {
            return IModelElementHandlerService.getInstance().getFXIcon((EObject)element);
        }
        return null;
    }

    public boolean dropClipboardContent(IHierarchicElement element, Dragboard dragboard) {
        return FXDNDUtils.compose((Dragboard)dragboard, (EObject)element);
    }

    public boolean dragOver(IHierarchicElement item, Dragboard dragboard) {
        return FXDNDUtils.canCompose((Dragboard)dragboard, (EObject)item);
    }
}

