/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.ui.utils;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.fortiss.af3.mira.model.Analysis;
import org.fortiss.af3.mira.model.Requirement;
import org.fortiss.af3.mira.model.glossary.Glossary;
import org.fortiss.af3.mira.ui.action.CreateGlossaryEntryAction;
import org.fortiss.af3.mira.ui.editor.highlight.ConnectionHighlightConfiguration;
import org.fortiss.tooling.base.ui.ToolingBaseUIActivator;
import org.fortiss.tooling.base.ui.dialog.ElementTreeSingleSelectDialog;
import org.fortiss.tooling.base.ui.dialog.ModelElementTreeContentProvider;
import org.fortiss.tooling.kernel.ui.presentation.ModelElementLabelProvider;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class HighlightUtils {
    public static SourceViewer createSourceViewer(ScrolledForm form, Composite parent, int styles, Analysis analysis) {
        return HighlightUtils.createSourceViewer(form, parent, styles, analysis, null);
    }

    public static SourceViewer createSourceViewer(ScrolledForm form, Composite parent, int styles, Analysis analysis, Requirement req) {
        SourceViewer viewer = new SourceViewer(parent, null, styles);
        viewer.setDocument((IDocument)new Document());
        viewer.configure((SourceViewerConfiguration)new ConnectionHighlightConfiguration(viewer, analysis));
        Menu menu = new Menu((Decorations)parent.getShell(), 8);
        StyledText editor = viewer.getTextWidget();
        HighlightUtils.createMenuItem(menu, "Create glossary entry", HighlightUtils.createGlossaryEntryCommand(form, analysis, viewer, editor));
        HighlightUtils.createMenuItem(menu, "Cut", () -> editor.invokeAction(131199));
        HighlightUtils.createMenuItem(menu, "Copy", () -> editor.invokeAction(17039369));
        HighlightUtils.createMenuItem(menu, "Paste", () -> editor.invokeAction(16908297));
        editor.setMenu(menu);
        return viewer;
    }

    public static SourceViewer createSimpleSourceViewer(ScrolledForm form, Composite parent, int styles, Analysis analysis) {
        SourceViewer viewer = new SourceViewer(parent, null, styles);
        viewer.setDocument((IDocument)new Document());
        viewer.configure((SourceViewerConfiguration)new ConnectionHighlightConfiguration(viewer, analysis));
        Menu menu = new Menu((Decorations)parent.getShell(), 8);
        StyledText editor = viewer.getTextWidget();
        HighlightUtils.createMenuItem(menu, "Cut", () -> editor.invokeAction(131199));
        HighlightUtils.createMenuItem(menu, "Copy", () -> editor.invokeAction(17039369));
        HighlightUtils.createMenuItem(menu, "Paste", () -> editor.invokeAction(16908297));
        editor.setMenu(menu);
        return viewer;
    }

    private static Runnable createGlossaryEntryCommand(ScrolledForm form, Analysis analysis, SourceViewer viewer, StyledText editor) {
        return () -> {
            String selectedText = HighlightUtils.confirmSelectedWord(form, viewer, editor, "glossary entry");
            if (selectedText != null && selectedText.length() > 0) {
                new CreateGlossaryEntryAction(analysis, selectedText, editor.getShell()).run();
            }
        };
    }

    public static boolean emptyParameterNameExists(String selectedText) {
        if (selectedText == null || selectedText.length() == 0 || selectedText.trim().length() == 0) {
            Status status = new Status(4, ToolingBaseUIActivator.PLUGIN_ID, 0, "A Parameter with empty name is not valid.", null);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", null, (IStatus)status);
            return true;
        }
        return false;
    }

    private static void createMenuItem(Menu menu, String description, final Runnable r) {
        MenuItem pasteItem = new MenuItem(menu, 8);
        pasteItem.setText(description);
        pasteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                r.run();
            }
        });
    }

    public static int match(String editorWord, String modelString, ITextViewer textViewer, IRegion hoverRegion, boolean onlyCheckFrontPart) {
        if (modelString == null) {
            return -1;
        }
        modelString = modelString.toLowerCase();
        if ((editorWord = editorWord.toLowerCase()).equals(modelString)) {
            return 0;
        }
        int pos = -1;
        while ((pos = modelString.indexOf(editorWord, pos + 1)) > -1 && pos < modelString.length()) {
            int startPos = hoverRegion.getOffset() - pos;
            if (startPos < 0 || startPos + modelString.length() > textViewer.getDocument().getLength() && !onlyCheckFrontPart) continue;
            try {
                String viewerString = "";
                if (onlyCheckFrontPart) {
                    viewerString = textViewer.getDocument().get(startPos, pos + hoverRegion.getLength());
                    modelString = modelString.substring(0, pos + hoverRegion.getLength());
                } else {
                    viewerString = textViewer.getDocument().get(startPos, modelString.length());
                }
                if (!viewerString.equalsIgnoreCase(modelString)) continue;
                return pos;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static Glossary openGlossaryDialog(Shell shell, Analysis analysis, EObject selected) {
        List<Analysis> root = Arrays.asList(analysis);
        ElementTreeSingleSelectDialog dialog = new ElementTreeSingleSelectDialog(shell, root, selected, (ITreeContentProvider)new ModelElementTreeContentProvider(root){

            public List<? extends EObject> getChildren(EObject parent) {
                return EcoreUtils.pickInstanceOf(Glossary.class, (List)super.getChildren(parent));
            }
        }, (ILabelProvider)new ModelElementLabelProvider(), null){

            public boolean acceptElement(Object element) {
                return element instanceof Glossary;
            }
        };
        if (dialog.open() == 0 && dialog.getSelectedElement() instanceof Glossary) {
            return (Glossary)dialog.getSelectedElement();
        }
        return null;
    }

    public static IRegion findWord(IDocument document, int offset) {
        int start = -2;
        int end = -1;
        if (offset < 0) {
            return null;
        }
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException x) {
            x.printStackTrace();
        }
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    public static List<ICompletionProposal> removeDuplicateICompletionProposal(List<ICompletionProposal> proposalList) {
        int i = 1;
        while (i < proposalList.size()) {
            if (proposalList.get(i - 1).getDisplayString().length() < 1 || proposalList.get(i - 1).getDisplayString().equalsIgnoreCase(proposalList.get(i).getDisplayString())) {
                proposalList.remove(i - 1);
                --i;
            }
            ++i;
        }
        return proposalList;
    }

    public static String confirmSelectedWord(ScrolledForm form, SourceViewer viewer, StyledText editor, String toCreateElement) {
        String selectedText = editor.getSelectionText();
        if (selectedText.equals("")) {
            IRegion caretRegion;
            block5: {
                try {
                    caretRegion = HighlightUtils.findWord(viewer.getDocument(), editor.getCaretOffset());
                    if (caretRegion != null && caretRegion.getLength() >= 1) break block5;
                    MessageDialog.openError((Shell)form.getForm().getBody().getShell(), (String)"No information", (String)("There is no information to create " + toCreateElement));
                    return null;
                }
                catch (BadLocationException e1) {
                    return null;
                }
            }
            selectedText = viewer.getDocument().get(caretRegion.getOffset(), caretRegion.getLength());
            if (!MessageDialog.openConfirm((Shell)form.getForm().getBody().getShell(), (String)"No selected information", (String)("There is no selected information.\nWould you like to create " + toCreateElement + " with \"" + selectedText + "\""))) {
                return null;
            }
        }
        return selectedText;
    }
}

