/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.mira.ui.editor.test;

import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.forms.finder.SWTFormsBot;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.forms.widgets.Section;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class EditorTest {
    private static final String AF3_PROJECT = "AF3-Project";
    private static final String REQUIREMENT_ANALYSIS = "Requirements Analysis";
    private static final String REQUIREMENT_SOURCE = "Requirement Sources";
    private static final String GLOSSARY = "Glossary";
    private static final String REQUIREMENT_NAME = "(1) - SWTBot Requirement Test Title";
    private static final String USECASE_NAME = "(1)(1) - SWTBot Use Case Test Title";
    private static final String SCENARIO_NAME = "SWT Bot Test Scenario";
    private static SWTWorkbenchBot bot;
    private static SWTFormsBot botF;

    @BeforeClass
    public static void beforeClass() {
        SWTBotPreferences.PLAYBACK_DELAY = 100L;
        SWTBotPreferences.TYPE_INTERVAL = 0;
        bot = new SWTWorkbenchBot();
        botF = new SWTFormsBot();
        bot.sleep(1000L);
    }

    @Test
    public void testMiraEditor() throws Exception {
        bot.viewByTitle("Welcome").close();
        this.canCreateANewAF320Project();
        SWTBotView viewModelNavigator = bot.viewByTitle("Model Navigator");
        SWTBotTreeItem treeItemAF3Project = viewModelNavigator.bot().tree().getTreeItem(AF3_PROJECT);
        this.canCreateARequirementAnalysis(treeItemAF3Project);
        this.canSave();
        SWTBotTreeItem treeItemRequirementAnaysis = treeItemAF3Project.expand().getNode(REQUIREMENT_ANALYSIS);
        this.canCreateAGlossary(treeItemRequirementAnaysis);
        SWTBotTreeItem treeItemGlossary = treeItemRequirementAnaysis.expand().getNode(GLOSSARY);
        SWTBotEditor editorGlossary = bot.editorByTitle(GLOSSARY);
        this.canCreateAGlossaryEntry(treeItemGlossary);
        SWTBotEditor editorGlossaryEntry = bot.editorByTitle("<New entry>");
        this.canFillGlossaryEntry(editorGlossaryEntry);
        this.canFilterGlossaryEntry(editorGlossary);
        this.canCreateARequirementsSouce(treeItemRequirementAnaysis);
        SWTBotTreeItem treeItemRequirementSource = treeItemRequirementAnaysis.expand().getNode(REQUIREMENT_SOURCE);
        this.canCreateAStakeholder(treeItemRequirementSource);
        SWTBotEditor editorRequirementSource = bot.editorByTitle(REQUIREMENT_SOURCE);
        SWTBotEditor editorStakeholder = bot.editorByTitle("<New stakeholder>");
        this.canFillStakeholder(editorStakeholder);
        this.canCreateAndEditParticipants(editorStakeholder);
        this.canCreateARequirementDocument(treeItemRequirementSource);
        SWTBotEditor editorRequirementDocument = bot.editorByTitle("<New document>");
        this.canFillRequirementDocument(editorRequirementDocument);
        this.canCreateAndEditLocalFile(editorRequirementDocument);
        this.canCreateAndEditFileLink(editorRequirementDocument);
        this.canCreateAExternalSystem(treeItemRequirementSource);
        SWTBotEditor editorExternalSystem = bot.editorByTitle("<New external system>");
        this.canFillExternalSystem(editorExternalSystem);
        this.canFilterRequirementSourceElement(editorRequirementSource);
        this.canCreateARequirement(treeItemRequirementAnaysis);
        SWTBotEditor editorRequirement = bot.editorByTitle("(1)");
        this.canFillGeneralInformationRequirementEditor(editorRequirement);
        editorRequirement = bot.editorByTitle(REQUIREMENT_NAME);
        this.testRightClickMenuInRequirement(editorRequirement);
        this.canAssignRelationsRequirementEditor(editorRequirement);
        this.canFillCommentInformationRequirementEditor(editorRequirement);
        this.canExecuteRequirementsActions(editorRequirement);
        SWTBotTreeItem treeItemRequirement = treeItemRequirementAnaysis.expand().getNode(REQUIREMENT_NAME);
        editorRequirement = this.canChangeRequirementToUseCase(editorRequirement);
        this.canCreateAScenario(treeItemRequirement);
        bot.sleep(1000L);
        editorRequirement = this.canChangeUseCaseToRequirement(editorRequirement);
        editorRequirement.saveAndClose();
        this.canCreateAnUseCase(treeItemRequirementAnaysis);
        SWTBotEditor editorUseCase = bot.editorByTitle("(1)(1)");
        this.canFillGeneralInformationUseCaseEditor(editorUseCase);
        editorUseCase = bot.editorByTitle(USECASE_NAME);
        this.canFillDetailInformationUseCaseEditor(editorUseCase);
        editorUseCase.save();
        this.canCreateComponent(treeItemAF3Project);
        this.canAssignScopeToUseCase(editorUseCase);
        this.canAssignActorToUseCase(editorUseCase);
        this.canAssignRelationsUseCaseEditor(editorUseCase);
        this.canFillCommentInformationUseCaseEditor(editorUseCase);
        this.canExecuteUseCaseActions(editorUseCase);
        SWTBotTreeItem treeItemUseCase = treeItemRequirementAnaysis.expand().getNode(USECASE_NAME);
        this.canCreateAScenario(treeItemUseCase);
        SWTBotEditor editorScenario = bot.editorByTitle("Scenario (No name)");
        this.canFillOutScenarioBasicInformaiton(editorScenario);
        this.canCreateAndEditScenarioSteps(editorScenario);
        this.canMoveAndRemoveScenarioSteps(editorScenario);
        treeItemUseCase.doubleClick();
        editorUseCase = this.canChangeUseCaseToRequirement(editorUseCase);
        bot.sleep(200L);
        editorUseCase = this.canChangeRequirementToUseCase(editorUseCase);
        this.canCreateAScenario(treeItemUseCase);
        bot.sleep(200L);
        this.canSave();
        bot.sleep(200L);
    }

    private void canCreateANewAF320Project() throws Exception {
        bot.perspectiveByLabel("Modeling").activate();
        bot.sleep(1000L);
        bot.menu("File").menu("New AF3 Project").click();
        bot.sleep(1000L);
    }

    private void canCreateARequirementAnalysis(SWTBotTreeItem treeItemAF3_PROJECT) throws Exception {
        treeItemAF3_PROJECT.contextMenu(REQUIREMENT_ANALYSIS).click();
    }

    private void canCreateAGlossary(SWTBotTreeItem treeItemRequirementAnaysis) throws Exception {
        treeItemRequirementAnaysis.contextMenu(GLOSSARY).click();
        treeItemRequirementAnaysis.expand().getNode(GLOSSARY).click();
    }

    private void canCreateAGlossaryEntry(SWTBotTreeItem treeItemGlossary) throws Exception {
        treeItemGlossary.contextMenu("Entry").click();
        treeItemGlossary.expand().getNode("<New entry>").click();
    }

    private void canFillGlossaryEntry(SWTBotEditor editorGlossaryEntry) throws Exception {
        editorGlossaryEntry.bot().textWithLabel("Name ").typeText("glossary entry");
        Assert.assertEquals((Object)editorGlossaryEntry.bot().textWithLabel("Name ").getText(), (Object)"glossary entry");
        editorGlossaryEntry.bot().styledTextWithLabel("Definition ").typeText("glossary entry definition");
        Assert.assertEquals((Object)editorGlossaryEntry.bot().styledTextWithLabel("Definition ").getText(), (Object)"glossary entry definition");
    }

    private void canFilterGlossaryEntry(SWTBotEditor editorGlossary) {
        editorGlossary.show();
        Assert.assertEquals((long)1L, (long)editorGlossary.bot().tree().getAllItems().length);
        editorGlossary.bot().textWithLabel("Filter: ").typeText("false");
        Assert.assertEquals((long)0L, (long)editorGlossary.bot().tree().getAllItems().length);
        editorGlossary.close();
    }

    private void canCreateARequirementsSouce(SWTBotTreeItem treeItemRequirementAnaysis) throws Exception {
        treeItemRequirementAnaysis.setFocus();
        treeItemRequirementAnaysis.contextMenu(REQUIREMENT_SOURCE).click();
        treeItemRequirementAnaysis.expand().getNode(REQUIREMENT_SOURCE).click();
    }

    private void canCreateAStakeholder(SWTBotTreeItem treeItemRequirementSource) throws Exception {
        treeItemRequirementSource.contextMenu("Stakeholder").click();
        treeItemRequirementSource.expand().getNode("<New stakeholder>").click();
    }

    private void canFillStakeholder(SWTBotEditor editorStakeholder) throws Exception {
        editorStakeholder.bot().textWithLabel("Name ").typeText("stakeholder");
        Assert.assertEquals((Object)editorStakeholder.bot().textWithLabel("Name ").getText(), (Object)"stakeholder");
        editorStakeholder.bot().styledTextWithLabel("Definition ").typeText("stakeholder description");
        Assert.assertEquals((Object)editorStakeholder.bot().styledTextWithLabel("Definition ").getText(), (Object)"stakeholder description");
    }

    private void canCreateAndEditParticipants(SWTBotEditor editorStakeholder) throws Exception {
        editorStakeholder.show();
        editorStakeholder.bot().button("Add").click();
        editorStakeholder.bot().table().click(0, 0);
        editorStakeholder.bot().text("<name>").setText("SWT Bot");
        editorStakeholder.bot().table().click(0, 1);
        editorStakeholder.bot().text("").setText("xx@xx.com");
        editorStakeholder.bot().table().click(0, 2);
        editorStakeholder.bot().text("").setText("0890000000");
        editorStakeholder.bot().table().click(0, 3);
        editorStakeholder.bot().text("").setText("0176000000");
        editorStakeholder.bot().button("Add").click();
        editorStakeholder.bot().table().click(1, 0);
        editorStakeholder.bot().button("Move Up").click();
        editorStakeholder.bot().table().click(1, 3);
        Assert.assertEquals((String)"Stakeholder with Mobile Nr. \" 0176000000 \" should be in the second row", (Object)"0176000000", (Object)editorStakeholder.bot().table().getTableItem(1).getText(3));
        editorStakeholder.bot().table().click(0, 0);
        editorStakeholder.bot().button("Move Down").click();
        editorStakeholder.bot().table().click(1, 0);
        editorStakeholder.bot().table().click(0, 3);
        Assert.assertEquals((String)"Stakeholder with Mobile Nr. \" 0176000000 \" should be in the first row", (Object)"0176000000", (Object)editorStakeholder.bot().table().getTableItem(0).getText(3));
        editorStakeholder.bot().table().click(1, 0);
        editorStakeholder.bot().button("Remove").click();
        editorStakeholder.bot().table().click(0, 0);
        editorStakeholder.bot().button("Remove").click();
        Assert.assertEquals((String)"Number of rows should be zero, since no step should exist", (long)0L, (long)editorStakeholder.bot().table().rowCount());
    }

    private void canCreateARequirementDocument(SWTBotTreeItem treeItemRequirementSource) throws Exception {
        treeItemRequirementSource.contextMenu("Document").click();
        treeItemRequirementSource.expand().getNode("<New document>").click();
    }

    private void canFillRequirementDocument(SWTBotEditor editorRequirementDocument) throws Exception {
        editorRequirementDocument.bot().textWithLabel("Name ").typeText("RequirementDocument");
        Assert.assertEquals((Object)editorRequirementDocument.bot().textWithLabel("Name ").getText(), (Object)"RequirementDocument");
        editorRequirementDocument.bot().styledTextWithLabel("Definition ").typeText("requirement document description");
        Assert.assertEquals((Object)editorRequirementDocument.bot().styledTextWithLabel("Definition ").getText(), (Object)"requirement document description");
    }

    private void canCreateAndEditLocalFile(SWTBotEditor editorRequirementDocument) throws Exception {
        editorRequirementDocument.show();
        Assert.assertEquals((Object)editorRequirementDocument.bot().button(0).getText(), (Object)"Add a local file");
    }

    private void canCreateAndEditFileLink(SWTBotEditor editorRequirementDocument) throws Exception {
        editorRequirementDocument.show();
        editorRequirementDocument.bot().button("Add a file link").click();
        bot.text().typeText("fortiss");
        bot.button("OK").click();
        editorRequirementDocument.show();
        editorRequirementDocument.bot().button("Edit link", 0).click();
        bot.text().typeText("www.fortiss.de");
        bot.button("OK").click();
        Assert.assertEquals((Object)botF.hyperlink(0).getText(), (Object)"http://www.fortiss.de");
    }

    private void canCreateAExternalSystem(SWTBotTreeItem treeItemRequirementSource) throws Exception {
        treeItemRequirementSource.contextMenu("External System").click();
        treeItemRequirementSource.expand().getNode("<New external system>").click();
    }

    private void canFillExternalSystem(SWTBotEditor editorExternalSystem) throws Exception {
        editorExternalSystem.bot().textWithLabel("Name ").typeText("externalSystem");
        Assert.assertEquals((Object)editorExternalSystem.bot().textWithLabel("Name ").getText(), (Object)"externalSystem");
        editorExternalSystem.bot().styledTextWithLabel("Definition ").typeText("external system description");
        Assert.assertEquals((Object)editorExternalSystem.bot().styledTextWithLabel("Definition ").getText(), (Object)"external system description");
        editorExternalSystem.bot().styledText("").typeText("external system comment");
        Assert.assertEquals((Object)editorExternalSystem.bot().styledText("external system comment").getText(), (Object)"external system comment");
        editorExternalSystem.save();
    }

    private void canFilterRequirementSourceElement(SWTBotEditor editorRequirementSource) {
        editorRequirementSource.show();
        Assert.assertEquals((long)3L, (long)editorRequirementSource.bot().tree().rowCount());
        editorRequirementSource.bot().textWithLabel("Filter: ").typeText("external");
        Assert.assertEquals((long)1L, (long)editorRequirementSource.bot().tree().rowCount());
        editorRequirementSource.bot().tree().getTreeItem("External system").doubleClick();
        Assert.assertEquals((Object)bot.activeEditor().bot().styledTextWithLabel("Definition ").getText(), (Object)"external system description");
    }

    private void canCreateARequirement(SWTBotTreeItem treeItemRequirementAnaysis) throws Exception {
        treeItemRequirementAnaysis.contextMenu("Requirement").click();
        treeItemRequirementAnaysis.expand().getNode("(1)").click();
    }

    private void canFillGeneralInformationRequirementEditor(SWTBotEditor editor) throws Exception {
        editor.bot().styledTextWithLabel("Title ").typeText("SWTBot Requirement Test Title");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Title ").getText(), (Object)"SWTBot Requirement Test Title");
        editor.bot().styledTextWithLabel("Description ").typeText("SWTBot Requirement Test Description");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Description ").getText(), (Object)"SWTBot Requirement Test Description");
        editor.bot().styledTextWithLabel("Rationale ").typeText("SWTBot Requirement Test Rationale");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Rationale ").getText(), (Object)"SWTBot Requirement Test Rationale");
        editor.bot().styledTextWithLabel("Author ").typeText("SWTBot Requirement Test Author");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Author ").getText(), (Object)"SWTBot Requirement Test Author");
        editor.bot().styledTextWithLabel("Source ").typeText("SWTBot Requirement Test Source");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Source ").getText(), (Object)"SWTBot Requirement Test Source");
        editor.bot().styledTextWithLabel("Todo ").typeText("SWTBot Requirement Test ToDo");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Todo ").getText(), (Object)"SWTBot Requirement Test ToDo");
        editor.bot().comboBoxWithLabel("Status ").setSelection("Analyzed");
        Assert.assertEquals((Object)editor.bot().comboBoxWithLabel("Status ").getText(), (Object)"Analyzed");
        editor.bot().comboBoxWithLabel("Priority ").setSelection("High - Must-be");
        Assert.assertEquals((Object)editor.bot().comboBoxWithLabel("Priority ").getText(), (Object)"High - Must-be");
    }

    private void testRightClickMenuInRequirement(SWTBotEditor editorRequirement) {
        editorRequirement.show();
        editorRequirement.bot().styledTextWithLabel("Description ").setFocus();
        editorRequirement.bot().styledTextWithLabel("Description ").selectRange(0, 0, 6);
        editorRequirement.bot().styledTextWithLabel("Description ").contextMenu("Create stakeholder").click();
        SWTBotEditor editorSWTBotStakeholder = bot.editorByTitle("SWTBot");
        editorSWTBotStakeholder.close();
        editorRequirement.show();
        editorRequirement.bot().styledTextWithLabel("Description ").setFocus();
        editorRequirement.bot().styledTextWithLabel("Description ").selectRange(0, 7, 11);
        editorRequirement.bot().styledTextWithLabel("Description ").contextMenu("Create document").click();
        SWTBotEditor editorrequirementdocument = bot.editorByTitle("Requirement");
        editorrequirementdocument.close();
        editorRequirement.show();
        editorRequirement.bot().styledTextWithLabel("Description ").setFocus();
        editorRequirement.bot().styledTextWithLabel("Description ").selectRange(0, 19, 4);
        editorRequirement.bot().styledTextWithLabel("Description ").contextMenu("Create glossary entry").click();
        SWTBotEditor editorTestGlossaryEntry = bot.editorByTitle("Test");
        editorTestGlossaryEntry.close();
        editorRequirement.show();
        editorRequirement.bot().styledTextWithLabel("Description ").setFocus();
        editorRequirement.bot().styledTextWithLabel("Description ").selectRange(0, 24, 11);
        editorRequirement.bot().styledTextWithLabel("Description ").contextMenu("Create external system").click();
        SWTBotEditor editorDescription = bot.editorByTitle("Description");
        editorDescription.close();
        editorRequirement.show();
    }

    private void canAssignRelationsRequirementEditor(SWTBotEditor editor) throws Exception {
        editor.show();
        editor.bot().button("Add", 1).click();
        editor.setFocus();
        Assert.assertNotNull((String)"A conflicted relation should have been added", (Object)editor.bot().table().getTableItem("is conflicted with"));
        editor.bot().table().click(0, 0);
        editor.bot().ccomboBox("is conflicted with").setSelection("refines");
        Assert.assertEquals((String)"The conflict relation should have been changed to a \"refines\" relation", (Object)"refines", (Object)editor.bot().ccomboBox().getText());
        bot.sleep(1000L);
        editor.bot().button("Remove").click();
        Assert.assertEquals((String)"Number of rows should be zero, since no step should exist", (long)0L, (long)editor.bot().table().rowCount());
    }

    private void canFillCommentInformationRequirementEditor(SWTBotEditor editor) throws Exception {
        editor = bot.editorByTitle(REQUIREMENT_NAME);
        editor.bot().styledText("").typeText("SWTBot Requirement Test Comment");
        Assert.assertEquals((Object)"SWTBot Requirement Test Comment", (Object)editor.bot().styledText("SWTBot Requirement Test Comment").getText());
        editor.save();
    }

    private void canExecuteRequirementsActions(SWTBotEditor editor) throws Exception {
        editor.bot().toolbarButtonWithTooltip("Show Requirement Hierarchy").click();
        editor.bot().toolbarButtonWithTooltip("Review Requirements").click();
        bot.button("OK").click();
        editor.save();
    }

    private SWTBotEditor canChangeRequirementToUseCase(SWTBotEditor editor) throws Exception {
        editor.show();
        editor.bot().comboBoxWithLabel("Type ").setSelection("UseCase");
        bot.button("OK").click();
        editor = bot.activeEditor();
        Assert.assertEquals((Object)editor.bot().comboBoxWithLabel("Type ").getText(), (Object)"UseCase");
        return editor;
    }

    private SWTBotEditor canChangeUseCaseToRequirement(SWTBotEditor editor) throws Exception {
        editor.show();
        editor.bot().comboBoxWithLabel("Type ").setSelection("Requirement");
        bot.sleep(500L);
        bot.button("OK").click();
        editor = bot.activeEditor();
        Assert.assertEquals((Object)editor.bot().comboBoxWithLabel("Type ").getText(), (Object)"Requirement");
        return editor;
    }

    private void canCreateAnUseCase(SWTBotTreeItem treeItemRquirementAnaysis) throws Exception {
        treeItemRquirementAnaysis.contextMenu("Use Case").click();
    }

    private void canFillGeneralInformationUseCaseEditor(SWTBotEditor editor) throws Exception {
        editor.bot().styledTextWithLabel("Title ").setFocus();
        editor.bot().styledTextWithLabel("Title ").typeText("SWTBot Use Case Test Title");
        editor.bot().styledTextWithLabel("Description ").typeText("SWTBot Use Case Test Description");
        editor.bot().styledTextWithLabel("Rationale ").typeText("SWTBot Use Case Test Rationale ");
        editor.bot().styledTextWithLabel("Author ").typeText("SWTBot Use Case Test Author");
        editor.bot().styledTextWithLabel("Source ").typeText("SWTBot Use Case Test Source");
        editor.bot().styledTextWithLabel("Todo ").typeText("SWTBot Use Case Test ToDo");
        editor.bot().comboBoxWithLabel("Status ").setSelection("Analyzed");
        editor.bot().comboBoxWithLabel("Priority ").setSelection("High - Must-be");
    }

    private void canFillDetailInformationUseCaseEditor(SWTBotEditor editor) throws Exception {
        editor.bot().styledTextWithLabel("Scope ").typeText("SWTBot Use Case Test Scope");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Scope ").getText(), (Object)"SWTBot Use Case Test Scope");
        editor.bot().styledTextWithLabel("Trigger(s) ").typeText("SWTBot Use Case Test Trigger");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Trigger(s) ").getText(), (Object)"SWTBot Use Case Test Trigger");
        editor.bot().styledTextWithLabel("Precondition ").typeText("SWTBot Use Case Test Rationale");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Precondition ").getText(), (Object)"SWTBot Use Case Test Rationale");
        editor.bot().styledTextWithLabel("Input(s) ").typeText("SWTBot Use Case Test Input");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Input(s) ").getText(), (Object)"SWTBot Use Case Test Input");
        editor.bot().styledTextWithLabel("Output(s) ").typeText("SWTBot Use Case Test Output");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Output(s) ").getText(), (Object)"SWTBot Use Case Test Output");
        editor.bot().styledTextWithLabel("Minimal guarantees ").typeText("SWTBot Use Case Test min guarantees");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Minimal guarantees ").getText(), (Object)"SWTBot Use Case Test min guarantees");
        editor.bot().styledTextWithLabel("Success guarantees ").typeText("SWTBot Use Case Test suc. guarantees");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Success guarantees ").getText(), (Object)"SWTBot Use Case Test suc. guarantees");
    }

    private void canCreateComponent(SWTBotTreeItem treeItemAF3Project) throws Exception {
        treeItemAF3Project.contextMenu("Component Architecture").click();
        treeItemAF3Project.getNode("Component Architecture").contextMenu("Component").click();
        bot.activeEditor().save();
    }

    private void canAssignScopeToUseCase(SWTBotEditor editor) throws Exception {
        editor.show();
        editor.bot().button(1).click();
        SWTBotShell shell = bot.activeShell();
        shell.bot().tree().expandNode(new String[]{"Component Architecture"}).select("Component");
        shell.bot().button("OK").click();
    }

    private void canAssignActorToUseCase(SWTBotEditor editor) throws Exception {
        editor.show();
        editor.bot().button(2).click();
        SWTBotShell shell = bot.activeShell();
        shell.bot().tree().expandNode(new String[]{REQUIREMENT_ANALYSIS}).select(REQUIREMENT_SOURCE);
        shell.bot().button(0).click();
        bot.button("Stakeholder").click();
        bot.text("<new Stakeholder>").setText("Actor_1");
        bot.button("OK").click();
        shell.bot().button(0).click();
        bot.button("Stakeholder").click();
        bot.text("<new Stakeholder>").setText("Actor_2");
        bot.button("OK").click();
        shell.bot().button(0).click();
        bot.button("External System").click();
        bot.text("<new External System>").setText("Actor_3");
        bot.button("OK").click();
        shell.bot().tree().expandNode(new String[]{REQUIREMENT_ANALYSIS}).expandNode(new String[]{REQUIREMENT_SOURCE}).select("Actor_2");
        shell.bot().button(1).click();
        bot.button("OK").click();
        shell.bot().tree().expandNode(new String[]{REQUIREMENT_ANALYSIS}).expandNode(new String[]{REQUIREMENT_SOURCE}).select("Actor_1");
        shell.bot().button(2).click();
        bot.text("Actor_1").setText("Hector");
        bot.button("OK").click();
        shell.bot().tree().expandNode(new String[]{REQUIREMENT_ANALYSIS}).expandNode(new String[]{REQUIREMENT_SOURCE}).select("Hector");
        shell.bot().button(">>").click();
        shell.bot().tree().expandNode(new String[]{REQUIREMENT_ANALYSIS}).expandNode(new String[]{REQUIREMENT_SOURCE}).select("Actor_3");
        shell.bot().button(">>").click();
        shell.bot().tree(1).select(new String[]{"Actor_3"});
        shell.bot().button("<<").click();
        shell.bot().button("OK").click();
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Actor(s) ").getText(), (Object)"Hector");
    }

    private void canAssignRelationsUseCaseEditor(SWTBotEditor editor) throws Exception {
        editor.show();
        editor.bot().button("Add", 1).click();
        SWTBot mybot = new SWTBot((Widget)((Section)editor.bot().widget(WidgetMatcherFactory.allOf((Matcher[])new Matcher[]{WidgetMatcherFactory.widgetOfType(Section.class), WidgetMatcherFactory.withMnemonic((String)"Related Requirements")}))));
        SWTBotTable table = mybot.table();
        Assert.assertNotNull((String)"A conflicted relation should have been added", (Object)table.getTableItem("is conflicted with"));
        table.click(0, 0);
        editor.bot().ccomboBox("is conflicted with").setSelection("refines");
        Assert.assertEquals((String)"The conflict relation should have been changed to a \"refines\" relation", (Object)"refines", (Object)editor.bot().ccomboBox().getText());
        editor.bot().button("Remove").click();
        Assert.assertEquals((String)"Number of rows should be zero, since no step should exist", (long)0L, (long)table.rowCount());
        editor.bot().button("Add", 1).click();
    }

    private void canFillCommentInformationUseCaseEditor(SWTBotEditor editor) throws Exception {
        editor.bot().styledText("", 0).setFocus();
        editor.bot().styledText("", 0).typeText("SWTBot UseCase Test Comment");
        Assert.assertEquals((Object)editor.bot().styledText("SWTBot UseCase Test Comment").getText(), (Object)"SWTBot UseCase Test Comment");
    }

    private void canExecuteUseCaseActions(SWTBotEditor editor) throws Exception {
        editor.bot().toolbarButtonWithTooltip("Show Requirement Hierarchy").click();
    }

    private void canCreateAScenario(SWTBotTreeItem treeItemUseCase) throws Exception {
        treeItemUseCase.contextMenu("Scenario").click();
    }

    private void canFillOutScenarioBasicInformaiton(SWTBotEditor editorScenario) throws Exception {
        editorScenario.bot().textWithLabel("Name ").setText(SCENARIO_NAME);
        editorScenario.bot().checkBoxWithLabel("Success scenario ").click();
    }

    private void canCreateAndEditScenarioSteps(SWTBotEditor editorScenario) throws Exception {
        editorScenario.bot().button("Add").click();
        editorScenario.bot().table().click(0, 2);
        editorScenario.bot().button("...").click();
        bot.activeShell().bot().tree(1).select(new String[]{"Hector"});
        bot.activeShell().bot().button("OK").click();
        Assert.assertEquals((Object)editorScenario.bot().table().cell(0, 2), (Object)"Hector");
        editorScenario.bot().table().click(0, 1);
        editorScenario.bot().text("<no action>").setText("SWT Bot Test Action");
        editorScenario.bot().table().click(0, 0);
        Assert.assertEquals((Object)editorScenario.bot().table().cell(0, 1), (Object)"SWT Bot Test Action");
        editorScenario.bot().table().click(0, 3);
        editorScenario.bot().ccomboBox("").setSelection("External");
        editorScenario.bot().table().click(0, 0);
        Assert.assertEquals((Object)editorScenario.bot().table().cell(0, 3), (Object)"External");
        editorScenario.bot().table().click(0, 4);
        editorScenario.bot().ccomboBox("").setSelection(0);
        editorScenario.bot().table().click(0, 0);
        Assert.assertEquals((Object)editorScenario.bot().table().cell(0, 4), (Object)"");
    }

    private void canMoveAndRemoveScenarioSteps(SWTBotEditor editorScenario) throws Exception {
        editorScenario.bot().table().click(0, 1);
        editorScenario.bot().button("Move Up").click();
        editorScenario.bot().table().click(0, 3);
        Assert.assertEquals((String)"Scenario with action rype \" External \" should be in the first row", (Object)"External", (Object)editorScenario.bot().ccomboBox().getText());
        editorScenario.bot().button("Add").click();
        editorScenario.bot().table().click(1, 2);
        editorScenario.bot().button("...").click();
        SWTBotShell shell = bot.activeShell();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).select(REQUIREMENT_SOURCE);
        shell.bot().button(0).click();
        bot.button("Stakeholder").click();
        bot.text("<new Stakeholder>").setText("Actor_Senario");
        bot.button("OK").click();
        shell.bot().tree().expandNode(new String[]{REQUIREMENT_ANALYSIS}).expandNode(new String[]{REQUIREMENT_SOURCE}).select("Actor_Senario");
        shell.bot().button(">>").click();
        shell.bot().tree(1).select(new String[]{"Actor_Senario"});
        shell.bot().button("OK").click();
        Assert.assertEquals((Object)editorScenario.bot().table().cell(1, 2), (Object)"Actor_Senario");
        editorScenario.bot().button("Move Up").click();
        editorScenario.bot().table().click(1, 3);
        Assert.assertEquals((String)"Scenario with action rype \" External \" should be in the second row", (Object)"External", (Object)editorScenario.bot().ccomboBox().getText());
        Assert.assertEquals((Object)editorScenario.bot().table().cell(0, 2), (Object)"Actor_Senario");
        editorScenario.bot().table().click(0, 0);
        editorScenario.bot().button("Move Down").click();
        editorScenario.bot().table().click(0, 3);
        Assert.assertEquals((String)"Scenario with action rype \" External \" should be in the first row", (Object)"External", (Object)editorScenario.bot().ccomboBox().getText());
        Assert.assertEquals((Object)editorScenario.bot().table().cell(1, 2), (Object)"Actor_Senario");
        editorScenario.bot().table().click(1, 0);
        editorScenario.bot().button("Remove").click();
        editorScenario.bot().table().click(0, 0);
        editorScenario.bot().button("Remove").click();
        Assert.assertEquals((String)"Number of rows should be zero, since no step should exist", (long)0L, (long)editorScenario.bot().table().rowCount());
    }

    private void canSave() throws Exception {
        bot.menu("File").menu("Save").click();
    }
}

