/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.mira.ui.editor.test;

import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.forms.finder.SWTFormsBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class MiraHelpTest {
    private static final String AF3_PROJECT = "AF3-Project";
    private static final String REQUIREMENT_ANALYSIS = "Requirements Analysis";
    private static final String REQUIREMENT_SOURCE = "Requirement Sources";
    private static final String GLOSSARY = "Glossary";
    private static final String GLOSSARY_ENTRY = "<New entry>";
    private static final String REQUIREMENT_PACKAGE = "Requirements";
    private static final String REQUIREMENT_NAME = "1 - Requirement1";
    private static final String USECASE_NAME = "UseCase1 - SWTBot Use Case Test Title";
    private static final String SCENARIO_NAME = "SWT Bot Test Scenario";
    private static SWTWorkbenchBot bot;
    private static SWTFormsBot botF;

    @BeforeClass
    public static void beforeClass() {
        SWTBotPreferences.PLAYBACK_DELAY = 10L;
        SWTBotPreferences.TYPE_INTERVAL = 0;
        bot = new SWTWorkbenchBot();
        botF = new SWTFormsBot();
        bot.sleep(1000L);
    }

    @Test
    public void testMiraEditor() throws Exception {
        bot.viewByTitle("Welcome").close();
        this.canCreateANewAF320Project();
        SWTBotView viewModelNavigator = bot.viewByTitle("Model Navigator");
        SWTBotTreeItem treeItemAF3Project = viewModelNavigator.bot().tree().getTreeItem(AF3_PROJECT);
        this.canCreateARequirementAnalysis(treeItemAF3Project);
        SWTBotTreeItem treeItemRequirementAnalysis = treeItemAF3Project.expand().getNode(REQUIREMENT_ANALYSIS);
        Assert.assertTrue((boolean)this.canExportReport(treeItemRequirementAnalysis));
        this.canCreateAGlossary(treeItemRequirementAnalysis);
        SWTBotTreeItem treeItemGlossary = treeItemRequirementAnalysis.expand().getNode(GLOSSARY);
        SWTBotEditor editorGlossary = bot.editorByTitle(GLOSSARY);
        this.canCreateAGlossaryEntry(treeItemGlossary);
        SWTBotEditor editorGlossaryEntry = bot.editorByTitle(GLOSSARY_ENTRY);
        this.canFillAndSaveGlossaryEntry(editorGlossaryEntry);
        this.canFilterGlossaryEntry(editorGlossary);
        this.canCreateARequirementsSource(treeItemRequirementAnalysis);
        SWTBotTreeItem treeItemRequirementSource = treeItemRequirementAnalysis.expand().getNode(REQUIREMENT_SOURCE);
        this.canCreateAStakeholder(treeItemRequirementSource);
        SWTBotEditor editorStakeholder = bot.editorByTitle("<New stakeholder>");
        this.canFillAndSaveStakeholder(editorStakeholder);
        this.canCreateAndEditParticipants(editorStakeholder);
        this.canEditAbbreviationsAndSynonymsStakeholder(editorStakeholder);
        this.canFillCommentInformation(editorStakeholder);
        this.canCreateARequirementDocument(treeItemRequirementSource);
        SWTBotEditor editorRequirementDocument = bot.editorByTitle("<New document>");
        this.canFillAndSaveRequirementDocument(editorRequirementDocument);
        this.canCreateAndEditLocalFile(editorRequirementDocument);
        this.canCreateAndEditFileLink(editorRequirementDocument);
        this.canEditAbbreviationsAndSynonyms(editorRequirementDocument);
        this.canFillCommentInformation(editorRequirementDocument);
        this.canCreateAndSaveAnExternalSystem(treeItemRequirementSource);
        SWTBotEditor editorExternalSystem = bot.editorByTitle("<New external system>");
        this.canFillExternalSystem(editorExternalSystem);
        this.canEditAbbreviationsAndSynonyms(editorExternalSystem);
        this.canFillCommentInformation(editorExternalSystem);
        SWTBotEditor editorRequirementSource = bot.editorByTitle(REQUIREMENT_SOURCE);
        this.canFilterRequirementSourceElement(editorRequirementSource);
        this.canCreateARequirementsPackage(treeItemRequirementAnalysis);
        SWTBotTreeItem treeItemRequirementsPackage = treeItemRequirementAnalysis.expand().getNode(REQUIREMENT_PACKAGE);
        this.canCreateARequirement(treeItemRequirementsPackage);
        SWTBotEditor editorRequirement = bot.editorByTitle("<New requirement>");
        this.canFillGeneralInformationRequirementEditor(editorRequirement);
        editorRequirement = bot.editorByTitle(REQUIREMENT_NAME);
        this.testRightClickMenuInRequirement(editorRequirement);
        this.canFillCommentInformation(editorRequirement);
        this.canExecuteRequirementsActions(editorRequirement);
        SWTBotTreeItem treeItemRequirement = treeItemRequirementAnalysis.expand().expandNode(new String[]{REQUIREMENT_PACKAGE}).getNode(REQUIREMENT_NAME);
        this.canCreateAFormalSpecification(treeItemRequirement);
        editorRequirement = this.canChangeRequirementToUseCase(editorRequirement);
        editorRequirement = this.canChangeUseCaseToRequirement(editorRequirement);
        editorRequirement.save();
        treeItemRequirementsPackage = treeItemRequirementAnalysis.expand().getNode(REQUIREMENT_PACKAGE);
        this.canCreateAnUseCase(treeItemRequirementsPackage);
        SWTBotEditor editorUseCase = bot.editorByTitle("<New use case>");
        this.canFillGeneralInformationUseCaseEditor(editorUseCase);
        editorUseCase = bot.editorByTitle(USECASE_NAME);
        SWTBotTreeItem treeItemUseCase = treeItemRequirementsPackage.expand().getNode(USECASE_NAME);
        this.canFillDetailInformationUseCaseEditor(editorUseCase);
        this.canAssignTracesWithinUseCase(editorUseCase);
        this.canFillCommentInformationUseCaseEditor(editorUseCase);
        this.canCreateAFormalSpecification(treeItemUseCase);
        this.canAssignActorToUseCase(editorUseCase);
        this.canCreateAScenario(treeItemUseCase);
        SWTBotEditor editorScenario = bot.editorByTitle("Scenario (No name)");
        this.canFillOutScenarioBasicInformation(editorScenario);
        this.canCreateAndEditScenarioSteps(editorScenario);
        this.canMoveAndRemoveScenarioSteps(editorScenario);
        this.canCreateComponent(treeItemAF3Project);
        this.canAssignScopeToUseCase(editorUseCase);
        this.canExecuteUseCaseActions(editorUseCase);
        this.canSave();
        this.canAssignTracesWithinRequirement(editorRequirement);
        this.canAssignTracesToArchitecture(editorRequirement);
        this.canCreateRefinementSpecifications(editorRequirement);
    }

    private void canCreateANewAF320Project() throws Exception {
        bot.perspectiveByLabel("Modeling").activate();
        bot.sleep(1000L);
        bot.menu("File").menu("New AF3 Project").click();
        bot.sleep(1000L);
    }

    private void canCreateARequirementAnalysis(SWTBotTreeItem treeItemAF3_PROJECT) throws Exception {
        treeItemAF3_PROJECT.contextMenu(REQUIREMENT_ANALYSIS).click();
    }

    private void canCreateAGlossary(SWTBotTreeItem treeItemRequirementAnaysis) throws Exception {
        treeItemRequirementAnaysis.contextMenu(GLOSSARY).click();
        treeItemRequirementAnaysis.expand().getNode(GLOSSARY).click();
    }

    private void canCreateAGlossaryEntry(SWTBotTreeItem treeItemGlossary) throws Exception {
        treeItemGlossary.contextMenu("Entry").click();
        treeItemGlossary.expand().getNode(GLOSSARY_ENTRY).click();
    }

    private void canFillAndSaveGlossaryEntry(SWTBotEditor editorGlossaryEntry) throws Exception {
        editorGlossaryEntry.bot().textWithLabel("Name ").typeText("glossary entry");
        Assert.assertEquals((Object)"glossary entry", (Object)editorGlossaryEntry.bot().textWithLabel("Name ").getText());
        editorGlossaryEntry.bot().styledTextWithLabel("Definition ").typeText("glossary entry definition");
        Assert.assertEquals((Object)"glossary entry definition", (Object)editorGlossaryEntry.bot().styledTextWithLabel("Definition ").getText());
        editorGlossaryEntry.bot().comboBoxWithLabel("Status ").setFocus();
        editorGlossaryEntry.bot().comboBoxWithLabel("Status ").setSelection("Consolidated");
        editorGlossaryEntry.save();
    }

    private void canFilterGlossaryEntry(SWTBotEditor editorGlossary) {
        editorGlossary.show();
        Assert.assertEquals((long)1L, (long)editorGlossary.bot().tree().getAllItems().length);
        editorGlossary.bot().textWithLabel("Filter: ").typeText("false");
        Assert.assertEquals((long)0L, (long)editorGlossary.bot().tree().getAllItems().length);
        editorGlossary.close();
    }

    private void canCreateARequirementsSource(SWTBotTreeItem treeItemRequirementAnaysis) throws Exception {
        treeItemRequirementAnaysis.setFocus();
        treeItemRequirementAnaysis.contextMenu(REQUIREMENT_SOURCE).click();
        treeItemRequirementAnaysis.expand().getNode(REQUIREMENT_SOURCE).click();
    }

    private void canCreateAStakeholder(SWTBotTreeItem treeItemRequirementSource) throws Exception {
        treeItemRequirementSource.contextMenu("Stakeholder").click();
        treeItemRequirementSource.expand().getNode("<New stakeholder>").click();
    }

    private void canFillAndSaveStakeholder(SWTBotEditor editorStakeholder) throws Exception {
        editorStakeholder.bot().textWithLabel("Name ").typeText("stakeholder");
        Assert.assertEquals((Object)editorStakeholder.bot().textWithLabel("Name ").getText(), (Object)"stakeholder");
        editorStakeholder.bot().styledTextWithLabel("Definition ").typeText("stakeholder description");
        Assert.assertEquals((Object)editorStakeholder.bot().styledTextWithLabel("Definition ").getText(), (Object)"stakeholder description");
        editorStakeholder.bot().comboBoxWithLabel("Status ").setFocus();
        editorStakeholder.bot().comboBoxWithLabel("Status ").setSelection("Consolidated");
        editorStakeholder.save();
    }

    private void canCreateAndEditParticipants(SWTBotEditor editorStakeholder) throws Exception {
        editorStakeholder.show();
        editorStakeholder.bot().button("Add").click();
        editorStakeholder.bot().button("Add").click();
        SWTBotTable tableViewer = editorStakeholder.bot().table();
        tableViewer.click(0, 0);
        bot.text("<name>").typeText("Dongyue Mou");
        tableViewer.click(0, 1);
        bot.text("", 0).setText("aa@bb.cc");
        tableViewer.click(0, 2);
        bot.text("").typeText("123456");
        tableViewer.click(0, 3);
        bot.text("").typeText("2394826");
        tableViewer.click(1, 0);
        bot.text("<name>").typeText("Sabine Teufl");
        tableViewer.click(1, 1);
        bot.text("").setText("bb@cc.dd");
        tableViewer.click(1, 2);
        bot.text("").typeText("521234");
        tableViewer.click(1, 3);
        bot.text("").typeText("3474624");
        tableViewer.click(1, 0);
        editorStakeholder.bot().button("Move Up").click();
        Assert.assertEquals((String)"Position should have been swapped", (Object)tableViewer.cell(0, 0), (Object)"Sabine Teufl");
        tableViewer.click(0, 0);
        editorStakeholder.bot().button("Move Down").click();
        Assert.assertEquals((String)"Position should have been swapped", (Object)tableViewer.cell(0, 0), (Object)"Dongyue Mou");
        tableViewer.click(1, 0);
        editorStakeholder.bot().button("Move Up").click();
        editorStakeholder.bot().table().click(0, 0);
        editorStakeholder.bot().button("Move Down").click();
        editorStakeholder.bot().table().click(1, 0);
        tableViewer.click(1, 0);
        editorStakeholder.bot().button("Remove").click();
        tableViewer.click(0, 0);
        editorStakeholder.bot().button("Remove").click();
        Assert.assertEquals((String)"Number of rows should be zero, since no step should exist", (long)0L, (long)tableViewer.rowCount());
    }

    private void canCreateARequirementDocument(SWTBotTreeItem treeItemRequirementSource) throws Exception {
        treeItemRequirementSource.contextMenu("Document").click();
        treeItemRequirementSource.expand().getNode("<New document>").click();
    }

    private void canFillAndSaveRequirementDocument(SWTBotEditor editorRequirementDocument) throws Exception {
        editorRequirementDocument.bot().textWithLabel("Name ").typeText("RequirementDocument");
        Assert.assertEquals((Object)editorRequirementDocument.bot().textWithLabel("Name ").getText(), (Object)"RequirementDocument");
        editorRequirementDocument.bot().styledTextWithLabel("Definition ").typeText("requirement document description");
        Assert.assertEquals((Object)editorRequirementDocument.bot().styledTextWithLabel("Definition ").getText(), (Object)"requirement document description");
        editorRequirementDocument.bot().comboBoxWithLabel("Status ").setFocus();
        editorRequirementDocument.bot().comboBoxWithLabel("Status ").setSelection("Consolidated");
        editorRequirementDocument.save();
    }

    private void canCreateAndEditLocalFile(SWTBotEditor editorRequirementDocument) throws Exception {
        editorRequirementDocument.show();
        Assert.assertEquals((Object)editorRequirementDocument.bot().button(0).getText(), (Object)"Add a local file");
    }

    private void canCreateAndEditFileLink(SWTBotEditor editorRequirementDocument) throws Exception {
        editorRequirementDocument.show();
        Assert.assertTrue((boolean)editorRequirementDocument.bot().button("Add a local file").isEnabled());
        editorRequirementDocument.bot().button("Add a file link").click();
        bot.textWithLabel("Please enter a URL of the document").setFocus();
        bot.text().setText("fortiss");
        bot.button("OK").click();
        editorRequirementDocument.bot().button("Edit link", 0).click();
        bot.text().setText("www.fortiss.de");
        bot.button("OK").click();
        Assert.assertEquals((Object)botF.hyperlink(0).getText(), (Object)"http://www.fortiss.de");
        editorRequirementDocument.bot().styledTextWithLabel("File description ", 0).setText("Test File");
        Assert.assertEquals((Object)botF.styledTextWithLabel("File description ", 0).getText(), (Object)"Test File");
        editorRequirementDocument.bot().styledTextWithLabel("File version ", 0).typeText("1.0");
        editorRequirementDocument.bot().button("Remove").click();
    }

    private void canCreateAndSaveAnExternalSystem(SWTBotTreeItem treeItemRequirementSource) throws Exception {
        treeItemRequirementSource.contextMenu("External System").click();
        treeItemRequirementSource.expand().getNode("<New external system>").click();
    }

    private void canFillExternalSystem(SWTBotEditor editorExternalSystem) throws Exception {
        editorExternalSystem.bot().textWithLabel("Name ").typeText("externalSystem");
        Assert.assertEquals((Object)editorExternalSystem.bot().textWithLabel("Name ").getText(), (Object)"externalSystem");
        editorExternalSystem.bot().styledTextWithLabel("Definition ").typeText("external system description");
        Assert.assertEquals((Object)editorExternalSystem.bot().styledTextWithLabel("Definition ").getText(), (Object)"external system description");
        editorExternalSystem.bot().comboBoxWithLabel("Status ").setFocus();
        editorExternalSystem.bot().comboBoxWithLabel("Status ").setSelection("Consolidated");
        editorExternalSystem.save();
    }

    private void canEditAbbreviationsAndSynonymsStakeholder(SWTBotEditor editorStakeholder) throws Exception {
        editorStakeholder.show();
        SWTBotTable abbTable = editorStakeholder.bot().table(1);
        SWTBotTable synTable = editorStakeholder.bot().table(2);
        editorStakeholder.bot().button("Add", 1).click();
        abbTable.click(0, 0);
        bot.text("<text>").typeText("test 1");
        editorStakeholder.bot().button("Add", 1).click();
        abbTable.click(1, 0);
        bot.text("<text>").typeText("test 2");
        abbTable.click(0, 0);
        editorStakeholder.bot().button("Remove", 1).click();
        abbTable.click(0, 0);
        editorStakeholder.bot().button("Remove", 1).click();
        Assert.assertEquals((String)"Number of rows should be zero, since no step should exist", (long)0L, (long)abbTable.rowCount());
        editorStakeholder.bot().button("Add", 2).click();
        synTable.click(0, 0);
        bot.text("<text>").typeText("test 1");
        editorStakeholder.bot().button("Add", 2).click();
        synTable.click(1, 0);
        bot.text("<text>").typeText("test 2");
        synTable.click(0, 0);
        editorStakeholder.bot().button("Remove", 2).click();
        synTable.click(0, 0);
        editorStakeholder.bot().button("Remove", 2).click();
        Assert.assertEquals((String)"Number of rows should be zero, since no step should exist", (long)0L, (long)abbTable.rowCount());
    }

    private void canEditAbbreviationsAndSynonyms(SWTBotEditor editorRequirementSource) throws Exception {
        editorRequirementSource.show();
        SWTBotTable abbTable = editorRequirementSource.bot().table(0);
        SWTBotTable synTable = editorRequirementSource.bot().table(1);
        editorRequirementSource.bot().button("Add", 0).click();
        abbTable.click(0, 0);
        bot.text("<text>").typeText("test 1");
        editorRequirementSource.bot().button("Add", 0).click();
        abbTable.click(1, 0);
        bot.text("<text>").typeText("test 2");
        abbTable.click(0, 0);
        editorRequirementSource.bot().button("Remove", 0).click();
        abbTable.click(0, 0);
        editorRequirementSource.bot().button("Remove", 0).click();
        Assert.assertEquals((String)"Number of rows should be zero, since no step should exist", (long)0L, (long)abbTable.rowCount());
        editorRequirementSource.bot().button("Add", 1).click();
        synTable.click(0, 0);
        bot.text("<text>").typeText("test 1");
        editorRequirementSource.bot().button("Add", 1).click();
        synTable.click(1, 0);
        bot.text("<text>").typeText("test 2");
        synTable.click(0, 0);
        editorRequirementSource.bot().button("Remove", 1).click();
        synTable.click(0, 0);
        editorRequirementSource.bot().button("Remove", 1).click();
        Assert.assertEquals((String)"Number of rows should be zero, since no step should exist", (long)0L, (long)abbTable.rowCount());
    }

    private void canFilterRequirementSourceElement(SWTBotEditor editorRequirementSource) {
        editorRequirementSource.show();
        Assert.assertEquals((long)3L, (long)editorRequirementSource.bot().tree().rowCount());
        editorRequirementSource.bot().textWithLabel("Filter: ").typeText("external");
        Assert.assertEquals((long)1L, (long)editorRequirementSource.bot().tree().rowCount());
        editorRequirementSource.bot().tree().getTreeItem("External system").doubleClick();
        Assert.assertEquals((Object)bot.activeEditor().bot().styledTextWithLabel("Definition ").getText(), (Object)"external system description");
    }

    private void canCreateARequirementsPackage(SWTBotTreeItem treeItemRequirementAnalysis) {
        treeItemRequirementAnalysis.contextMenu(REQUIREMENT_PACKAGE).click();
    }

    private void canCreateARequirement(SWTBotTreeItem treeItemRequirementPackage) throws Exception {
        treeItemRequirementPackage.contextMenu("Requirement").click();
        treeItemRequirementPackage.expand().getNode("<New requirement>").click();
    }

    private void canCreateAFormalSpecification(SWTBotTreeItem treeItemRequirement) {
        treeItemRequirement.contextMenu("Formal Specification").click();
    }

    private void canFillGeneralInformationRequirementEditor(SWTBotEditor editor) throws Exception {
        editor.bot().textWithLabel("ID ").setText("");
        editor.bot().textWithLabel("ID ").typeText("1");
        Assert.assertEquals((Object)editor.bot().textWithLabel("ID ").getText(), (Object)"1");
        editor.bot().styledTextWithLabel("Title ").typeText("Requirement1");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Title ").getText(), (Object)"Requirement1");
        editor.bot().styledTextWithLabel("Description ").typeText("SWTBot Requirement Test Description");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Description ").getText(), (Object)"SWTBot Requirement Test Description");
        editor.bot().styledTextWithLabel("Rationale ").typeText("SWTBot Requirement Test Rationale");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Rationale ").getText(), (Object)"SWTBot Requirement Test Rationale");
        editor.bot().styledTextWithLabel("Author ").typeText("SWTBot Requirement Test Author");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Author ").getText(), (Object)"SWTBot Requirement Test Author");
        editor.bot().styledTextWithLabel("Source ").typeText("SWTBot Requirement Test Source");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Source ").getText(), (Object)"SWTBot Requirement Test Source");
        editor.bot().styledTextWithLabel("Todo ").typeText("SWTBot Requirement Test ToDo");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Todo ").getText(), (Object)"SWTBot Requirement Test ToDo");
        editor.bot().comboBoxWithLabel("Status ").setSelection("Analyzed");
        Assert.assertEquals((Object)editor.bot().comboBoxWithLabel("Status ").getText(), (Object)"Analyzed");
        editor.bot().comboBoxWithLabel("Priority ").setSelection("High - Must-be");
        Assert.assertEquals((Object)editor.bot().comboBoxWithLabel("Priority ").getText(), (Object)"High - Must-be");
        bot.saveAllEditors();
    }

    private void testRightClickMenuInRequirement(SWTBotEditor editorRequirement) {
        editorRequirement.show();
        editorRequirement.bot().styledTextWithLabel("Description ").setFocus();
        editorRequirement.bot().styledTextWithLabel("Description ").selectRange(0, 0, 6);
        editorRequirement.bot().styledTextWithLabel("Description ").contextMenu("Create stakeholder").click();
        SWTBotEditor editorSWTBotStakeholder = bot.editorByTitle("SWTBot");
        editorSWTBotStakeholder.close();
        editorRequirement.show();
        editorRequirement.bot().styledTextWithLabel("Description ").setFocus();
        editorRequirement.bot().styledTextWithLabel("Description ").selectRange(0, 7, 11);
        editorRequirement.bot().styledTextWithLabel("Description ").contextMenu("Create document").click();
        SWTBotEditor editorrequirementdocument = bot.editorByTitle("Requirement");
        editorrequirementdocument.close();
        editorRequirement.show();
        editorRequirement.bot().styledTextWithLabel("Description ").setFocus();
        editorRequirement.bot().styledTextWithLabel("Description ").selectRange(0, 19, 4);
        editorRequirement.bot().styledTextWithLabel("Description ").contextMenu("Create glossary entry").click();
        SWTBotEditor editorTestGlossaryEntry = bot.editorByTitle("Test");
        editorTestGlossaryEntry.close();
        editorRequirement.show();
        editorRequirement.bot().styledTextWithLabel("Description ").setFocus();
        editorRequirement.bot().styledTextWithLabel("Description ").selectRange(0, 24, 11);
        editorRequirement.bot().styledTextWithLabel("Description ").contextMenu("Create external system").click();
        SWTBotEditor editorDescription = bot.editorByTitle("Description");
        editorDescription.close();
        editorRequirement.show();
    }

    private void canAssignTracesWithinRequirement(SWTBotEditor editor) throws Exception {
        editor.show();
        editor.bot().button("Add", 1).click();
        editor.bot().radio().click();
        editor.bot().button("Remove", 0).click();
        Assert.assertEquals((String)"Number of rows should be zero, since no step should exist", (long)0L, (long)editor.bot().table().rowCount());
        editor.bot().button("Add", 1).click();
        SWTBotTable RRtable = editor.bot().table();
        editor.bot().comboBox(3).setSelection("Refinement");
        Assert.assertEquals((Object)"Refinement", (Object)editor.bot().comboBox(3).getText());
        editor.bot().comboBox(3).setSelection("Contradicting");
        Assert.assertEquals((Object)"Contradicting", (Object)editor.bot().comboBox(3).getText());
        Assert.assertEquals((String)"Should have no sources, since indirected relation.", (Object)RRtable.cell(0, 5), (Object)"(Not a directed relation)");
        editor.bot().comboBox(3).setSelection("Override");
        Assert.assertEquals((Object)"Override", (Object)editor.bot().comboBox(3).getText());
        editor.bot().comboBox(3).setSelection("Conflicted");
        Assert.assertEquals((Object)"Conflicted", (Object)editor.bot().comboBox(3).getText());
        Assert.assertEquals((String)"Should have no sources, since indirected relation.", (Object)RRtable.cell(0, 5), (Object)"(Not a directed relation)");
        editor.bot().button("New", 0).click();
        SWTBotShell shell = bot.activeShell();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS});
        shell.bot().button(0).click();
        bot.textWithLabel("Please type a new name for the new relation status").setFocus();
        bot.text().setText("test");
        bot.button("OK").click();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).select("test");
        shell.bot().button(2).click();
        bot.textWithLabel("Please type a new name for the new relation status").setFocus();
        bot.text().setText("In progress");
        bot.button("OK").click();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).select("In progress");
        shell.bot().button(1).click();
        Assert.assertEquals((long)3L, (long)bot.tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).rowCount());
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).select("Analyzed");
        shell.bot().button("OK").click();
        Assert.assertTrue((String)"Status of the trace should be analyzed.", (boolean)editor.bot().button("Analyzed").isEnabled());
        editor.bot().comboBox(3).setSelection("Conflicted");
        editor.bot().buttonWithTooltip("Assign (source)/target requirements").click();
        shell = bot.activeShell();
        shell.bot().tree(1).getTreeItem(REQUIREMENT_NAME).doubleClick();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).expandNode(new String[]{REQUIREMENT_PACKAGE}).getNode(REQUIREMENT_NAME).doubleClick();
        Assert.assertEquals((long)shell.bot().tree(1).rowCount(), (long)1L);
        shell.bot().button("OK").click();
        editor.bot().comboBox(3).setSelection("Refinement");
        editor.bot().buttonWithTooltip("Assign (source)/target requirements").click();
        shell = bot.activeShell();
        shell.bot().button("OK").click();
    }

    private void canAssignTracesWithinUseCase(SWTBotEditor editor) {
        editor.show();
        editor.bot().button("Add", 1).click();
        editor.setFocus();
        editor.bot().comboBox(3).setSelection("Refinement");
        Assert.assertEquals((Object)"Refinement", (Object)editor.bot().comboBox(3).getText());
        editor.bot().button("New", 0).click();
        SWTBotShell shell = bot.activeShell();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS});
        shell.bot().button(0).click();
        bot.textWithLabel("Please type a new name for the new relation status").setFocus();
        bot.text().setText("test");
        bot.button("OK").click();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).select("test");
        shell.bot().button(2).click();
        bot.textWithLabel("Please type a new name for the new relation status").setFocus();
        bot.text().setText("In progress");
        bot.button("OK").click();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).select("In progress");
        shell.bot().button(1).click();
        Assert.assertEquals((long)3L, (long)bot.tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).rowCount());
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).select("Analyzed");
        shell.bot().button("OK").click();
        Assert.assertTrue((String)"Status of the trace should be analyzed.", (boolean)editor.bot().button("Analyzed").isEnabled());
        editor.bot().buttonWithTooltip("Assign (source)/target requirements").click();
        shell = bot.activeShell();
        shell.bot().button("OK").click();
        editor.bot().radio().click();
        editor.bot().button("Remove", 0).click();
        Assert.assertEquals((String)"Number of rows should be zero, since no step should exist", (long)0L, (long)editor.bot().table().rowCount());
    }

    private void canAssignTracesToArchitecture(SWTBotEditor editor) throws Exception {
        editor.show();
        SWTBotTable ERtable = editor.bot().table(2);
        editor.bot().button("Add", 2).click();
        editor.bot().radio(1).click();
        editor.bot().button("Remove", 1).click();
        Assert.assertEquals((String)"Number of rows should be zero, since no step should exist", (long)0L, (long)ERtable.rowCount());
        editor.bot().button("Add", 2).click();
        editor.setFocus();
        editor.bot().buttonWithTooltip("Assign trace status").click();
        SWTBotShell shell = bot.activeShell();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS});
        shell.bot().button(0).click();
        bot.textWithLabel("Please type a new name for the new relation status").setFocus();
        bot.text().setText("test");
        bot.button("OK").click();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).select("test");
        shell.bot().button(2).click();
        bot.textWithLabel("Please type a new name for the new relation status").setFocus();
        bot.text().setText("In progress");
        bot.button("OK").click();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).select("In progress");
        shell.bot().button(1).click();
        Assert.assertEquals((long)3L, (long)bot.tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).rowCount());
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).select("Analyzed");
        shell.bot().button("OK").click();
        Assert.assertTrue((String)"Status of the trace should be analyzed.", (boolean)editor.bot().button("Analyzed").isEnabled());
        editor.bot().buttonWithTooltip("Assign target").click();
        shell = bot.activeShell();
        shell.bot().tree().expandNode(new String[]{"Component Architecture"}).select("Component");
        shell.bot().button("OK").click();
    }

    private void canCreateRefinementSpecifications(SWTBotEditor editor) {
        editor.show();
        editor.bot().radio(1).click();
        editor.bot().buttonWithTooltip("Assign target").click();
        SWTBotShell shell = bot.activeShell();
        shell.bot().tree().expandNode(new String[]{"Component Architecture"}).select("Component");
        shell.bot().button("OK").click();
        editor.bot().button("Add refinement specification", 1).click();
        bot.activeShell().bot().button("OK").click();
        SWTBotEditor refSpecEditor = bot.activeEditor();
        refSpecEditor = bot.activeEditor();
        refSpecEditor.save();
        refSpecEditor.close();
    }

    private void canExecuteRequirementsActions(SWTBotEditor editor) throws Exception {
        editor.bot().toolbarButtonWithTooltip("Show Requirement Hierarchy").click();
        editor.bot().toolbarButtonWithTooltip("Review Requirements").click();
        bot.button("OK").click();
        editor.save();
    }

    private SWTBotEditor canChangeRequirementToUseCase(SWTBotEditor editor) throws Exception {
        editor.show();
        editor.bot().comboBoxWithLabel("Type ").setSelection("UseCase");
        bot.button("OK").click();
        editor = bot.activeEditor();
        Assert.assertEquals((Object)editor.bot().comboBoxWithLabel("Type ").getText(), (Object)"UseCase");
        return editor;
    }

    private SWTBotEditor canChangeUseCaseToRequirement(SWTBotEditor editor) throws Exception {
        editor.show();
        editor.bot().comboBoxWithLabel("Type ").setSelection("Requirement");
        bot.sleep(500L);
        bot.button("OK").click();
        editor = bot.activeEditor();
        Assert.assertEquals((Object)editor.bot().comboBoxWithLabel("Type ").getText(), (Object)"Requirement");
        return editor;
    }

    private void canCreateAnUseCase(SWTBotTreeItem treeItemRequirementPackage) throws Exception {
        treeItemRequirementPackage.contextMenu("Use Case").click();
        treeItemRequirementPackage.expand().getNode("<New use case>").click();
    }

    private void canFillGeneralInformationUseCaseEditor(SWTBotEditor editor) throws Exception {
        editor.show();
        editor.bot().textWithLabel("ID ").setText("");
        editor.bot().textWithLabel("ID ").typeText("UseCase1");
        editor.bot().styledTextWithLabel("Title ").typeText("SWTBot Use Case Test Title");
        editor.bot().styledTextWithLabel("Description ").typeText("SWTBot Use Case Test Description");
        editor.bot().styledTextWithLabel("Rationale ").typeText("SWTBot Use Case Test Rationale ");
        editor.bot().styledTextWithLabel("Author ").typeText("SWTBot Use Case Test Author");
        editor.bot().styledTextWithLabel("Source ").typeText("SWTBot Use Case Test Source");
        editor.bot().styledTextWithLabel("Todo ").typeText("SWTBot Use Case Test ToDo");
        editor.bot().comboBoxWithLabel("Status ").setSelection("Analyzed");
        editor.bot().comboBoxWithLabel("Priority ").setSelection("High - Must-be");
    }

    private void canFillDetailInformationUseCaseEditor(SWTBotEditor editor) throws Exception {
        editor.bot().styledTextWithLabel("Scope ").typeText("SWTBot Use Case Test Scope");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Scope ").getText(), (Object)"SWTBot Use Case Test Scope");
        editor.bot().buttonWithTooltip("Assign Actor").click();
        SWTBotShell shell = bot.activeShell();
        shell.bot().button(0).click();
        SWTBotShell tempShell = bot.activeShell();
        tempShell.bot().button("External System").click();
        bot.text().setText("SWTET");
        bot.button("OK").click();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).expandNode(new String[]{REQUIREMENT_SOURCE}).select("SWTET");
        shell.bot().button(2).click();
        bot.textWithLabel("Please type a name for the External System").setFocus();
        bot.text().setText("SWTETT");
        bot.button("OK").click();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).expandNode(new String[]{REQUIREMENT_SOURCE}).select("SWTETT");
        shell.bot().button("OK").click();
        editor.bot().styledTextWithLabel("Trigger(s) ").typeText("SWTBot Use Case Test Trigger");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Trigger(s) ").getText(), (Object)"SWTBot Use Case Test Trigger");
        editor.bot().styledTextWithLabel("Precondition ").typeText("SWTBot Use Case Test Rationale");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Precondition ").getText(), (Object)"SWTBot Use Case Test Rationale");
        editor.bot().styledTextWithLabel("Input(s) ").typeText("SWTBot Use Case Test Input");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Input(s) ").getText(), (Object)"SWTBot Use Case Test Input");
        editor.bot().styledTextWithLabel("Output(s) ").typeText("SWTBot Use Case Test Output");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Output(s) ").getText(), (Object)"SWTBot Use Case Test Output");
        editor.bot().styledTextWithLabel("Minimal guarantees ").typeText("SWTBot Use Case Test min guarantees");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Minimal guarantees ").getText(), (Object)"SWTBot Use Case Test min guarantees");
        editor.bot().styledTextWithLabel("Success guarantees ").typeText("SWTBot Use Case Test suc. guarantees");
        Assert.assertEquals((Object)editor.bot().styledTextWithLabel("Success guarantees ").getText(), (Object)"SWTBot Use Case Test suc. guarantees");
    }

    private void canCreateComponent(SWTBotTreeItem treeItemAF3Project) throws Exception {
        treeItemAF3Project.contextMenu("Component Architecture").click();
        treeItemAF3Project.getNode("Component Architecture").contextMenu("Component").click();
        bot.activeEditor().save();
    }

    private void canAssignScopeToUseCase(SWTBotEditor editor) throws Exception {
        editor.show();
        editor.bot().buttonWithTooltip("Assign Scope").click();
        SWTBotShell shell = bot.activeShell();
        shell.bot().tree().expandNode(new String[]{"Component Architecture"}).select("Component");
        shell.bot().button("OK").click();
    }

    private void canAssignActorToUseCase(SWTBotEditor editor) throws Exception {
        editor.show();
        editor.bot().buttonWithTooltip("Assign Actor").click();
        SWTBotShell shell = bot.activeShell();
        shell.bot().tree().expandNode(new String[]{REQUIREMENT_ANALYSIS}).select(REQUIREMENT_SOURCE);
        shell.bot().button(0).click();
        bot.button("Stakeholder").click();
        bot.text("<new Stakeholder>").setText("Actor_1");
        bot.button("OK").click();
        shell.bot().button(0).click();
        bot.button("Stakeholder").click();
        bot.text("<new Stakeholder>").setText("Actor_2");
        bot.button("OK").click();
        shell.bot().button(0).click();
        bot.button("External System").click();
        bot.text("<new External System>").setText("Actor_3");
        bot.button("OK").click();
        shell.bot().tree().expandNode(new String[]{REQUIREMENT_ANALYSIS}).expandNode(new String[]{REQUIREMENT_SOURCE}).select("Actor_2");
        shell.bot().button(1).click();
        bot.button("OK").click();
        shell.bot().tree().expandNode(new String[]{REQUIREMENT_ANALYSIS}).expandNode(new String[]{REQUIREMENT_SOURCE}).select("Actor_1");
        shell.bot().button("OK").click();
    }

    private void canFillCommentInformation(SWTBotEditor editor) throws Exception {
        editor.bot().styledText("", 0).setFocus();
        editor.bot().styledText("", 0).typeText("SWTBot Test Comment");
        Assert.assertEquals((Object)editor.bot().styledText("SWTBot Test Comment").getText(), (Object)"SWTBot Test Comment");
    }

    private void canFillCommentInformationUseCaseEditor(SWTBotEditor editor) throws Exception {
        editor.bot().styledText("", 1).setFocus();
        editor.bot().styledText("", 1).setText("SWTBot UseCase Test Comment");
        Assert.assertEquals((Object)editor.bot().styledText("SWTBot UseCase Test Comment").getText(), (Object)"SWTBot UseCase Test Comment");
    }

    private void canExecuteUseCaseActions(SWTBotEditor editor) throws Exception {
        editor.bot().toolbarButtonWithTooltip("Show Requirement Hierarchy").click();
    }

    private void canCreateAScenario(SWTBotTreeItem treeItemUseCase) throws Exception {
        treeItemUseCase.contextMenu("Scenario").click();
    }

    private void canFillOutScenarioBasicInformation(SWTBotEditor editorScenario) throws Exception {
        editorScenario.bot().textWithLabel("Name ").setText(SCENARIO_NAME);
        editorScenario.bot().checkBoxWithLabel("Success scenario ").click();
    }

    private void canCreateAndEditScenarioSteps(SWTBotEditor editorScenario) throws Exception {
        editorScenario.bot().button("Add").click();
        editorScenario.bot().table().click(0, 1);
        editorScenario.bot().buttonWithTooltip("Assign actor").click();
        SWTBotShell shell = bot.activeShell();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).expandNode(new String[]{REQUIREMENT_SOURCE}).select("SWTBot");
        shell.bot().button("OK").click();
        editorScenario.bot().styledText(0).setText("");
        editorScenario.bot().styledText(0).typeText("Testing things");
        editorScenario.bot().table().click(0, 3);
        editorScenario.bot().comboBox().setSelection("External");
        editorScenario.bot().table().click(0, 0);
        Assert.assertEquals((Object)editorScenario.bot().comboBox().getText(), (Object)"External");
        editorScenario.bot().table().click(0, 4);
        editorScenario.bot().comboBox().setSelection(0);
        editorScenario.bot().table().click(0, 0);
        Assert.assertEquals((Object)editorScenario.bot().comboBox().getText(), (Object)"");
    }

    private void canMoveAndRemoveScenarioSteps(SWTBotEditor editorScenario) throws Exception {
        editorScenario.bot().table().click(0, 1);
        editorScenario.bot().button("Move Up").click();
        editorScenario.bot().table().click(0, 3);
        Assert.assertEquals((String)"Scenario with action rype \"\" should be in the first row", (Object)"", (Object)editorScenario.bot().comboBox().getText());
        editorScenario.bot().button("Add").click();
        editorScenario.bot().table().click(1, 2);
        editorScenario.bot().buttonWithTooltip("Assign actor", 1).click();
        SWTBotShell shell = bot.activeShell();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).select(REQUIREMENT_SOURCE);
        shell.bot().button(0).click();
        bot.button("Stakeholder").click();
        bot.text("<new Stakeholder>").setText("Actor_Senario");
        bot.button("OK").click();
        shell.bot().tree().expandNode(new String[]{REQUIREMENT_ANALYSIS}).expandNode(new String[]{REQUIREMENT_SOURCE}).select("Actor_Senario");
        shell.bot().button("OK").click();
        editorScenario.bot().button("Move Up").click();
        editorScenario.bot().table().click(1, 3);
        editorScenario.bot().table().click(0, 0);
        editorScenario.bot().button("Move Down").click();
        editorScenario.bot().table().click(0, 3);
        editorScenario.bot().table().click(1, 0);
        editorScenario.bot().button("Remove").click();
        editorScenario.bot().table().click(0, 0);
        editorScenario.bot().button("Remove").click();
        Assert.assertEquals((String)"Number of rows should be zero, since no step should exist", (long)0L, (long)editorScenario.bot().table().rowCount());
    }

    private void canSave() throws Exception {
        bot.menu("File").menu("Save").click();
    }

    private boolean canExportReport(SWTBotTreeItem treeItemRequirementAnalysis) throws Exception {
        return treeItemRequirementAnalysis.contextMenu("Export Report").isEnabled();
    }
}

