/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.af3.mira.ui.editor.test;

import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class MiraRelationTest {
    private static final String AF3_PROJECT = "AF3-Project";
    private static final String REQUIREMENT_ANALYSIS = "Requirements Analysis";
    private static final String REQUIREMENT_PACKAGE = "Requirements";
    private static final String REQUIREMENT_NAME = "1 - Requirement1";
    private static final String USECASE_NAME = "2 - Requirement2";
    private static SWTWorkbenchBot bot;

    @BeforeClass
    public static void beforeClass() {
        SWTBotPreferences.PLAYBACK_DELAY = 50L;
        SWTBotPreferences.TYPE_INTERVAL = 0;
        bot = new SWTWorkbenchBot();
        bot.sleep(1000L);
    }

    @Test
    public void testMiraEditor() throws Exception {
        bot.viewByTitle("Welcome").close();
        this.canCreateANewAF320Project();
        SWTBotView viewModelNavigator = bot.viewByTitle("Model Navigator");
        SWTBotTreeItem treeItemAF3Project = viewModelNavigator.bot().tree().getTreeItem(AF3_PROJECT);
        this.canCreateARequirementAnalysis(treeItemAF3Project);
        SWTBotTreeItem treeItemRequirementAnalysis = treeItemAF3Project.expand().getNode(REQUIREMENT_ANALYSIS);
        Assert.assertTrue((boolean)this.canExportReport(treeItemRequirementAnalysis));
        this.canCreateARequirementsPackage(treeItemRequirementAnalysis);
        SWTBotTreeItem treeItemRequirementsPackage = treeItemRequirementAnalysis.expand().getNode(REQUIREMENT_PACKAGE);
        this.canCreateARequirement(treeItemRequirementsPackage);
        SWTBotEditor editorRequirement = bot.editorByTitle("<New requirement>");
        this.canFillInformationRequirement(editorRequirement);
        bot.sleep(3000L);
        SWTBotTreeItem treeItemRequirement = treeItemRequirementAnalysis.expand().expandNode(new String[]{REQUIREMENT_PACKAGE}).getNode(REQUIREMENT_NAME);
        this.canCreateAFormalSpecification(treeItemRequirement);
        editorRequirement.save();
        this.canCreateAnUseCase(treeItemRequirementsPackage);
        SWTBotEditor editorUseCase = bot.editorByTitle("<New use case>");
        this.canFillInformationUseCase(editorUseCase);
        bot.sleep(3000L);
        SWTBotTreeItem treeItemUseCase = treeItemRequirementAnalysis.expand().expandNode(new String[]{REQUIREMENT_PACKAGE}).getNode(USECASE_NAME);
        this.canCreateAFormalSpecification(treeItemUseCase);
        editorUseCase = bot.editorByTitle(USECASE_NAME);
        this.canCreateComponent(treeItemAF3Project);
        this.canAssignScopeToUseCase(editorUseCase);
        this.canExecuteUseCaseActions(editorUseCase);
        this.canSave();
        this.canAssignTracesWithinRequirement(editorRequirement);
        this.canAssignTracesToArchitecture(editorRequirement);
    }

    private void canCreateANewAF320Project() throws Exception {
        bot.perspectiveByLabel("Modeling").activate();
        bot.sleep(1000L);
        bot.menu("File").menu("New AF3 Project").click();
        bot.sleep(1000L);
    }

    private void canCreateARequirementAnalysis(SWTBotTreeItem treeItemAF3_PROJECT) throws Exception {
        treeItemAF3_PROJECT.contextMenu(REQUIREMENT_ANALYSIS).click();
    }

    private void canCreateARequirementsPackage(SWTBotTreeItem treeItemRequirementAnalysis) {
        treeItemRequirementAnalysis.contextMenu(REQUIREMENT_PACKAGE).click();
    }

    private void canFillInformationRequirement(SWTBotEditor editorRequirement) {
        editorRequirement.bot().textWithLabel("ID ").setText("");
        editorRequirement.bot().textWithLabel("ID ").typeText("1");
        Assert.assertEquals((Object)editorRequirement.bot().textWithLabel("ID ").getText(), (Object)"1");
        editorRequirement.bot().styledTextWithLabel("Title ").typeText("Requirement1");
        Assert.assertEquals((Object)editorRequirement.bot().styledTextWithLabel("Title ").getText(), (Object)"Requirement1");
        editorRequirement = bot.editorByTitle(REQUIREMENT_NAME);
        bot.saveAllEditors();
    }

    private void canFillInformationUseCase(SWTBotEditor editorUseCase) {
        editorUseCase.bot().textWithLabel("ID ").setText("");
        editorUseCase.bot().textWithLabel("ID ").typeText("2");
        Assert.assertEquals((Object)editorUseCase.bot().textWithLabel("ID ").getText(), (Object)"2");
        editorUseCase.bot().styledTextWithLabel("Title ").typeText("Requirement2");
        Assert.assertEquals((Object)editorUseCase.bot().styledTextWithLabel("Title ").getText(), (Object)"Requirement2");
        bot.saveAllEditors();
    }

    private void canCreateARequirement(SWTBotTreeItem treeItemRequirementPackage) throws Exception {
        treeItemRequirementPackage.contextMenu("Requirement").click();
        treeItemRequirementPackage.expand().getNode("<New requirement>").click();
    }

    private void canCreateAFormalSpecification(SWTBotTreeItem treeItemRequirement) {
        treeItemRequirement.contextMenu("Formal Specification").click();
    }

    private void canAssignTracesWithinRequirement(SWTBotEditor editor) throws Exception {
        editor.show();
        editor.bot().button("Add", 1).click();
        editor.bot().radio().click();
        editor.bot().button("Remove", 0).click();
        Assert.assertEquals((String)"Number of rows should be zero, since no step should exist", (long)0L, (long)editor.bot().table().rowCount());
        editor.bot().button("Add", 1).click();
        SWTBotTable RRtable = editor.bot().table();
        editor.bot().comboBox(3).setSelection("Refinement");
        Assert.assertEquals((Object)"Refinement", (Object)editor.bot().comboBox(3).getText());
        editor.bot().comboBox(3).setSelection("Contradicting");
        Assert.assertEquals((Object)"Contradicting", (Object)editor.bot().comboBox(3).getText());
        Assert.assertEquals((String)"Should have no sources, since indirected relation.", (Object)RRtable.cell(0, 5), (Object)"(Not a directed relation)");
        editor.bot().comboBox(3).setSelection("Override");
        Assert.assertEquals((Object)"Override", (Object)editor.bot().comboBox(3).getText());
        editor.bot().comboBox(3).setSelection("Conflicted");
        Assert.assertEquals((Object)"Conflicted", (Object)editor.bot().comboBox(3).getText());
        Assert.assertEquals((String)"Should have no sources, since indirected relation.", (Object)RRtable.cell(0, 5), (Object)"(Not a directed relation)");
        editor.bot().buttonWithTooltip("Assign relation status").click();
        SWTBotShell shell = bot.activeShell();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS});
        shell.bot().button(0).click();
        bot.textWithLabel("Please type a new name for the new relation status").setFocus();
        bot.text().setText("test");
        bot.button("OK").click();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).select("test");
        shell.bot().button(2).click();
        bot.textWithLabel("Please type a new name for the new relation status").setFocus();
        bot.text().setText("In progress");
        bot.button("OK").click();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).select("In progress");
        shell.bot().button(1).click();
        Assert.assertEquals((long)3L, (long)bot.tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).rowCount());
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).select("Analyzed");
        shell.bot().button("OK").click();
        Assert.assertTrue((String)"Status of the trace should be analyzed.", (boolean)editor.bot().button("Analyzed").isEnabled());
        editor.bot().comboBox(3).setSelection("Conflicted");
        editor.bot().buttonWithTooltip("Assign (source)/target requirements").click();
        shell = bot.activeShell();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).expandNode(new String[]{REQUIREMENT_PACKAGE}).getNode(USECASE_NAME).dragAndDrop((AbstractSWTBot)shell.bot().tree(1).getTreeItem(REQUIREMENT_NAME));
        Assert.assertEquals((long)shell.bot().tree(1).rowCount(), (long)2L);
        shell.bot().button("OK").click();
        editor.bot().comboBox(3).setSelection("Refinement");
        editor.bot().buttonWithTooltip("Assign (source)/target requirements").click();
        shell = bot.activeShell();
        shell.bot().tree(2).getTreeItem(USECASE_NAME).doubleClick();
        Assert.assertEquals((long)shell.bot().tree(2).rowCount(), (long)1L);
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).expandNode(new String[]{REQUIREMENT_PACKAGE}).getNode(USECASE_NAME).dragAndDrop((AbstractSWTBot)shell.bot().tree(2).getTreeItem(REQUIREMENT_NAME));
        Assert.assertEquals((long)shell.bot().tree(1).rowCount(), (long)0L);
        Assert.assertEquals((long)shell.bot().tree(2).rowCount(), (long)2L);
        shell.bot().tree(2).getTreeItem(USECASE_NAME).doubleClick();
        Assert.assertEquals((long)shell.bot().tree(2).rowCount(), (long)1L);
        shell.bot().button("OK").click();
    }

    private void canAssignTracesToArchitecture(SWTBotEditor editor) throws Exception {
        editor.show();
        editor.bot().button("Add", 2).click();
        editor.bot().radio(1).click();
        editor.bot().buttonWithTooltip("Assign trace status").click();
        SWTBotShell shell = bot.activeShell();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS});
        shell.bot().button(0).click();
        bot.textWithLabel("Please type a new name for the new relation status").setFocus();
        bot.text().setText("test");
        bot.button("OK").click();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).select("test");
        shell.bot().button(2).click();
        bot.textWithLabel("Please type a new name for the new relation status").setFocus();
        bot.text().setText("In progress");
        bot.button("OK").click();
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).select("In progress");
        shell.bot().button(1).click();
        Assert.assertEquals((long)3L, (long)bot.tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).rowCount());
        shell.bot().tree(0).expandNode(new String[]{REQUIREMENT_ANALYSIS}).select("Analyzed");
        shell.bot().button("OK").click();
        Assert.assertTrue((String)"Status of the trace should be analyzed.", (boolean)editor.bot().button("Analyzed").isEnabled());
        editor.bot().buttonWithTooltip("Assign target").click();
        shell = bot.activeShell();
        shell.bot().tree(0).expandNode(new String[]{"Component Architecture"}).select("Component");
        bot.button("OK").click();
        editor.bot().radio(1).click();
        editor.bot().button("Add refinement specification", 1).click();
        shell = bot.activeShell();
        shell.bot().tree().select(new String[]{"Formal Specification"});
        bot.button("OK").click();
        SWTBotEditor refSpecEditor = bot.activeEditor();
        refSpecEditor = bot.activeEditor();
        Assert.assertEquals((Object)refSpecEditor.bot().textWithLabel("Refined Component: ").getText(), (Object)"Component");
        refSpecEditor.save();
        refSpecEditor.close();
        editor.show();
    }

    private void canCreateAnUseCase(SWTBotTreeItem treeItemRequirementPackage) throws Exception {
        treeItemRequirementPackage.contextMenu("Use Case").click();
        treeItemRequirementPackage.expand().getNode("<New use case>").click();
    }

    private void canCreateComponent(SWTBotTreeItem treeItemAF3Project) throws Exception {
        treeItemAF3Project.contextMenu("Component Architecture").click();
        treeItemAF3Project.getNode("Component Architecture").contextMenu("Component").click();
        bot.activeEditor().save();
    }

    private void canAssignScopeToUseCase(SWTBotEditor editor) throws Exception {
        editor.show();
        editor.bot().buttonWithTooltip("Assign Scope").click();
        SWTBotShell shell = bot.activeShell();
        shell.bot().tree().expandNode(new String[]{"Component Architecture"}).select("Component");
        shell.bot().button("OK").click();
    }

    private void canExecuteUseCaseActions(SWTBotEditor editor) throws Exception {
        editor.bot().toolbarButtonWithTooltip("Show Requirement Hierarchy").click();
    }

    private void canSave() throws Exception {
        bot.menu("File").menu("Save").click();
    }

    private boolean canExportReport(SWTBotTreeItem treeItemRequirementAnalysis) throws Exception {
        return treeItemRequirementAnalysis.contextMenu("Export Report").isEnabled();
    }
}

