/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.spiderchart.control;

import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import org.fortiss.tooling.spiderchart.control.SpiderChartControl;
import org.fortiss.tooling.spiderchart.control.SpiderChartLegendControl;
import org.fortiss.tooling.spiderchart.control.SpiderChartTitleControl;
import org.fortiss.tooling.spiderchart.model.SpiderChart;
import org.fortiss.tooling.spiderchart.style.ChartStyle;

final class SpiderChartCanvas {
    private final Canvas canvas;
    private final ChartStyle style;
    private final SpiderChartControl chartControl;
    private final SpiderChartTitleControl titleControl;
    private final SpiderChartLegendControl legendControl;

    public SpiderChartCanvas(SpiderChart chart, ChartStyle style) {
        this.style = style;
        this.chartControl = new SpiderChartControl(chart, style);
        this.titleControl = new SpiderChartTitleControl(chart, style);
        this.legendControl = new SpiderChartLegendControl(chart, style);
        this.canvas = new Canvas();
        this.canvas.widthProperty().addListener(evt -> this.layoutAndPaint());
        this.canvas.heightProperty().addListener(evt -> this.layoutAndPaint());
    }

    public Canvas getCanvasControl() {
        return this.canvas;
    }

    private void layoutAndPaint() {
        double width = this.canvas.getWidth();
        double height = this.canvas.getHeight();
        this.layoutChart(width, height);
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, width, height);
        this.drawChart(gc);
    }

    private void layoutChart(double width, double height) {
        double chartMarginPercent = this.style.getRelativeMargin();
        double widthMargin = width * chartMarginPercent;
        double heightMargin = height * chartMarginPercent;
        double chartY = 0.0;
        double widthRemaining = width;
        double heightRemaining = height;
        if (this.style.isShowTitle()) {
            this.titleControl.setBounds(0.0, 0.0, width - 1.0, heightMargin - 1.0);
            heightRemaining -= heightMargin;
            chartY = heightMargin;
        }
        if (this.style.isShowLegend()) {
            if (this.style.getLegendStyle().isVerticalLayout()) {
                this.legendControl.setBounds(width - widthMargin, height - heightRemaining, widthMargin - 1.0, heightRemaining - 1.0);
                widthRemaining -= widthMargin;
            } else {
                this.legendControl.setBounds(0.0, height - heightMargin, width - 1.0, heightMargin - 1.0);
                heightRemaining -= heightMargin;
            }
        }
        this.chartControl.setBounds(0.0, chartY, widthRemaining, heightRemaining);
    }

    private void drawChart(GraphicsContext gc) {
        if (this.style.isShowTitle()) {
            this.titleControl.draw(gc);
        }
        this.chartControl.draw(gc);
        if (this.style.isShowLegend()) {
            this.legendControl.draw(gc);
        }
    }
}

