/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.spiderchart.control;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.scene.canvas.GraphicsContext;
import org.fortiss.tooling.common.ui.javafx.style.FontStyle;
import org.fortiss.tooling.spiderchart.control.SpiderChartControlBase;
import org.fortiss.tooling.spiderchart.model.AxisBase;
import org.fortiss.tooling.spiderchart.model.DataSeries;
import org.fortiss.tooling.spiderchart.model.DoubleAxis;
import org.fortiss.tooling.spiderchart.model.EnumerationAxis;
import org.fortiss.tooling.spiderchart.model.SpiderChart;
import org.fortiss.tooling.spiderchart.style.AxisStyle;
import org.fortiss.tooling.spiderchart.style.ChartStyle;
import org.fortiss.tooling.spiderchart.style.DataSeriesStyle;
import org.fortiss.tooling.spiderchart.util.AxisUtils;

public final class SpiderChartControl
extends SpiderChartControlBase {
    private Point2D center = new Point2D(0.0, 0.0);
    private Map<AxisBase, Point2D> axesEnds = new HashMap<AxisBase, Point2D>();
    private double segmentDegree = 0.0;

    public SpiderChartControl(SpiderChart chart, ChartStyle style) {
        super(chart, style);
    }

    public void draw(GraphicsContext gc) {
        if (!this.style.isUseIndividualAxisSegments()) {
            this.drawBackground(gc);
            this.drawWebLines(gc);
        }
        this.drawAxes(gc);
        for (DataSeries data : this.chart.getDataSeries()) {
            this.drawDataSeries(gc, data);
        }
    }

    @Override
    public void setBounds(double x, double y, double w, double h) {
        super.setBounds(x, y, w, h);
        this.computeAxisEndPoints();
    }

    private void computeAxisEndPoints() {
        List<AxisBase> axes = this.chart.getAxes();
        int size = axes.size();
        this.segmentDegree = 360.0 / (double)size;
        double currentAngleDegree = this.style.getStartAngleDegree();
        double halfWidth = this.getWidth() / 2.0;
        double halfHeight = this.getHeight() / 2.0;
        this.center = new Point2D(this.getX() + halfWidth, this.getY() + halfHeight);
        double relativeMargin = 1.0 - this.style.getRelativeMargin();
        int wExtent = (int)(relativeMargin * halfWidth);
        int hExtent = (int)(relativeMargin * halfHeight);
        int extent = Math.min(wExtent, hExtent);
        int i = 0;
        while (i < size) {
            AxisBase axis = axes.get(i);
            double startAngleRad = Math.PI * currentAngleDegree / 180.0;
            int extentX = (int)(Math.cos(startAngleRad) * (double)extent);
            int extentY = (int)(Math.sin(startAngleRad) * (double)extent);
            Point2D outer = new Point2D(this.center.getX() + (double)extentX, this.center.getY() + (double)extentY);
            this.axesEnds.put(axis, outer);
            currentAngleDegree = (currentAngleDegree + this.segmentDegree) % 360.0;
            ++i;
        }
    }

    private void drawBackground(GraphicsContext gc) {
        gc.save();
        if (this.chart.getAxes().isEmpty()) {
            return;
        }
        gc.beginPath();
        boolean first = true;
        for (AxisBase axis : this.chart.getAxes()) {
            Point2D p = this.axesEnds.get(axis);
            if (first) {
                gc.moveTo(p.getX(), p.getY());
                first = false;
                continue;
            }
            gc.lineTo(p.getX(), p.getY());
        }
        gc.closePath();
        this.style.getBackgroundFillStyle().applyStyle(gc);
        gc.fill();
        gc.restore();
    }

    private void drawWebLines(GraphicsContext gc) {
        this.style.getBackgroundLineStyle().applyStyle(gc);
        int i = 1;
        while (i <= this.style.getAxisSegments()) {
            this.computeAndDrawPath(i, gc);
            ++i;
        }
    }

    private void computeAndDrawPath(int i, GraphicsContext gc) {
        double ratio = (double)i / (double)this.style.getAxisSegments();
        boolean first = true;
        gc.save();
        gc.beginPath();
        for (AxisBase axis : this.chart.getAxes()) {
            Point2D outer = this.axesEnds.get(axis);
            double xExtent = outer.getX() - this.center.getX();
            double yExtent = outer.getY() - this.center.getY();
            double x = this.center.getX() + ratio * xExtent;
            double y = this.center.getY() + ratio * yExtent;
            if (first) {
                gc.moveTo(x, y);
                first = false;
                continue;
            }
            gc.lineTo(x, y);
        }
        gc.closePath();
        gc.restore();
    }

    private void drawDataSeries(GraphicsContext gc, DataSeries data) {
        DataSeriesStyle dStyle = this.style.getDataSeriesStyle(data);
        boolean first = true;
        gc.save();
        gc.beginPath();
        for (AxisBase axis : this.chart.getAxes()) {
            Point2D p = this.computeDataPoint(axis, data);
            if (first) {
                gc.moveTo(p.getX(), p.getY());
                first = false;
            } else {
                gc.lineTo(p.getX(), p.getY());
            }
            if (dStyle.isShowIndicators()) {
                this.drawIndicator(gc, dStyle, p);
            }
            if (!dStyle.isShowIndicatorLabels()) continue;
            this.drawIndicatorLabel(gc, dStyle, p, axis, data.getAxisValue(axis));
        }
        gc.closePath();
        dStyle.getFillStyle().applyStyle(gc);
        gc.fill();
        dStyle.getLineStyle().applyStyle(gc);
        gc.stroke();
        gc.restore();
    }

    private void drawIndicatorLabel(GraphicsContext gc, DataSeriesStyle dStyle, Point2D p, AxisBase axis, Object value) {
        FontStyle fontStyle = dStyle.getIndicatorLabelStyle();
        String label = dStyle.getFormattedLabel(axis, value);
        Dimension2D textExtent = fontStyle.getTextBounds(label);
        int offset = 5;
        double x = p.getX() + (double)offset;
        double y = p.getY();
        y = y > this.center.getY() ? y + (double)offset + textExtent.getHeight() / 2.0 : (y < this.center.getY() ? (y -= (double)offset) : (y -= textExtent.getHeight() / 2.0));
        fontStyle.drawText(gc, label, x, y);
    }

    private void drawIndicator(GraphicsContext gc, DataSeriesStyle dStyle, Point2D p) {
        double size = dStyle.getIndicatorSize();
        dStyle.getLineStyle().applyStyle(gc);
        gc.fillRect(p.getX() - size / 2.0, p.getY() - size / 2.0, size, size);
    }

    private Point2D computeDataPoint(AxisBase axis, DataSeries data) {
        Double ratio = 0.0;
        if (axis instanceof DoubleAxis) {
            DoubleAxis da = (DoubleAxis)axis;
            ratio = da.getAxisRatio((Double)data.getAxisValue(axis));
        }
        if (axis instanceof EnumerationAxis) {
            EnumerationAxis ea = (EnumerationAxis)axis;
            int segments = this.style.isUseIndividualAxisSegments() ? this.style.getAxisStyle(axis).getSegments() : this.style.getAxisSegments();
            int index = Math.max(0, ea.indexOfEnumerationMember(data.getAxisValue(ea)));
            ratio = (double)index / (double)segments;
        }
        Point2D outer = this.axesEnds.get(axis);
        int deltaX = (int)(ratio * (outer.getX() - this.center.getX()));
        int deltaY = (int)(ratio * (outer.getY() - this.center.getY()));
        return new Point2D(this.center.getX() + (double)deltaX, this.center.getY() + (double)deltaY);
    }

    private Map<AxisBase, Point2D> drawAxes(GraphicsContext gc) {
        List<AxisBase> axes = this.chart.getAxes();
        int size = axes.size();
        double segmentDegree = 360.0 / (double)size;
        double angleDegree = 90.0;
        double halfWidth = this.getWidth() / 2.0;
        double halfHeight = this.getHeight() / 2.0;
        double centerX = this.getX() + halfWidth;
        double centerY = this.getY() + halfHeight;
        int i = 0;
        while (i < size) {
            AxisBase axis = axes.get(i);
            Point2D outer = this.axesEnds.get(axis);
            AxisStyle aStyle = this.style.getAxisStyle(axis);
            aStyle.getLineStyle().drawLine(gc, centerX, centerY, outer.getX(), outer.getY());
            this.drawAxisLabel(gc, axis, aStyle, centerX, centerY, outer.getX(), outer.getY());
            if (aStyle.isUseSegmentIndicators()) {
                this.drawSegmentIndicators(gc, centerX, centerY, axis, outer, aStyle);
            }
            angleDegree = (angleDegree + segmentDegree) % 360.0;
            ++i;
        }
        return this.axesEnds;
    }

    private void drawSegmentIndicators(GraphicsContext gc, double centerX, double centerY, AxisBase axis, Point2D outer, AxisStyle aStyle) {
        int segments = this.style.isUseIndividualAxisSegments() ? aStyle.getSegments() : this.style.getAxisSegments();
        int s = 1;
        while (s <= segments) {
            Object value;
            String lbl = "";
            if (axis instanceof DoubleAxis) {
                double ratio = (double)s / (double)segments;
                Double value2 = ((DoubleAxis)axis).getAxisValue(ratio);
                lbl = aStyle.getDecimalFormat().format(value2);
            } else if (axis instanceof EnumerationAxis && (value = ((EnumerationAxis)axis).getEnumerationMemberAtIndex(s)) != null) {
                lbl = value.toString();
            }
            Point2D segmentPoint = AxisUtils.getSegmentPoint(segments, s, outer.getX() - this.center.getX(), outer.getY() - this.center.getY());
            this.drawSegmentIndicator(gc, lbl, aStyle, centerX, centerY, segmentPoint);
            ++s;
        }
    }

    private void drawSegmentIndicator(GraphicsContext gc, String lbl, AxisStyle axisStyle, double centerX, double centerY, Point2D segment) {
        FontStyle segmentStyle = axisStyle.getSegmentStyle();
        double textWidth = segmentStyle.getTextBounds(lbl).getWidth();
        double posX = centerX + segment.getX() - textWidth - 4.0;
        double posY = centerY + segment.getY() + 4.0;
        segmentStyle.drawText(gc, lbl, posX, posY);
    }

    private void drawAxisLabel(GraphicsContext gc, AxisBase axis, AxisStyle style, double centerX, double centerY, double outerX, double outerY) {
        String axisLabel = axis.getName();
        FontStyle labelStyle = style.getLabelStyle();
        Dimension2D tb = labelStyle.getTextBounds(axisLabel);
        int offset = 20;
        outerX = outerX > centerX ? (outerX += (double)offset) : (outerX < centerX ? outerX - (double)offset - tb.getWidth() : (outerX -= tb.getWidth() / 2.0));
        if (outerY > centerY) {
            outerY = outerY + (double)offset + tb.getHeight() / 2.0;
        } else if (outerY < centerY) {
            outerY -= (double)offset;
        }
        labelStyle.drawText(gc, axisLabel, outerX, outerY);
    }
}

