/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.spiderchart.control;

import javafx.geometry.Dimension2D;
import javafx.scene.canvas.GraphicsContext;
import org.fortiss.tooling.common.ui.javafx.style.FontStyle;
import org.fortiss.tooling.common.ui.javafx.style.LineStyle;
import org.fortiss.tooling.spiderchart.control.SpiderChartControlBase;
import org.fortiss.tooling.spiderchart.model.DataSeries;
import org.fortiss.tooling.spiderchart.model.SpiderChart;
import org.fortiss.tooling.spiderchart.style.ChartStyle;
import org.fortiss.tooling.spiderchart.style.LegendStyle;

public final class SpiderChartLegendControl
extends SpiderChartControlBase {
    private static final double LINE_SIZE = 20.0;
    private static final double LINE_SPACE = 5.0;

    public SpiderChartLegendControl(SpiderChart chart, ChartStyle style) {
        super(chart, style);
    }

    public void draw(GraphicsContext gc) {
        if (!this.style.isShowLegend()) {
            return;
        }
        if (this.style.getLegendStyle().isVerticalLayout()) {
            this.drawVertical(gc);
        } else {
            this.drawHorizontal(gc);
        }
    }

    public void drawHorizontal(GraphicsContext gc) {
        String labelText = this.chart.getLegendLabel();
        double margin = this.style.getLegendStyle().getMargin();
        double xDelta = 0.0;
        if (labelText != null && labelText.trim().length() > 0) {
            xDelta = this.drawHorizontalLabel(gc);
        }
        double y = this.getY() + margin;
        for (DataSeries data : this.chart.getDataSeries()) {
            String text = data.getName();
            FontStyle fontStyle = this.style.getDataSeriesStyle(data).getIndicatorLabelStyle();
            Dimension2D extent = fontStyle.getTextBounds(text);
            LineStyle l = this.style.getDataSeriesStyle(data).getLineStyle();
            double xl = this.getX() + xDelta;
            l.drawLine(gc, xl, y - extent.getHeight() / 4.0, xl + 20.0, y - extent.getHeight() / 4.0);
            xDelta = xDelta + 20.0 + 5.0;
            double xs = this.getX() + xDelta;
            fontStyle.drawText(gc, text, xs, y);
            xDelta = xDelta + extent.getWidth() + margin;
        }
    }

    private double drawHorizontalLabel(GraphicsContext gc) {
        String labelText = this.chart.getLegendLabel();
        LegendStyle legendStyle = this.style.getLegendStyle();
        FontStyle labelStyle = legendStyle.getLabelStyle();
        double margin = legendStyle.getMargin();
        double textExtent = labelStyle.getTextBounds(labelText).getWidth();
        labelStyle.drawText(gc, labelText, this.getX() + margin, this.getY() + margin);
        return textExtent + 2.0 * margin;
    }

    public void drawVertical(GraphicsContext gc) {
        String labelText = this.chart.getLegendLabel();
        LegendStyle legendStyle = this.style.getLegendStyle();
        double margin = legendStyle.getMargin();
        double yDelta = 0.0;
        if (labelText != null && labelText.trim().length() > 0) {
            yDelta = this.drawVerticalLabel(gc);
        }
        double textWidth = 0.0;
        double textHeight = 0.0;
        for (DataSeries data : this.chart.getDataSeries()) {
            Dimension2D extent = legendStyle.getLabelStyle().getTextBounds(data.getName());
            textWidth = Math.max(textWidth, extent.getWidth());
            textHeight = Math.max(textHeight, extent.getHeight());
        }
        int cnt = 0;
        for (DataSeries data : this.chart.getDataSeries()) {
            double dY = yDelta + (double)cnt * (textHeight + margin);
            double dX = 20.0 + 2.0 * margin;
            LineStyle l = this.style.getDataSeriesStyle(data).getLineStyle();
            double lY = dY + textHeight / 2.0;
            l.drawLine(gc, this.getX() + margin, this.getY() + lY, this.getX() + margin + 20.0, this.getY() + lY);
            this.style.getDataSeriesStyle(data).getIndicatorLabelStyle().drawText(gc, data.getName(), this.getX() + dX, this.getY() + dY);
            ++cnt;
        }
    }

    private double drawVerticalLabel(GraphicsContext gc) {
        String labelText = this.chart.getLegendLabel();
        LegendStyle legendStyle = this.style.getLegendStyle();
        FontStyle labelStyle = legendStyle.getLabelStyle();
        double margin = legendStyle.getMargin();
        Dimension2D textExtent = labelStyle.getTextBounds(labelText);
        double x = this.getX() + margin + (this.getWidth() - margin - textExtent.getWidth()) / 2.0;
        labelStyle.drawText(gc, labelText, x, this.getY() + margin);
        return textExtent.getHeight() + margin;
    }
}

