/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.spiderchart.control;

import javafx.geometry.Dimension2D;
import javafx.scene.canvas.GraphicsContext;
import org.fortiss.tooling.common.ui.javafx.style.FontStyle;
import org.fortiss.tooling.spiderchart.control.SpiderChartControlBase;
import org.fortiss.tooling.spiderchart.model.SpiderChart;
import org.fortiss.tooling.spiderchart.style.ChartStyle;

public final class SpiderChartTitleControl
extends SpiderChartControlBase {
    public SpiderChartTitleControl(SpiderChart chart, ChartStyle style) {
        super(chart, style);
    }

    public void draw(GraphicsContext gc) {
        if (!this.style.isShowTitle()) {
            return;
        }
        String text = this.chart.getTitle();
        if (text == null || text.trim().length() == 0) {
            return;
        }
        gc.save();
        FontStyle fontStyle = this.style.getTitleStyle();
        Dimension2D extent = fontStyle.getTextBounds(text);
        double x = this.getX() + this.getWidth() / 2.0 - extent.getWidth() / 2.0;
        double y = this.getY() + this.getHeight() / 2.0 - extent.getHeight() / 2.0;
        fontStyle.drawText(gc, text, x, y);
        gc.restore();
    }
}

