/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.spiderchart.control;

import javafx.geometry.Bounds;
import javafx.scene.canvas.Canvas;
import javafx.scene.layout.Pane;
import org.fortiss.tooling.spiderchart.control.SpiderChartCanvas;
import org.fortiss.tooling.spiderchart.model.SpiderChart;
import org.fortiss.tooling.spiderchart.style.ChartStyle;

public final class SpiderChartViewer {
    private final Pane viewerPane;
    private final SpiderChartCanvas canvas;

    public SpiderChartViewer(SpiderChart chart, ChartStyle style) {
        this.canvas = new SpiderChartCanvas(chart, style);
        this.viewerPane = new Pane();
        this.viewerPane.getChildren().add((Object)this.canvas.getCanvasControl());
        this.viewerPane.widthProperty().addListener(evt -> this.updateCanvasSize());
        this.viewerPane.heightProperty().addListener(evt -> this.updateCanvasSize());
    }

    protected void updateCanvasSize() {
        Bounds b = this.viewerPane.getLayoutBounds();
        Canvas c = this.canvas.getCanvasControl();
        c.setWidth(b.getWidth());
        c.setHeight(b.getHeight());
    }

    public Pane getViewerPane() {
        return this.viewerPane;
    }
}

