/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.spiderchart.model;

import java.util.Comparator;
import org.fortiss.tooling.spiderchart.model.AxisBase;

public final class DoubleAxis
extends AxisBase {
    private Double minimumValue = 0.0;
    private Double maximumValue = 1.0;
    public static final Comparator<Double> DOUBLE_COMPARATOR = new Comparator<Double>(){

        @Override
        public int compare(Double o1, Double o2) {
            double delta = o1 - o2;
            if (delta < 0.0) {
                return -1;
            }
            if (delta > 0.0) {
                return 1;
            }
            return 0;
        }
    };

    public DoubleAxis(Double min, Double max) {
        this("", min, max);
    }

    public DoubleAxis(String name, Double min, Double max) {
        super(name);
        this.minimumValue = min;
        this.maximumValue = max;
    }

    public Double getMinimumValue() {
        return this.minimumValue;
    }

    public Double getMaximumValue() {
        return this.maximumValue;
    }

    public Double getAxisValue(Double ratio) {
        Double length = this.maximumValue - this.minimumValue;
        return this.minimumValue + ratio * length;
    }

    public Double getAxisRatio(Double value) {
        return (value - this.minimumValue) / (this.maximumValue - this.minimumValue);
    }

    @Override
    public boolean isValidValue(Object o) {
        Double d = (Double)o;
        return this.minimumValue <= d && d <= this.maximumValue;
    }
}

