/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.spiderchart.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.fortiss.tooling.spiderchart.model.AxisBase;

public final class EnumerationAxis<T>
extends AxisBase {
    private final List<T> values;

    public EnumerationAxis(String name, Comparator<T> comparator, List<T> values) {
        super(name);
        this.values = values;
        Collections.sort(this.values, comparator);
    }

    public T getEnumerationMemberAtIndex(int index) {
        if (index >= 0 && index < this.values.size()) {
            return this.values.get(index);
        }
        return null;
    }

    public int indexOfEnumerationMember(T member) {
        return this.values.indexOf(member);
    }

    @Override
    public boolean isValidValue(Object d) {
        return this.values.contains(d);
    }
}

