/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.spiderchart.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fortiss.tooling.spiderchart.model.AxisBase;
import org.fortiss.tooling.spiderchart.model.DataSeries;

public final class SpiderChart {
    private List<AxisBase> axes = new ArrayList<AxisBase>();
    private List<DataSeries> dataSeries = new ArrayList<DataSeries>();
    private String title;
    private String legendLabel;

    public void addData(DataSeries d) {
        this.dataSeries.add(d);
    }

    public void addAxis(AxisBase a) {
        this.axes.add(a);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setLegendLabel(String legendLabel) {
        this.legendLabel = legendLabel;
    }

    public boolean checkDataValidity() {
        for (DataSeries d : this.dataSeries) {
            for (AxisBase a : this.axes) {
                if (d.getAxisValue(a) == null) {
                    return false;
                }
                if (a.isValidValue(d.getAxisValue(a))) continue;
                return false;
            }
        }
        return true;
    }

    public List<AxisBase> getAxes() {
        return Collections.unmodifiableList(this.axes);
    }

    public List<DataSeries> getDataSeries() {
        return Collections.unmodifiableList(this.dataSeries);
    }

    public String getLegendLabel() {
        return this.legendLabel;
    }

    public String getTitle() {
        return this.title;
    }

    public void moveSeriesToEnd(DataSeries ds) {
        this.dataSeries.remove(ds);
        this.dataSeries.add(ds);
    }
}

