/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.spiderchart.style;

import java.text.DecimalFormat;
import java.util.Objects;
import org.fortiss.tooling.common.ui.javafx.style.FontStyle;
import org.fortiss.tooling.common.ui.javafx.style.LineStyle;

public final class AxisStyle {
    public static final AxisStyle DEFAULT = new AxisStyle(LineStyle.SOLID_BLACK_1PT, FontStyle.BLACK_VERDANA_12PT, 1, FontStyle.BLACK_VERDANA_8PT);
    private LineStyle lineStyle;
    private FontStyle labelStyle;
    private int segments;
    private FontStyle segmentStyle;
    private DecimalFormat decimalFormat;
    private boolean useSegmentIndicators = true;

    public AxisStyle(LineStyle lineStyle, FontStyle labelStyle) {
        this(lineStyle, labelStyle, 0, null, new DecimalFormat("#.##"), true);
    }

    public AxisStyle(LineStyle lineStyle, FontStyle labelStyle, int numSegments, FontStyle segmentStyle) {
        this(lineStyle, labelStyle, numSegments, segmentStyle, new DecimalFormat("#.##"), true);
    }

    public AxisStyle(LineStyle lineStyle, FontStyle labelStyle, int numSegments, FontStyle segmentStyle, DecimalFormat decimalFormat) {
        this(lineStyle, labelStyle, numSegments, segmentStyle, decimalFormat, true);
    }

    public AxisStyle(LineStyle lineStyle, FontStyle labelStyle, int numSegments, FontStyle segmentStyle, DecimalFormat decimalFormat, boolean useSegmentIndicators) {
        this.lineStyle = Objects.requireNonNull(lineStyle);
        this.labelStyle = Objects.requireNonNull(labelStyle);
        this.segments = Math.max(1, numSegments);
        this.segmentStyle = segmentStyle;
        this.decimalFormat = decimalFormat;
        this.useSegmentIndicators = useSegmentIndicators;
    }

    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    public FontStyle getLabelStyle() {
        return this.labelStyle;
    }

    public int getSegments() {
        return this.segments;
    }

    public FontStyle getSegmentStyle() {
        return this.segmentStyle;
    }

    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    public boolean isUseSegmentIndicators() {
        return this.useSegmentIndicators;
    }
}

