/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.spiderchart.style;

import java.util.HashMap;
import java.util.Map;
import javafx.scene.paint.Color;
import org.fortiss.tooling.common.ui.javafx.style.FillStyle;
import org.fortiss.tooling.common.ui.javafx.style.FontStyle;
import org.fortiss.tooling.common.ui.javafx.style.LineStyle;
import org.fortiss.tooling.spiderchart.model.AxisBase;
import org.fortiss.tooling.spiderchart.model.DataSeries;
import org.fortiss.tooling.spiderchart.style.AxisStyle;
import org.fortiss.tooling.spiderchart.style.DataSeriesStyle;
import org.fortiss.tooling.spiderchart.style.LegendStyle;

public final class ChartStyle {
    private Map<AxisBase, AxisStyle> axisStyle = new HashMap<AxisBase, AxisStyle>();
    private Map<DataSeries, DataSeriesStyle> dataSeriesStyle = new HashMap<DataSeries, DataSeriesStyle>();
    private boolean showTitle = true;
    private FontStyle titleStyle;
    private boolean showLegend = true;
    private LegendStyle legendStyle;
    private double relativeMargin = 0.1;
    private double startAngleDegree = 90.0;
    private boolean useIndividualAxisSegments = false;
    private int axisSegments = 1;
    private FillStyle backgroundFillStyle = new FillStyle(Color.GREEN.brighter());
    private LineStyle backgroundLineStyle = new LineStyle(Color.GREEN);

    public ChartStyle(boolean showTitle, boolean showLegend, boolean useIndividualAxisSegments) {
        this.showTitle = showTitle;
        this.showLegend = showLegend;
        this.useIndividualAxisSegments = useIndividualAxisSegments;
    }

    public double getStartAngleDegree() {
        return this.startAngleDegree;
    }

    public void setStartAngleDegree(double startAngleDegree) {
        this.startAngleDegree = startAngleDegree;
    }

    public void setRelativeMargin(double relativeMargin) {
        this.relativeMargin = relativeMargin;
    }

    public double getRelativeMargin() {
        return this.relativeMargin;
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(boolean showTitle) {
        this.showTitle = showTitle;
    }

    public FontStyle getTitleStyle() {
        return this.titleStyle;
    }

    public void setTitleStyle(FontStyle titleStyle) {
        this.titleStyle = titleStyle;
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    public LegendStyle getLegendStyle() {
        return this.legendStyle;
    }

    public void setLegendStyle(LegendStyle legendStyle) {
        this.legendStyle = legendStyle;
    }

    public AxisStyle getAxisStyle(AxisBase axis) {
        return this.axisStyle.get(axis);
    }

    public void setAxisStyle(AxisBase axis, AxisStyle style) {
        this.axisStyle.put(axis, style);
    }

    public DataSeriesStyle getDataSeriesStyle(DataSeries dataSeries) {
        return this.dataSeriesStyle.get(dataSeries);
    }

    public void setDataSeriesStyle(DataSeries dataSeries, DataSeriesStyle style) {
        this.dataSeriesStyle.put(dataSeries, style);
    }

    public boolean isUseIndividualAxisSegments() {
        return this.useIndividualAxisSegments;
    }

    public void setUseIndividualAxisSegments(boolean useIndividualAxisSegments) {
        this.useIndividualAxisSegments = useIndividualAxisSegments;
    }

    public int getAxisSegments() {
        return this.axisSegments;
    }

    public void setAxisSegments(int axisSegments) {
        this.axisSegments = Math.max(1, axisSegments);
    }

    public FillStyle getBackgroundFillStyle() {
        return this.backgroundFillStyle;
    }

    public void setBackgroundFillStyle(FillStyle backgroundFillStyle) {
        this.backgroundFillStyle = backgroundFillStyle;
    }

    public LineStyle getBackgroundLineStyle() {
        return this.backgroundLineStyle;
    }

    public void setBackgroundLineStyle(LineStyle backgroundLineStyle) {
        this.backgroundLineStyle = backgroundLineStyle;
    }
}

