/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.spiderchart.style;

import java.text.DecimalFormat;
import javafx.scene.paint.Color;
import org.fortiss.tooling.common.ui.javafx.style.FillStyle;
import org.fortiss.tooling.common.ui.javafx.style.FontStyle;
import org.fortiss.tooling.common.ui.javafx.style.LineStyle;
import org.fortiss.tooling.spiderchart.model.AxisBase;
import org.fortiss.tooling.spiderchart.model.DoubleAxis;
import org.fortiss.tooling.spiderchart.model.EnumerationAxis;

public final class DataSeriesStyle {
    private final LineStyle lineStyle;
    private final FillStyle fillStyle;
    private final FontStyle indicatorLabelStyle;
    private final double indicatorSize;
    private final boolean showIndicators;
    private final boolean showIndicatorLabels;
    private DecimalFormat decimalFormat;

    public DataSeriesStyle(LineStyle lineStyle, FillStyle fillStyle, boolean withIndicators, boolean withIndicatorLabels, FontStyle indicatorStyle, double indicatorSize, DecimalFormat decimalFormat) {
        this.lineStyle = lineStyle;
        this.fillStyle = fillStyle;
        this.showIndicators = withIndicators;
        this.showIndicatorLabels = withIndicatorLabels;
        this.indicatorLabelStyle = indicatorStyle;
        this.indicatorSize = indicatorSize;
        this.decimalFormat = decimalFormat;
    }

    public DataSeriesStyle() {
        this(LineStyle.SOLID_BLACK_1PT, new FillStyle(Color.LIGHTGRAY), true, true, FontStyle.BLACK_VERDANA_10PT, 7.0, new DecimalFormat("#.##"));
    }

    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    public FillStyle getFillStyle() {
        return this.fillStyle;
    }

    public boolean isShowIndicators() {
        return this.showIndicators;
    }

    public boolean isShowIndicatorLabels() {
        return this.showIndicatorLabels;
    }

    public FontStyle getIndicatorLabelStyle() {
        return this.indicatorLabelStyle;
    }

    public double getIndicatorSize() {
        return this.indicatorSize;
    }

    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    public String getFormattedLabel(AxisBase axis, Object value) {
        if (axis instanceof DoubleAxis && value instanceof Double) {
            return this.getDecimalFormat().format(value);
        }
        if (axis instanceof EnumerationAxis) {
            return value.toString();
        }
        return null;
    }
}

