/*
 * Decompiled with CFR 0.152.
 */
package test.org.fortiss.tooling.spiderchart;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import org.fortiss.tooling.common.ui.javafx.layout.CompositeFXControllerBase;
import org.fortiss.tooling.common.ui.javafx.layout.ICompositeFXController;
import org.fortiss.tooling.common.ui.javafx.style.FillStyle;
import org.fortiss.tooling.common.ui.javafx.style.FontStyle;
import org.fortiss.tooling.common.ui.javafx.style.LineStyle;
import org.fortiss.tooling.spiderchart.control.SpiderChartViewer;
import org.fortiss.tooling.spiderchart.model.DataSeries;
import org.fortiss.tooling.spiderchart.model.DoubleAxis;
import org.fortiss.tooling.spiderchart.model.EnumerationAxis;
import org.fortiss.tooling.spiderchart.model.SpiderChart;
import org.fortiss.tooling.spiderchart.style.AxisStyle;
import org.fortiss.tooling.spiderchart.style.ChartStyle;
import org.fortiss.tooling.spiderchart.style.DataSeriesStyle;
import org.fortiss.tooling.spiderchart.style.LegendStyle;

public class SpiderChartExampleFXController
extends CompositeFXControllerBase<AnchorPane, Node> {
    @FXML
    Pane pane;
    @FXML
    Pane anchorPane;
    private static Comparator<Screen> screenComparator = new Comparator<Screen>(){

        @Override
        public int compare(Screen o1, Screen o2) {
            return o1.width - o2.width;
        }
    };

    public SpiderChartExampleFXController() {
        super(new ICompositeFXController[0]);
    }

    private static SpiderChartViewer buildSpiderChart() {
        SpiderChart spiderChart = new SpiderChart();
        spiderChart.setTitle("Smartphone Comparison Scale");
        spiderChart.setLegendLabel("Legend");
        DoubleAxis battery = new DoubleAxis("Battery", 0.0, 4.0);
        DoubleAxis camera = new DoubleAxis("Camera", 0.0, 7.0);
        DoubleAxis display = new DoubleAxis("Display", 0.0, 5.0);
        DoubleAxis memory = new DoubleAxis("Memory", 0.0, 5.0);
        DoubleAxis brand = new DoubleAxis("Brand", 0.0, 5.0);
        Screen sc0 = new Screen(0);
        Screen sc100 = new Screen(100);
        Screen sc240 = new Screen(240);
        Screen sc320 = new Screen(320);
        Screen sc640 = new Screen(640);
        Screen sc1024 = new Screen(1024);
        Screen[] screens = new Screen[]{sc0, sc100, sc240, sc320, sc640, sc1024};
        EnumerationAxis<Screen> screen = new EnumerationAxis<Screen>("Screen Width", screenComparator, Arrays.asList(screens));
        spiderChart.addAxis(battery);
        spiderChart.addAxis(camera);
        spiderChart.addAxis(display);
        spiderChart.addAxis(memory);
        spiderChart.addAxis(brand);
        spiderChart.addAxis(screen);
        DataSeries iPhoneData = new DataSeries("Phone 1");
        iPhoneData.setPoint(battery, 4.0);
        iPhoneData.setPoint(camera, 3.5);
        iPhoneData.setPoint(display, 4.0);
        iPhoneData.setPoint(memory, 4.6);
        iPhoneData.setPoint(brand, 5.0);
        iPhoneData.setPoint(screen, sc240);
        spiderChart.addData(iPhoneData);
        DataSeries nexusData = new DataSeries("Phone 2");
        nexusData.setPoint(battery, 3.0);
        nexusData.setPoint(camera, 4.5);
        nexusData.setPoint(display, 3.0);
        nexusData.setPoint(memory, 3.6);
        nexusData.setPoint(brand, 4.0);
        nexusData.setPoint(screen, sc640);
        spiderChart.addData(nexusData);
        ChartStyle chartStyle = new ChartStyle(true, true, true);
        chartStyle.setUseIndividualAxisSegments(false);
        chartStyle.setTitleStyle(new FontStyle("Verdana", 14.0, Color.BLUE.brighter()));
        LegendStyle legendStyle = new LegendStyle(false, 5.0, FontStyle.BLACK_VERDANA_12PT);
        chartStyle.setLegendStyle(legendStyle);
        AxisStyle aStyle3Segs = new AxisStyle(LineStyle.SOLID_BLACK_1PT, FontStyle.BLACK_VERDANA_14PT, 3, FontStyle.BLACK_VERDANA_8PT, new DecimalFormat("#.##"));
        chartStyle.setAxisStyle(battery, aStyle3Segs);
        AxisStyle aStyle6Segs = new AxisStyle(LineStyle.SOLID_BLACK_1PT, FontStyle.BLACK_VERDANA_14PT, 6, FontStyle.BLACK_VERDANA_8PT, new DecimalFormat("#.##"));
        chartStyle.setAxisStyle(camera, aStyle6Segs);
        AxisStyle aStyle4Segs = new AxisStyle(LineStyle.SOLID_BLACK_1PT, FontStyle.BLACK_VERDANA_14PT, 4, FontStyle.BLACK_VERDANA_8PT, new DecimalFormat("#.##"));
        chartStyle.setAxisStyle(display, aStyle4Segs);
        chartStyle.setAxisStyle(memory, aStyle4Segs);
        chartStyle.setAxisStyle(brand, aStyle4Segs);
        chartStyle.setAxisStyle(screen, aStyle6Segs);
        chartStyle.setAxisSegments(4);
        chartStyle.setBackgroundFillStyle(new FillStyle(Color.LIGHTGRAY));
        chartStyle.setBackgroundLineStyle(new LineStyle(Color.DARKGRAY));
        LineStyle olive1pt = new LineStyle(Color.GREEN);
        FillStyle oliveFill = new FillStyle(Color.GREEN, 0.25);
        DataSeriesStyle iphoneStyle = new DataSeriesStyle(olive1pt, oliveFill, true, true, FontStyle.BLACK_VERDANA_10PT, 7.0, new DecimalFormat("#.#"));
        chartStyle.setDataSeriesStyle(iPhoneData, iphoneStyle);
        LineStyle navy1pt = new LineStyle(Color.RED);
        FillStyle navyFill = new FillStyle(Color.RED, 0.25);
        DataSeriesStyle nexusStyle = new DataSeriesStyle(navy1pt, navyFill, true, true, FontStyle.BLACK_VERDANA_10PT, 7.0, new DecimalFormat("#.#"));
        chartStyle.setDataSeriesStyle(nexusData, nexusStyle);
        SpiderChartViewer viewer = new SpiderChartViewer(spiderChart, chartStyle);
        return viewer;
    }

    public String getFXMLLocation() {
        return "SpiderChartExample.fxml";
    }

    public void initialize() {
        Pane viewerPane = SpiderChartExampleFXController.buildSpiderChart().getViewerPane();
        viewerPane.setPrefSize(500.0, 500.0);
        this.anchorPane.getChildren().add((Object)viewerPane);
    }

    private static class Screen
    implements Comparable<Screen> {
        public int width = 0;

        public Screen(int width) {
            this.width = width;
        }

        @Override
        public int compareTo(Screen o) {
            return screenComparator.compare(this, o);
        }

        public String toString() {
            return this.width + "px";
        }
    }
}

