/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.allocation.compose;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.allocation.IAllocationService;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.tooling.base.compose.ModelElementCompositorBase;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.data.IElementCompositionContext;
import org.fortiss.tooling.kernel.extension.data.Prototype;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.service.IElementCompositorService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public abstract class AllocationTableCollectionCompositorBase
extends ModelElementCompositorBase<AllocationTableCollection> {
    private Class<? extends AllocationTable> allocationTableType;
    private int maxAllocationTableInstances;

    protected AllocationTableCollectionCompositorBase(Class<? extends AllocationTable> allocationTableType, int maxAllocationTableInstances) {
        this.allocationTableType = allocationTableType;
        this.maxAllocationTableInstances = maxAllocationTableInstances;
        if (maxAllocationTableInstances < 0) {
            String compositorName = ((Object)((Object)this)).getClass().getCanonicalName();
            throw new RuntimeException(compositorName + ": Invalid maximum number of allocation table specialization instances: " + maxAllocationTableInstances);
        }
    }

    private int getNumberOfAllocationTables(AllocationTableCollection atCollection) {
        return EcoreUtils.pickInstanceOf(this.allocationTableType, atCollection.getAllocationTables()).size();
    }

    private boolean isAnyRootElementAssignable(Collection<Class<? extends IProjectRootElement>> types1, Collection<Class<? extends IProjectRootElement>> types2) {
        for (Class<? extends IProjectRootElement> t1 : types1) {
            for (Class<? extends IProjectRootElement> t2 : types2) {
                if (!t1.isAssignableFrom(t2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canCompose(AllocationTableCollection container, EObject contained, IElementCompositionContext context) {
        if (!this.allocationTableType.isAssignableFrom(contained.getClass())) {
            return false;
        }
        IAllocationService as = IAllocationService.getInstance();
        Collection<Class<? extends IProjectRootElement>> sourceModelTypes = as.getSourceModelTypes(this.allocationTableType);
        if (KernelModelElementUtils.getRootElements((EObject)container, sourceModelTypes).isEmpty()) {
            return false;
        }
        Collection<Class<? extends IProjectRootElement>> targetModelTypes = as.getTargetModelTypes(this.allocationTableType);
        if (KernelModelElementUtils.getRootElements((EObject)container, targetModelTypes).isEmpty()) {
            return false;
        }
        if (this.maxAllocationTableInstances != 0 && this.getNumberOfAllocationTables(container) >= this.maxAllocationTableInstances) {
            return false;
        }
        for (AllocationTable at : container.getAllocationTables()) {
            Class<?> currAtType = AllocationUtils.getAllocationTableType(at.getClass());
            if (this.allocationTableType.isAssignableFrom(currAtType) || as.getAdmissibleAllocationTables(this.allocationTableType).contains(currAtType)) continue;
            Collection<Class<? extends IProjectRootElement>> currSourceModelTypes = as.getSourceModelTypes(currAtType);
            Collection<Class<? extends IProjectRootElement>> currTargetModelTypes = as.getTargetModelTypes(currAtType);
            if (this.isAnyRootElementAssignable(sourceModelTypes, currSourceModelTypes) || this.isAnyRootElementAssignable(targetModelTypes, currTargetModelTypes)) {
                return false;
            }
            if (!this.isCoveredModelType(currAtType, sourceModelTypes, targetModelTypes) && !this.isCoveredModelType(this.allocationTableType, sourceModelTypes, targetModelTypes)) continue;
            return false;
        }
        return true;
    }

    private boolean isCoveredModelType(Class<? extends AllocationTable> atType, Collection<Class<? extends IProjectRootElement>> sourceModelTypes, Collection<Class<? extends IProjectRootElement>> targetModelTypes) {
        IAllocationService as = IAllocationService.getInstance();
        Collection<Class<? extends IProjectRootElement>> coveredModelTypes = as.getCoveredModelTypes(atType);
        return this.isAnyRootElementAssignable(coveredModelTypes, sourceModelTypes) || this.isAnyRootElementAssignable(coveredModelTypes, targetModelTypes);
    }

    public boolean canComposePrototype(Prototype prototype) {
        return this.allocationTableType.isAssignableFrom(prototype.getPrototype().getClass());
    }

    public boolean canDecompose(EObject contained) {
        return this.allocationTableType.isAssignableFrom(contained.getClass());
    }

    public boolean compose(AllocationTableCollection container, EObject contained, IElementCompositionContext context) {
        super.compose((EObject)container, contained, context);
        container.getContainedElements().add((Object)((IHierarchicElement)this.allocationTableType.cast(contained)));
        return true;
    }

    public boolean decompose(EObject contained) {
        EObject eContainer = contained.eContainer();
        boolean rval = super.decompose(contained);
        if (eContainer.eContents().isEmpty()) {
            rval &= IElementCompositorService.getInstance().decompose(eContainer);
        }
        return rval;
    }
}

