/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.allocation.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.fortiss.af3.allocation.IAllocationService;
import org.fortiss.af3.allocation.model.AllocationEntry;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.IAllocationType;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.types.EMFTypeMap;
import org.fortiss.tooling.kernel.service.types.EMFTypeToTypeMap;
import org.fortiss.tooling.kernel.service.types.EMFTypeToTypeSetMap;
import org.fortiss.tooling.kernel.service.types.TypeSet;

public final class AllocationService
implements IAllocationService,
IIntrospectiveKernelService {
    private EMFTypeToTypeSetMap<AllocationEntry, IModelElement> sourceEntityTypeMap = new EMFTypeToTypeSetMap();
    private EMFTypeToTypeSetMap<AllocationEntry, IModelElement> targetEntityTypeMap = new EMFTypeToTypeSetMap();
    private EMFTypeToTypeSetMap<AllocationTable, IProjectRootElement> sourceModelTypeMap = new EMFTypeToTypeSetMap();
    private EMFTypeToTypeSetMap<AllocationTable, IProjectRootElement> targetModelTypeMap = new EMFTypeToTypeSetMap();
    private EMFTypeToTypeSetMap<AllocationTable, IProjectRootElement> coveredModelTypeMap = new EMFTypeToTypeSetMap();
    private EMFTypeToTypeSetMap<AllocationTable, AllocationTable> admissibleAllocationTableTypeMap = new EMFTypeToTypeSetMap();
    private EMFTypeToTypeSetMap<AllocationTable, AllocationEntry> allocationTableEntryTypeMap = new EMFTypeToTypeSetMap();
    private EMFTypeMap<AllocationTable, Void> internalAllocationTableTypeMap = new EMFTypeMap();
    private EMFTypeToTypeSetMap<AllocationEntry, AllocationEntry> parentChildEntryTypeMap = new EMFTypeToTypeSetMap();
    private EMFTypeToTypeMap<AllocationEntry, AllocationEntry> childParentEntryTypeMap = new EMFTypeToTypeMap();
    private List<TypeSet<AllocationEntry>> sourceEntityMutualExclusions = new ArrayList<TypeSet<AllocationEntry>>();
    private List<TypeSet<AllocationEntry>> targetEntityMutualExclusions = new ArrayList<TypeSet<AllocationEntry>>();
    private static final AllocationService INSTANCE = new AllocationService();

    public static AllocationService getInstance() {
        return INSTANCE;
    }

    @Override
    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService((IIntrospectiveKernelService)this);
    }

    @Override
    public void initializeService() {
    }

    @Override
    public void addAllocationTableType(Class<? extends AllocationTable> allocationTableType, Class<? extends IProjectRootElement> sourceModelType, Class<? extends IProjectRootElement> targetModelType) {
        this.addAllocationTableType(allocationTableType, sourceModelType, targetModelType, false);
    }

    @Override
    public void addAllocationTableType(Class<? extends AllocationTable> allocationTableType, Class<? extends IProjectRootElement> sourceModelType, Class<? extends IProjectRootElement> targetModelType, boolean isInternal) {
        this.sourceModelTypeMap.addTypeSetEntry(allocationTableType, sourceModelType);
        this.targetModelTypeMap.addTypeSetEntry(allocationTableType, targetModelType);
        if (isInternal) {
            this.internalAllocationTableTypeMap.put(allocationTableType, null);
        }
    }

    @Override
    public <T extends AllocationTable & IAllocationType, E extends AllocationEntry & IAllocationType> void addAllocationEntryType(Class<? extends T> allocationTableType, Class<? extends E> allocationEntryType, Class<? extends IModelElement> sourceEntityType, Class<? extends IModelElement> targetEntityType) {
        this.allocationTableEntryTypeMap.addTypeSetEntry(allocationTableType, allocationEntryType);
        this.addSourceEntityType(allocationEntryType, sourceEntityType);
        this.addTargetEntityType(allocationEntryType, targetEntityType);
    }

    @Override
    public <T extends AllocationTable & IAllocationType, E extends AllocationEntry & IAllocationType> void addAllocationEntryType(Class<? extends T> allocationTableType, Class<? extends E> allocationEntryType, Class<? extends IModelElement> sourceEntityType, Class<? extends IModelElement> targetEntityType, Class<? extends E> parentAllocationEntryType) {
        this.addAllocationEntryType(allocationTableType, allocationEntryType, sourceEntityType, targetEntityType);
        this.addParentAllocationEntryType(allocationEntryType, parentAllocationEntryType);
    }

    @Override
    @SafeVarargs
    public final <E extends AllocationEntry & IAllocationType, A extends IAllocationType> Collection<Class<? extends AllocationEntry>> getAllocationEntryTypes(Class<? extends AllocationTable> allocationTableType, Class<? extends A> ... allocationTypes) {
        Collection entries = this.allocationTableEntryTypeMap.getTargetTypes(allocationTableType);
        return LambdaUtils.filterTypes((Collection)entries, (Class[])allocationTypes);
    }

    @Override
    public Collection<Class<? extends AllocationTable>> getAllocationTableTypesForEntryType(Class<? extends AllocationEntry> entryType) {
        return this.allocationTableEntryTypeMap.getSourceTypes(entryType);
    }

    @Override
    public Collection<Class<? extends AllocationTable>> getAllocationTableTypesForSourceView(Class<? extends IProjectRootElement> sourceViewType) {
        return this.sourceModelTypeMap.getSourceTypes(sourceViewType);
    }

    @Override
    public Collection<Class<? extends AllocationTable>> getAllocationTableTypesForTargetView(Class<? extends IProjectRootElement> targetViewType) {
        return this.targetModelTypeMap.getSourceTypes(targetViewType);
    }

    @Override
    public void addSourceEntityType(Class<? extends AllocationEntry> allocationEntryType, Class<? extends IModelElement> sourceEntityType) {
        this.sourceEntityTypeMap.addTypeSetEntry(allocationEntryType, sourceEntityType);
    }

    @Override
    public void addTargetEntityType(Class<? extends AllocationEntry> allocationEntryType, Class<? extends IModelElement> targetEntityType) {
        this.targetEntityTypeMap.addTypeSetEntry(allocationEntryType, targetEntityType);
    }

    @Override
    public Collection<Class<? extends IModelElement>> getSourceEntityTypes(Class<? extends AllocationEntry> allocationEntryType) {
        return this.sourceEntityTypeMap.getTargetTypes(allocationEntryType);
    }

    @Override
    public Collection<Class<? extends IModelElement>> getTargetEntityTypes(Class<? extends AllocationEntry> allocationEntryType) {
        return this.targetEntityTypeMap.getTargetTypes(allocationEntryType);
    }

    @Override
    public Collection<Class<? extends IProjectRootElement>> getSourceModelTypes(Class<? extends AllocationTable> allocationTableType) {
        return this.sourceModelTypeMap.getTargetTypes(allocationTableType);
    }

    @Override
    public Collection<Class<? extends IProjectRootElement>> getTargetModelTypes(Class<? extends AllocationTable> allocationTableType) {
        return this.targetModelTypeMap.getTargetTypes(allocationTableType);
    }

    @Override
    public void addCoveredModelType(Class<? extends AllocationTable> allocationTableType, Class<? extends IProjectRootElement> targetModelType) {
        this.coveredModelTypeMap.addTypeSetEntry(allocationTableType, targetModelType);
    }

    @Override
    public Collection<Class<? extends IProjectRootElement>> getCoveredModelTypes(Class<? extends AllocationTable> allocationTableType) {
        return this.coveredModelTypeMap.getTargetTypes(allocationTableType);
    }

    @Override
    public void addAdmissibleAllocationTablePair(Class<? extends AllocationTable> atType1, Class<? extends AllocationTable> atType2) {
        this.admissibleAllocationTableTypeMap.addTypeSetEntry(atType1, atType2);
        this.admissibleAllocationTableTypeMap.addTypeSetEntry(atType2, atType1);
    }

    @Override
    public Collection<Class<? extends AllocationTable>> getAdmissibleAllocationTables(Class<? extends AllocationTable> allocationTableType) {
        return this.admissibleAllocationTableTypeMap.getTargetTypes(allocationTableType);
    }

    @Override
    public boolean isAllocationTableInternal(Class<? extends AllocationTable> allocationTableType) {
        return this.internalAllocationTableTypeMap.containsKey(allocationTableType);
    }

    private void addParentAllocationEntryType(Class<? extends AllocationEntry> childEntryType, Class<? extends AllocationEntry> parentEntryType) {
        this.parentChildEntryTypeMap.addTypeSetEntry(parentEntryType, childEntryType);
        this.childParentEntryTypeMap.put(childEntryType, parentEntryType);
    }

    @Override
    public Class<? extends AllocationEntry> getParentEntryType(Class<? extends AllocationEntry> childEntryType) {
        return (Class)this.childParentEntryTypeMap.get(childEntryType);
    }

    @Override
    public Collection<Class<? extends AllocationEntry>> getChildEntryTypes(Class<? extends AllocationEntry> parentEntryType) {
        return this.parentChildEntryTypeMap.getTargetTypes(parentEntryType);
    }

    private void addMutualExclusionEntityType(List<TypeSet<AllocationEntry>> mutualExclusions, Class<? extends AllocationEntry> allocationEntryType, Class<? extends AllocationEntry> otherAllocationEntryType) {
        TypeSet entrySet = this.getMutualExclusionTypeSet(mutualExclusions, allocationEntryType);
        if (entrySet != null) {
            entrySet.add(otherAllocationEntryType);
            return;
        }
        entrySet = this.getMutualExclusionTypeSet(mutualExclusions, otherAllocationEntryType);
        if (entrySet == null) {
            entrySet = new TypeSet();
            entrySet.add(allocationEntryType);
            entrySet.add(otherAllocationEntryType);
            mutualExclusions.add((TypeSet<AllocationEntry>)entrySet);
        } else {
            entrySet.add(allocationEntryType);
        }
    }

    @Override
    public void addSourceEntityMutualEntryTypeExclusion(Class<? extends AllocationEntry> allocationEntryType, Class<? extends AllocationEntry> otherAllocationEntryType) {
        this.addMutualExclusionEntityType(this.sourceEntityMutualExclusions, allocationEntryType, otherAllocationEntryType);
    }

    @Override
    public void addTargetEntityMutualEntryTypeExclusion(Class<? extends AllocationEntry> allocationEntryType, Class<? extends AllocationEntry> otherAllocationEntryType) {
        this.addMutualExclusionEntityType(this.targetEntityMutualExclusions, allocationEntryType, otherAllocationEntryType);
    }

    private TypeSet<AllocationEntry> getMutualExclusionTypeSet(List<TypeSet<AllocationEntry>> mutualExclusions, Class<? extends AllocationEntry> referenceEntryType) {
        for (TypeSet<AllocationEntry> entrySet : mutualExclusions) {
            if (!entrySet.contains(referenceEntryType)) continue;
            return entrySet;
        }
        return null;
    }

    @Override
    public Collection<Class<? extends AllocationEntry>> getSourceEntityMutuallyExclusiveEntryTypes(Class<? extends AllocationEntry> referenceEntryType) {
        TypeSet<AllocationEntry> rval = this.getMutualExclusionTypeSet(this.sourceEntityMutualExclusions, referenceEntryType);
        return rval != null ? rval : Collections.emptyList();
    }

    @Override
    public Collection<Class<? extends AllocationEntry>> getTargetEntityMutuallyExclusiveEntryTypes(Class<? extends AllocationEntry> referenceEntryType) {
        TypeSet<AllocationEntry> rval = this.getMutualExclusionTypeSet(this.targetEntityMutualExclusions, referenceEntryType);
        return rval != null ? rval : Collections.emptyList();
    }

    public String getIntrospectionDescription() {
        return this.getIntrospectionLabel() + "\n\nThe service can be used to configure valid mappings between different layers of the system model based on refinements of the generic allocation metamodel provided by af3.allocation.";
    }

    public String getIntrospectionLabel() {
        return "Allocation Service";
    }

    public IIntrospectionDetailsItem getDetailsItem() {
        return null;
    }

    public boolean showInIntrospectionNavigation() {
        return true;
    }

    public Collection<IIntrospectionItem> getIntrospectionItems() {
        return Collections.emptyList();
    }
}

