/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.allocation.model.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.allocation.model.AllocationEntry;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.allocation.model.IBidirectional;
import org.fortiss.af3.allocation.model.IUnidirectional;
import org.fortiss.af3.allocation.model.ManyToOneAllocationEntry;
import org.fortiss.af3.allocation.model.OneToManyAllocationEntry;
import org.fortiss.af3.allocation.model.OneToOneAllocationEntry;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class AllocationTableStaticImpl {
    private static <T> EList<T> toEList(Set<T> set) {
        return (EList)set.stream().collect(Collectors.toCollection(BasicEList::new));
    }

    public static EList<AllocationEntry> getAllocationEntries(AllocationTable allocationTable) {
        return EcoreUtils.pickInstanceOf(AllocationEntry.class, (List)allocationTable.getContainedElements());
    }

    public static <T extends AllocationEntry> EList<T> getAllocationEntries(AllocationTable allocationTable, Class<T> type) {
        return EcoreUtils.pickInstanceOf(type, (List)allocationTable.getContainedElements());
    }

    public static void clearAllocationEntries(AllocationTable allocationTable) {
        allocationTable.getContainedElements().clear();
    }

    public static <T extends OneToOneAllocationEntry & IBidirectional> IModelElement getTargetElement(AllocationTable allocationTable, IModelElement sourceElement, Class<T> type) {
        for (OneToOneAllocationEntry ae : AllocationTableStaticImpl.getAllocationEntries(allocationTable, type)) {
            if (ae.getSourceElement() != sourceElement) continue;
            return ae.getTargetElement();
        }
        return null;
    }

    public static <T extends ManyToOneAllocationEntry & IBidirectional> IModelElement getTargetElement(AllocationTable allocationTable, EList<IModelElement> sourceElements, Class<T> type) {
        for (ManyToOneAllocationEntry ae : AllocationTableStaticImpl.getAllocationEntries(allocationTable, type)) {
            if (!ae.getSourceElements().containsAll(sourceElements)) continue;
            return ae.getTargetElement();
        }
        return null;
    }

    public static <T extends AllocationEntry> EList<IModelElement> getTargetElements(AllocationTable allocationTable, IModelElement sourceElement, Class<T> type) {
        HashSet<IModelElement> rval;
        block7: {
            block8: {
                block6: {
                    rval = new HashSet<IModelElement>();
                    if (!OneToManyAllocationEntry.class.isAssignableFrom(type)) break block6;
                    for (OneToManyAllocationEntry ae : AllocationTableStaticImpl.getAllocationEntries(allocationTable, type)) {
                        if (ae.getSourceElement() != sourceElement) continue;
                        if (IBidirectional.class.isAssignableFrom(type)) {
                            return ae.getTargetElements();
                        }
                        rval.addAll((Collection<IModelElement>)ae.getTargetElements());
                    }
                    break block7;
                }
                if (!OneToOneAllocationEntry.class.isAssignableFrom(type)) break block8;
                for (OneToOneAllocationEntry ae : AllocationTableStaticImpl.getAllocationEntries(allocationTable, type)) {
                    if (ae.getSourceElement() != sourceElement) continue;
                    if (IBidirectional.class.isAssignableFrom(type)) {
                        return ECollections.singletonEList((Object)ae.getTargetElement());
                    }
                    rval.add(ae.getTargetElement());
                }
                break block7;
            }
            if (!ManyToOneAllocationEntry.class.isAssignableFrom(type)) break block7;
            for (ManyToOneAllocationEntry ae : AllocationTableStaticImpl.getAllocationEntries(allocationTable, type)) {
                if (!ae.getSourceElements().contains((Object)sourceElement)) continue;
                if (IBidirectional.class.isAssignableFrom(type)) {
                    return ECollections.singletonEList((Object)ae.getTargetElement());
                }
                rval.add(ae.getTargetElement());
            }
        }
        return AllocationTableStaticImpl.toEList(rval);
    }

    public static <T extends ManyToOneAllocationEntry & IUnidirectional> EList<IModelElement> getTargetElements(AllocationTable allocationTable, EList<IModelElement> sourceElements, Class<T> type) {
        HashSet<IModelElement> rval = new HashSet<IModelElement>();
        for (ManyToOneAllocationEntry ae : AllocationTableStaticImpl.getAllocationEntries(allocationTable, type)) {
            if (!ae.getSourceElements().containsAll(sourceElements)) continue;
            rval.add(ae.getTargetElement());
        }
        return AllocationTableStaticImpl.toEList(rval);
    }

    public static <T extends AllocationEntry> EList<IModelElement> getTargetElements(AllocationTable allocationTable, Class<T> type) {
        HashSet<IModelElement> rval = new HashSet<IModelElement>();
        for (AllocationEntry ae : AllocationTableStaticImpl.getAllocationEntries(allocationTable, type)) {
            rval.addAll(AllocationUtils.getTargetElements(ae));
        }
        return AllocationTableStaticImpl.toEList(rval);
    }

    public static <T extends OneToOneAllocationEntry & IBidirectional> IModelElement getSourceElement(AllocationTable allocationTable, IModelElement targetElement, Class<T> type) {
        for (OneToOneAllocationEntry ae : AllocationTableStaticImpl.getAllocationEntries(allocationTable, type)) {
            if (ae.getTargetElement() != targetElement) continue;
            return ae.getSourceElement();
        }
        return null;
    }

    public static <T extends OneToManyAllocationEntry & IBidirectional> IModelElement getSourceElement(AllocationTable allocationTable, EList<IModelElement> targetElements, Class<T> type) {
        for (OneToManyAllocationEntry ae : AllocationTableStaticImpl.getAllocationEntries(allocationTable, type)) {
            if (!ae.getTargetElements().containsAll(targetElements)) continue;
            return ae.getSourceElement();
        }
        return null;
    }

    public static <T extends AllocationEntry> EList<IModelElement> getSourceElements(AllocationTable allocationTable, IModelElement targetElement, Class<T> type) {
        HashSet<IModelElement> rval;
        block7: {
            block8: {
                block6: {
                    rval = new HashSet<IModelElement>();
                    if (!ManyToOneAllocationEntry.class.isAssignableFrom(type)) break block6;
                    for (ManyToOneAllocationEntry ae : AllocationTableStaticImpl.getAllocationEntries(allocationTable, type)) {
                        if (ae.getTargetElement() != targetElement) continue;
                        if (IBidirectional.class.isAssignableFrom(type)) {
                            return ae.getSourceElements();
                        }
                        rval.addAll((Collection<IModelElement>)ae.getSourceElements());
                    }
                    break block7;
                }
                if (!OneToOneAllocationEntry.class.isAssignableFrom(type)) break block8;
                for (OneToOneAllocationEntry ae : AllocationTableStaticImpl.getAllocationEntries(allocationTable, type)) {
                    if (ae.getTargetElement() != targetElement) continue;
                    if (IBidirectional.class.isAssignableFrom(type)) {
                        return ECollections.singletonEList((Object)ae.getSourceElement());
                    }
                    rval.add(ae.getSourceElement());
                }
                break block7;
            }
            if (!OneToManyAllocationEntry.class.isAssignableFrom(type)) break block7;
            for (OneToManyAllocationEntry ae : AllocationTableStaticImpl.getAllocationEntries(allocationTable, type)) {
                if (!ae.getTargetElements().contains((Object)targetElement)) continue;
                if (IBidirectional.class.isAssignableFrom(type)) {
                    return ECollections.singletonEList((Object)ae.getSourceElement());
                }
                rval.add(ae.getSourceElement());
            }
        }
        return AllocationTableStaticImpl.toEList(rval);
    }

    public static <T extends OneToManyAllocationEntry & IUnidirectional> EList<IModelElement> getSourceElements(AllocationTable allocationTable, EList<IModelElement> targetElements, Class<T> type) {
        BasicEList rval = new BasicEList();
        for (OneToManyAllocationEntry ae : AllocationTableStaticImpl.getAllocationEntries(allocationTable, type)) {
            if (!ae.getTargetElements().containsAll(targetElements)) continue;
            rval.add((Object)ae.getSourceElement());
        }
        return rval;
    }

    public static <T extends AllocationEntry> EList<IModelElement> getSourceElements(AllocationTable allocationTable, Class<T> type) {
        HashSet<IModelElement> rval = new HashSet<IModelElement>();
        for (AllocationEntry ae : AllocationTableStaticImpl.getAllocationEntries(allocationTable, type)) {
            rval.addAll(AllocationUtils.getSourceElements(ae));
        }
        return AllocationTableStaticImpl.toEList(rval);
    }

    public static AllocationTableCollection getAllocationTableCollection(AllocationTable allocationTable) {
        return (AllocationTableCollection)allocationTable.getContainer();
    }
}

