/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.allocation.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.af3.allocation.AF3AllocationActivator;
import org.fortiss.af3.allocation.IAllocationService;
import org.fortiss.af3.allocation.model.AllocationEntry;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.allocation.model.IBidirectional;
import org.fortiss.af3.allocation.model.IUnidirectional;
import org.fortiss.af3.allocation.model.ManyToOneAllocationEntry;
import org.fortiss.af3.allocation.model.OneToManyAllocationEntry;
import org.fortiss.af3.allocation.model.OneToOneAllocationEntry;
import org.fortiss.af3.allocation.model.ParameterEntry;
import org.fortiss.af3.allocation.model.ParameterTable;
import org.fortiss.af3.allocation.utils.AllocationModelElementFactory;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.base.annotation.AnnotationEntry;
import org.fortiss.tooling.base.annotation.IAnnotationValueService;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.service.IElementCompositorService;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class AllocationUtils {
    public static <T extends AllocationEntry> boolean addAllocationEntry(AllocationTable allocationTable, Class<T> entryType, IModelElement sourceElement, IModelElement targetElement) {
        if (AllocationUtils.isAllocated(allocationTable, entryType, sourceElement, targetElement)) {
            return false;
        }
        T allocationEntry = AllocationUtils.getAllocationEntry(allocationTable, entryType, AllocationUtils.isManyToOne(entryType) ? null : sourceElement, AllocationUtils.isOneToMany(entryType) ? null : targetElement);
        boolean createdEntry = false;
        if (allocationEntry == null) {
            allocationEntry = AllocationModelElementFactory.createAllocationEntry(entryType);
            createdEntry = true;
        }
        if (AllocationUtils.isOneToOne(entryType)) {
            OneToOneAllocationEntry oneToOneAllocationEntry = (OneToOneAllocationEntry)allocationEntry;
            oneToOneAllocationEntry.setSourceElement(sourceElement);
            oneToOneAllocationEntry.setTargetElement(targetElement);
        } else if (AllocationUtils.isOneToMany(entryType)) {
            OneToManyAllocationEntry oneToManyAllocationEntry = (OneToManyAllocationEntry)allocationEntry;
            oneToManyAllocationEntry.setSourceElement(sourceElement);
            oneToManyAllocationEntry.getTargetElements().add((Object)targetElement);
        } else if (AllocationUtils.isManyToOne(entryType)) {
            ManyToOneAllocationEntry manyToOneAllocationEntry = (ManyToOneAllocationEntry)allocationEntry;
            manyToOneAllocationEntry.getSourceElements().add((Object)sourceElement);
            manyToOneAllocationEntry.setTargetElement(targetElement);
        } else assert (false);
        if (createdEntry) {
            allocationTable.getContainedElements().add(allocationEntry);
        }
        return true;
    }

    public static <T extends AllocationEntry> boolean deleteAllocationEntry(AllocationTable allocationTable, Class<T> entryType, IModelElement sourceElement, IModelElement targetElement, boolean deleteChildAllocations) {
        ManyToOneAllocationEntry manyToOneAllocationEntry;
        T allocationEntry = AllocationUtils.getAllocationEntry(allocationTable, entryType, sourceElement, targetElement);
        if (allocationEntry == null) {
            return false;
        }
        if (deleteChildAllocations) {
            AllocationUtils.deleteChildAllocationEntries(allocationTable, entryType, sourceElement, targetElement);
        }
        if (AllocationUtils.isOneToMany(entryType)) {
            OneToManyAllocationEntry oneToManyAllocationEntry = (OneToManyAllocationEntry)allocationEntry;
            if (oneToManyAllocationEntry.getTargetElements().size() > 1) {
                oneToManyAllocationEntry.getTargetElements().remove((Object)targetElement);
                return true;
            }
        } else if (AllocationUtils.isManyToOne(entryType) && (manyToOneAllocationEntry = (ManyToOneAllocationEntry)allocationEntry).getSourceElements().size() > 1) {
            manyToOneAllocationEntry.getSourceElements().remove((Object)sourceElement);
            return true;
        }
        allocationTable.getContainedElements().remove(allocationEntry);
        return true;
    }

    private static void deleteChildAllocationEntries(AllocationTable allocationTable, Class<? extends AllocationEntry> parentEntryType, IModelElement parentSourceElement, IModelElement parentTargetElement) {
        Collection<Class<? extends AllocationEntry>> childAllocationEntryTypes = IAllocationService.getInstance().getChildEntryTypes(parentEntryType);
        for (Class<? extends AllocationEntry> childAllocationEntryType : childAllocationEntryTypes) {
            for (AllocationEntry childAllocationEntry : allocationTable.getAllocationEntries(childAllocationEntryType)) {
                IModelElement childTargetElement;
                IModelElement childSourceElement;
                AllocationEntry ae;
                if (AllocationUtils.isOneToOne(childAllocationEntryType)) {
                    ae = (OneToOneAllocationEntry)childAllocationEntry;
                    childSourceElement = ae.getSourceElement();
                    IModelElement childTargetElement2 = ae.getTargetElement();
                    if (childSourceElement.eContainer() != parentSourceElement || childTargetElement2.eContainer() != parentTargetElement) continue;
                    AllocationUtils.deleteAllocationEntry(allocationTable, childAllocationEntryType, childSourceElement, childTargetElement2, false);
                    continue;
                }
                if (AllocationUtils.isOneToMany(childAllocationEntryType)) {
                    ae = (OneToManyAllocationEntry)childAllocationEntry;
                    childSourceElement = ae.getSourceElement();
                    if (childSourceElement.eContainer() != parentSourceElement) continue;
                    BasicEList childTargetElements = new BasicEList(ae.getTargetElements());
                    for (IModelElement childTargetElement3 : childTargetElements) {
                        if (childTargetElement3.eContainer() != parentTargetElement) continue;
                        AllocationUtils.deleteAllocationEntry(allocationTable, childAllocationEntryType, childSourceElement, childTargetElement3, false);
                    }
                    continue;
                }
                if (!AllocationUtils.isManyToOne(childAllocationEntryType) || (childTargetElement = (ae = (ManyToOneAllocationEntry)childAllocationEntry).getTargetElement()).eContainer() != parentTargetElement) continue;
                BasicEList childSourceElements = new BasicEList(ae.getSourceElements());
                for (IModelElement childSourceElement2 : childSourceElements) {
                    if (childSourceElement2.eContainer() != parentSourceElement) continue;
                    AllocationUtils.deleteAllocationEntry(allocationTable, childAllocationEntryType, childSourceElement2, childTargetElement, false);
                }
            }
        }
    }

    public static boolean isAllocated(AllocationTable allocationTable, Class<? extends AllocationEntry> entryType, IModelElement sourceElement, IModelElement targetElement) {
        return AllocationUtils.getAllocationEntry(allocationTable, entryType, sourceElement, targetElement) != null;
    }

    public static boolean isModifiableAllocationEntry(AllocationTable allocationTable, Class<? extends AllocationEntry> entryType, IModelElement sourceElement, IModelElement targetElement, Class<? extends AllocationEntry> parentEntryType, boolean hasSourceViewHiddenRootElement) {
        if (AllocationUtils.isAllocated(allocationTable, entryType, sourceElement, targetElement)) {
            return true;
        }
        IAllocationService as = IAllocationService.getInstance();
        if (!LambdaUtils.isAssignableFromAny(as.getSourceEntityTypes(entryType), (Object)sourceElement)) {
            return false;
        }
        if (!LambdaUtils.isAssignableFromAny(as.getTargetEntityTypes(entryType), (Object)targetElement)) {
            return false;
        }
        EObject srcContainer = sourceElement.eContainer();
        EObject tgtContainer = targetElement.eContainer();
        if (parentEntryType != null && srcContainer instanceof IModelElement && tgtContainer instanceof IModelElement) {
            boolean isSourceRootElement = srcContainer.eContainer() instanceof IProjectRootElement;
            if (isSourceRootElement && hasSourceViewHiddenRootElement) {
                return true;
            }
            if (!AllocationUtils.isAllocated(allocationTable, parentEntryType, (IModelElement)srcContainer, (IModelElement)tgtContainer)) {
                return false;
            }
        }
        Collection<? extends IModelElement> relatedTargetElements = AllocationUtils.getRelatedModelElements(targetElement, as.getTargetEntityTypes(entryType));
        for (IModelElement iModelElement : AllocationUtils.getRelatedModelElements(sourceElement, as.getSourceEntityTypes(entryType))) {
            for (IModelElement iModelElement2 : relatedTargetElements) {
                if (!AllocationUtils.isAllocated(allocationTable, entryType, iModelElement, iModelElement2)) continue;
                return false;
            }
        }
        for (Class clazz : as.getSourceEntityMutuallyExclusiveEntryTypes(entryType)) {
            if (!AllocationUtils.isAllocated(allocationTable, clazz, sourceElement, null)) continue;
            return false;
        }
        for (Class clazz : as.getTargetEntityMutuallyExclusiveEntryTypes(entryType)) {
            if (!AllocationUtils.isAllocated(allocationTable, clazz, null, targetElement)) continue;
            return false;
        }
        if (IUnidirectional.class.isAssignableFrom(entryType)) {
            return true;
        }
        if (AllocationUtils.isOneToOne(entryType)) {
            return !AllocationUtils.isAllocated(allocationTable, entryType, null, targetElement) && !AllocationUtils.isAllocated(allocationTable, entryType, sourceElement, null);
        }
        if (AllocationUtils.isOneToMany(entryType)) {
            return !AllocationUtils.isAllocated(allocationTable, entryType, null, targetElement);
        }
        if (AllocationUtils.isManyToOne(entryType)) {
            return !AllocationUtils.isAllocated(allocationTable, entryType, sourceElement, null);
        }
        return true;
    }

    private static Collection<? extends IModelElement> getRelatedModelElements(IModelElement element, Collection<Class<? extends IModelElement>> types) {
        ArrayList<IModelElement> rval = new ArrayList<IModelElement>();
        Class[] typesArray = types.toArray(new Class[types.size()]);
        IModelElement ancestorTargetElement = element;
        while (ancestorTargetElement != null) {
            EObject container;
            if (ReflectionUtils.isInstanceOfAny((Object)ancestorTargetElement, (Class[])typesArray)) {
                rval.add(ancestorTargetElement);
            }
            if (!((container = ancestorTargetElement.eContainer()) instanceof IModelElement)) break;
            ancestorTargetElement = (IModelElement)container;
        }
        for (IModelElement offspringElement : EcoreUtils.getChildrenWithType((EObject)element, IModelElement.class)) {
            if (!ReflectionUtils.isInstanceOfAny((Object)offspringElement, (Class[])typesArray)) continue;
            rval.add(offspringElement);
        }
        return rval;
    }

    public static <T extends AllocationEntry> T getAllocationEntry(AllocationTable allocationTable, Class<T> entryType, IModelElement sourceElement, IModelElement targetElement) {
        block5: {
            block6: {
                block4: {
                    if (sourceElement == null && targetElement == null) {
                        return null;
                    }
                    if (!AllocationUtils.isOneToOne(entryType)) break block4;
                    for (OneToOneAllocationEntry allocationEntry : allocationTable.getAllocationEntries(entryType)) {
                        if (allocationEntry.getSourceElement() != sourceElement && sourceElement != null || allocationEntry.getTargetElement() != targetElement && targetElement != null) continue;
                        return (T)allocationEntry;
                    }
                    break block5;
                }
                if (!AllocationUtils.isOneToMany(entryType)) break block6;
                for (OneToManyAllocationEntry allocationEntry : allocationTable.getAllocationEntries(entryType)) {
                    if (allocationEntry.getSourceElement() != sourceElement && sourceElement != null || !allocationEntry.getTargetElements().contains((Object)targetElement) && targetElement != null) continue;
                    return (T)allocationEntry;
                }
                break block5;
            }
            if (!AllocationUtils.isManyToOne(entryType)) break block5;
            for (ManyToOneAllocationEntry allocationEntry : allocationTable.getAllocationEntries(entryType)) {
                if (!allocationEntry.getSourceElements().contains((Object)sourceElement) && sourceElement != null || allocationEntry.getTargetElement() != targetElement && targetElement != null) continue;
                return (T)allocationEntry;
            }
        }
        return null;
    }

    private static boolean isOneToOne(Class<? extends AllocationEntry> entryType) {
        return OneToOneAllocationEntry.class.isAssignableFrom(entryType);
    }

    private static boolean isOneToMany(Class<? extends AllocationEntry> entryType) {
        return OneToManyAllocationEntry.class.isAssignableFrom(entryType);
    }

    private static boolean isManyToOne(Class<? extends AllocationEntry> entryType) {
        return ManyToOneAllocationEntry.class.isAssignableFrom(entryType);
    }

    public static void checkAllocationEntryType(Class<? extends AllocationEntry> allocationEntryType) throws RuntimeException {
        if (!IUnidirectional.class.isAssignableFrom(allocationEntryType) && !IBidirectional.class.isAssignableFrom(allocationEntryType)) {
            throw new RuntimeException("AllocationEntry type " + allocationEntryType.getCanonicalName() + " must implement either IUniDirectional or IBidirectional.");
        }
    }

    public static <T> Class<T> getAllocationTableType(Class<? extends T> allocationTableImplType) {
        Class<?>[] classArray = allocationTableImplType.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iFace = classArray[n2];
            if (AllocationTable.class.isAssignableFrom(iFace)) {
                return iFace;
            }
            ++n2;
        }
        return null;
    }

    public static AllocationTable getAllocationTableWithSourceView(AllocationTableCollection atc, Class<?> sourceViewType) {
        for (AllocationTable at : atc.getAllocationTables()) {
            if (!sourceViewType.isAssignableFrom(at.getSourceView().getClass())) continue;
            return at;
        }
        return null;
    }

    public static AllocationTable getAllocationTableWithTargetView(AllocationTableCollection atc, Class<?> targetViewType) {
        for (AllocationTable at : atc.getAllocationTables()) {
            if (!targetViewType.isAssignableFrom(at.getTargetView().getClass())) continue;
            return at;
        }
        return null;
    }

    public static <T extends AllocationTable> EList<T> getAllocationTables(EObject element, Class<T> type) {
        FileProject fileProject = (FileProject)KernelModelElementUtils.getParentElement((EObject)element, FileProject.class, (boolean)true);
        return EcoreUtils.getChildrenWithType((EObject)fileProject, type);
    }

    public static AllocationTable getAllocationTableWithSourceElement(AllocationTableCollection atc, IModelElement modelElement) {
        Collection<AllocationTable> ats = AllocationUtils.getAllocationTablesWithoutParameterTables(atc);
        for (AllocationTable at : ats) {
            if (!LambdaUtils.asStream((Iterator)at.getSourceView().eAllContents()).anyMatch(e -> e == modelElement)) continue;
            return at;
        }
        return null;
    }

    public static AllocationTable getAllocationTableWithTargetElement(AllocationTableCollection atc, IModelElement modelElement) {
        Collection<AllocationTable> ats = AllocationUtils.getAllocationTablesWithoutParameterTables(atc);
        for (AllocationTable at : ats) {
            if (!LambdaUtils.asStream((Iterator)at.getTargetView().eAllContents()).anyMatch(e -> e == modelElement)) continue;
            return at;
        }
        return null;
    }

    private static Collection<AllocationTable> getAllocationTablesWithoutParameterTables(AllocationTableCollection atc) {
        return atc.getAllocationTables().stream().filter(at -> !(at instanceof ParameterTable)).collect(Collectors.toSet());
    }

    public static <T extends IModelElement> Collection<T> getAllocationSourcesTransitive(AllocationTableCollection atc, IModelElement targetElement, Class<T> sourceType) {
        AllocationTable at = AllocationUtils.getAllocationTableWithTargetElement(atc, targetElement);
        Collection<IModelElement> intermediateSrcs = AllocationUtils.getAllocationSources(targetElement, at);
        Optional firstSrc = LambdaUtils.getFirst(intermediateSrcs);
        if (firstSrc.isPresent() && sourceType.isAssignableFrom(((IModelElement)firstSrc.get()).getClass())) {
            return intermediateSrcs;
        }
        ArrayList<T> srcElements = new ArrayList<T>();
        for (IModelElement me : intermediateSrcs) {
            srcElements.addAll(AllocationUtils.getAllocationSourcesTransitive(atc, me, sourceType));
        }
        return srcElements;
    }

    private static Collection<IModelElement> getAllocationSources(IModelElement targetElement, AllocationTable at) {
        EList<IModelElement> sources = at.getSourceElements(targetElement, OneToManyAllocationEntry.class);
        if (!sources.isEmpty()) {
            return sources;
        }
        sources = at.getSourceElements(targetElement, OneToOneAllocationEntry.class);
        if (!sources.isEmpty()) {
            return sources;
        }
        return at.getSourceElements(targetElement, ManyToOneAllocationEntry.class);
    }

    public static <T extends IModelElement> Collection<T> getAllocationTargetsTransitive(AllocationTableCollection atc, IModelElement sourceElement, Class<T> targetType) {
        AllocationTable at = AllocationUtils.getAllocationTableWithSourceElement(atc, sourceElement);
        Collection<IModelElement> intermediateTgts = AllocationUtils.getAllocationTargets(sourceElement, at);
        Optional firstTgt = LambdaUtils.getFirst(intermediateTgts);
        if (firstTgt.isPresent() && targetType.isAssignableFrom(((IModelElement)firstTgt.get()).getClass())) {
            return intermediateTgts;
        }
        ArrayList<T> tgtElements = new ArrayList<T>();
        for (IModelElement me : intermediateTgts) {
            tgtElements.addAll(AllocationUtils.getAllocationTargetsTransitive(atc, me, targetType));
        }
        return tgtElements;
    }

    private static Collection<IModelElement> getAllocationTargets(IModelElement sourceElement, AllocationTable at) {
        EList<IModelElement> targets = at.getTargetElements(sourceElement, OneToManyAllocationEntry.class);
        if (!targets.isEmpty()) {
            return targets;
        }
        targets = at.getTargetElements(sourceElement, OneToOneAllocationEntry.class);
        if (!targets.isEmpty()) {
            return targets;
        }
        return at.getTargetElements(sourceElement, ManyToOneAllocationEntry.class);
    }

    public static <T extends AllocationTable & INamedElement> T getOrCreateAllocationTable(Class<T> allocationTableType, IProjectRootElement sourceView, IProjectRootElement targetView, String name) {
        AllocationTableCollection atc2;
        IProjectRootElement modelRef = sourceView != null ? sourceView : targetView;
        for (AllocationTableCollection atc2 : KernelModelElementUtils.getRootElements((EObject)modelRef, AllocationTableCollection.class)) {
            for (AllocationTable at : EcoreUtils.pickInstanceOf(allocationTableType, atc2.getAllocationTables())) {
                if (sourceView != null && at.getSourceView() != sourceView || targetView != null && at.getTargetView() != targetView) continue;
                return (T)at;
            }
        }
        if (name == null) {
            return null;
        }
        atc2 = AllocationModelElementFactory.createAllocationTableCollection("Allocations");
        AllocationTable at = (AllocationTable)EcoreUtil.create((EClass)EcoreUtils.getEClassForClass(allocationTableType));
        at.setName(name);
        at.setSourceView(sourceView);
        at.setTargetView(targetView);
        atc2.getContainedElements().add((Object)at);
        FileProject fileProject = (FileProject)EcoreUtils.getFirstParentWithType((EObject)modelRef, FileProject.class);
        if (IPersistencyService.getInstance().getTopLevelElementFor((EObject)fileProject) != null) {
            IElementCompositorService cs = IElementCompositorService.getInstance();
            cs.compose((EObject)fileProject, (EObject)atc2, null);
        } else {
            fileProject.getRootElements().add((Object)atc2);
        }
        return (T)at;
    }

    public static AnnotationEntry getAnnotationEntry(ParameterTable parameterTable, IModelElement sourceElement, IModelElement targetElement, Class<? extends ParameterEntry> parameterEntryType, Class<? extends IAnnotatedSpecification> annotationType) {
        IAnnotatedSpecification parameter = parameterTable.getParameter(sourceElement, targetElement, parameterEntryType, annotationType);
        IAnnotationValueService as = IAnnotationValueService.getInstance();
        return parameter != null ? as.getAnnotationEntry(parameter.getSpecificationOf()) : null;
    }

    public static String getParameterEntryValue(ParameterTable parameterTable, IModelElement sourceElement, IModelElement targetElement, Class<? extends ParameterEntry> parameterEntryType, Class<? extends IAnnotatedSpecification> annotationType) {
        if (AllocationUtils.isAllocated(parameterTable, parameterEntryType, sourceElement, targetElement)) {
            AnnotationEntry annotationEntry = AllocationUtils.getAnnotationEntry(parameterTable, sourceElement, targetElement, parameterEntryType, annotationType);
            Object value = annotationEntry.getSpecificationValue(annotationType);
            return value != null ? value.toString() : null;
        }
        return null;
    }

    private static void addAnnotationEntry(AllocationTable parameterTable, Class<? extends ParameterEntry> parameterEntryType, IModelElement sourceElement, IModelElement targetElement) {
        ParameterEntry parameterEntry = AllocationUtils.getAllocationEntry(parameterTable, parameterEntryType, sourceElement, targetElement);
        AnnotationUtils.instantiateAnnotationsRecursive((EObject)parameterEntry);
        UniqueIDUtils.fixMissingIDs((EObject)parameterEntry, (EObject)parameterTable);
    }

    public static boolean setParameterEntryValue(ParameterTable parameterTable, IModelElement sourceElement, IModelElement targetElement, Object value, Class<? extends ParameterEntry> parameterEntryType, Class<? extends IAnnotatedSpecification> annotationType) {
        if (!AllocationUtils.isAllocated(parameterTable, parameterEntryType, sourceElement, targetElement)) {
            AllocationUtils.addAllocationEntry(parameterTable, parameterEntryType, sourceElement, targetElement);
            AllocationUtils.addAnnotationEntry(parameterTable, parameterEntryType, sourceElement, targetElement);
        }
        if (AllocationUtils.isAllocated(parameterTable, parameterEntryType, sourceElement, targetElement)) {
            AnnotationEntry annotationEntry = AllocationUtils.getAnnotationEntry(parameterTable, sourceElement, targetElement, parameterEntryType, annotationType);
            try {
                annotationEntry.setSpecificationValue(value, annotationType);
            }
            catch (Exception e) {
                LoggingUtils.error((Plugin)AF3AllocationActivator.getDefault(), (String)("Failed to set value of \"" + annotationType.getName() + "\" ParameterEntry in \"" + KernelModelElementUtils.computeFullyQualifiedName((INamedElement)parameterTable) + "\"."), (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getParameterEntryName(ParameterTable parameterTable, IModelElement sourceElement, IModelElement targetElement, Class<? extends ParameterEntry> parameterEntryType, Class<? extends IAnnotatedSpecification> annotationType) {
        if (AllocationUtils.isAllocated(parameterTable, parameterEntryType, sourceElement, targetElement)) {
            AnnotationEntry annotationEntry = AllocationUtils.getAnnotationEntry(parameterTable, sourceElement, targetElement, parameterEntryType, annotationType);
            return annotationEntry.getSpecificationAnnotationName(annotationType);
        }
        return annotationType.getSimpleName();
    }

    public static <T extends AllocationTable> T getSubsequentAllocationTable(AllocationTable allocationTable, Class<T> subsequentAllocationTableType) {
        EList candidateTables = EcoreUtils.pickInstanceOf(subsequentAllocationTableType, allocationTable.getAllocationTableCollection().getAllocationTables());
        IProjectRootElement targetView = allocationTable.getTargetView();
        Optional<AllocationTable> rvalOpt = candidateTables.stream().filter(t -> t.getSourceView() == targetView).findFirst();
        return (T)(rvalOpt.isPresent() ? rvalOpt.get() : null);
    }

    private static Map<EObject, EObject> cloneView(IProjectRootElement view) {
        Map refMap = EcoreUtils.copyToRefMap((EObject)view);
        IProjectRootElement viewCopy = (IProjectRootElement)refMap.get(view);
        FileProject fileProject = (FileProject)KernelModelElementUtils.getParentElement((EObject)view, FileProject.class, (boolean)false);
        fileProject.getRootElements().add((Object)viewCopy);
        viewCopy.setId(0);
        LambdaUtils.asStream((Iterator)viewCopy.eAllContents()).forEach(e -> {
            if (e instanceof IIdLabeled) {
                ((IIdLabeled)e).setId(0);
            }
        });
        UniqueIDUtils.fixMissingIDs((EObject)viewCopy, (EObject)fileProject);
        return refMap;
    }

    public static void cloneView(AllocationTable at, boolean cloneSource, boolean cloneTarget) {
        Map<EObject, EObject> targetRefMap;
        Map<EObject, EObject> sourceRefMap;
        if (cloneSource) {
            IProjectRootElement sourceView = at.getSourceView();
            sourceRefMap = AllocationUtils.cloneView(sourceView);
            at.setSourceView((IProjectRootElement)sourceRefMap.get(sourceView));
        } else {
            sourceRefMap = null;
        }
        if (cloneTarget) {
            IProjectRootElement targetView = at.getTargetView();
            targetRefMap = AllocationUtils.cloneView(targetView);
            at.setTargetView((IProjectRootElement)targetRefMap.get(targetView));
        } else {
            targetRefMap = null;
        }
        for (AllocationEntry entry : at.getAllocationEntries()) {
            AllocationEntry o2m;
            if (entry instanceof OneToOneAllocationEntry) {
                OneToOneAllocationEntry o2o = (OneToOneAllocationEntry)entry;
                if (sourceRefMap != null) {
                    o2o.setSourceElement((IModelElement)sourceRefMap.get(o2o.getSourceElement()));
                }
                if (targetRefMap == null) continue;
                o2o.setTargetElement((IModelElement)targetRefMap.get(o2o.getTargetElement()));
                continue;
            }
            if (entry instanceof OneToManyAllocationEntry) {
                o2m = (OneToManyAllocationEntry)entry;
                if (sourceRefMap != null) {
                    o2m.setSourceElement((IModelElement)sourceRefMap.get(o2m.getSourceElement()));
                }
                if (targetRefMap == null) continue;
                o2m.getTargetElements().replaceAll(e -> (IModelElement)targetRefMap.get(e));
                continue;
            }
            if (!(entry instanceof ManyToOneAllocationEntry)) continue;
            o2m = (ManyToOneAllocationEntry)entry;
            if (sourceRefMap != null) {
                o2m.getSourceElements().replaceAll(e -> (IModelElement)sourceRefMap.get(e));
            }
            if (targetRefMap == null) continue;
            o2m.setTargetElement((IModelElement)targetRefMap.get(o2m.getTargetElement()));
        }
    }

    public static Collection<IModelElement> getSourceElements(AllocationEntry ae) {
        Class<?> at = ae.getClass();
        if (AllocationUtils.isOneToOne(at)) {
            return Arrays.asList(((OneToOneAllocationEntry)ae).getSourceElement());
        }
        if (AllocationUtils.isOneToMany(at)) {
            return Arrays.asList(((OneToManyAllocationEntry)ae).getSourceElement());
        }
        if (AllocationUtils.isManyToOne(at)) {
            return ((ManyToOneAllocationEntry)ae).getSourceElements();
        }
        assert (false);
        return null;
    }

    public static Collection<IModelElement> getTargetElements(AllocationEntry ae) {
        Class<?> at = ae.getClass();
        if (AllocationUtils.isOneToOne(at)) {
            return Arrays.asList(((OneToOneAllocationEntry)ae).getTargetElement());
        }
        if (AllocationUtils.isOneToMany(at)) {
            return ((OneToManyAllocationEntry)ae).getTargetElements();
        }
        if (AllocationUtils.isManyToOne(at)) {
            return Arrays.asList(((ManyToOneAllocationEntry)ae).getTargetElement());
        }
        assert (false);
        return null;
    }
}

