/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.allocation.variability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.allocation.model.AllocationEntry;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.allocation.model.ManyToOneAllocationEntry;
import org.fortiss.af3.allocation.model.OneToManyAllocationEntry;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.ext.variability.service.IDependingElementProvider;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public abstract class AllocatableDependingElementProviderBase<T extends IModelElement>
implements IDependingElementProvider<T> {
    public final List<EObject> getDependingElements(T elem) {
        ArrayList<EObject> ret = new ArrayList<EObject>();
        FileProject fileProject = (FileProject)EcoreUtils.getFirstParentWithType(elem, FileProject.class);
        if (fileProject == null) {
            return ret;
        }
        Collection<EObject> dependingElements = this.getSpecificDependingElements(elem);
        ret.addAll(dependingElements);
        HashSet<Object> removedElements = new HashSet<Object>();
        removedElements.add(elem);
        removedElements.addAll(dependingElements);
        for (IProjectRootElement rootElem : fileProject.getRootElements()) {
            if (!(rootElem instanceof AllocationTableCollection)) continue;
            for (AllocationTable table : ((AllocationTableCollection)rootElem).getAllocationTables()) {
                for (AllocationEntry entry : table.getAllocationEntries()) {
                    EList<IModelElement> manys;
                    if (entry instanceof OneToManyAllocationEntry) {
                        OneToManyAllocationEntry oneToMany = (OneToManyAllocationEntry)entry;
                        if (removedElements.contains(oneToMany.getSourceElement())) {
                            ret.add((EObject)oneToMany);
                        }
                        if (!removedElements.containsAll((Collection<?>)(manys = oneToMany.getTargetElements()))) continue;
                        ret.add((EObject)oneToMany);
                        continue;
                    }
                    if (!(entry instanceof ManyToOneAllocationEntry)) continue;
                    ManyToOneAllocationEntry manyToOne = (ManyToOneAllocationEntry)entry;
                    if (removedElements.contains(manyToOne.getTargetElement())) {
                        ret.add((EObject)manyToOne);
                    }
                    if (!removedElements.containsAll((Collection<?>)(manys = manyToOne.getSourceElements()))) continue;
                    ret.add((EObject)manyToOne);
                }
            }
        }
        return ret;
    }

    protected abstract Collection<? extends EObject> getSpecificDependingElements(T var1);
}

