/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.allocation.variability;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.fortiss.af3.allocation.model.AF3AllocationPackage;
import org.fortiss.af3.allocation.model.ManyToOneAllocationEntry;
import org.fortiss.tooling.base.model.element.ElementPackage;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.variability.analysis.constraint.ContainedQuantifierVariable;
import org.fortiss.variability.analysis.constraint.ExistentialQuantifier;
import org.fortiss.variability.analysis.constraint.IQuantifier;
import org.fortiss.variability.analysis.constraint.ProductLineConstraintBase;
import org.fortiss.variability.analysis.constraint.QuantifierVariable;
import org.fortiss.variability.model.features.configuration.VariantConfiguration;

public class ManyToOneAllocationConstraint
extends ProductLineConstraintBase {
    private static final String VAR_A = "a";
    private static final String VAR_M = "m";
    private static final EClass I_MODEL_ELEMENT = ElementPackage.eINSTANCE.getIModelElement();
    private static final EClass MANY_TO_ONE_ALLOCATION_ENTRY = AF3AllocationPackage.eINSTANCE.getManyToOneAllocationEntry();

    public ManyToOneAllocationConstraint() {
        super(null);
    }

    public String getConstraintName() {
        return "n:1 Allocation Constraint";
    }

    public String createErrorMessage(List<EObject> violatingObjects, VariantConfiguration violatingConfiguration) {
        EObject entryObj;
        if (!violatingObjects.isEmpty() && (entryObj = violatingObjects.get(0)) instanceof ManyToOneAllocationEntry) {
            ManyToOneAllocationEntry entry = (ManyToOneAllocationEntry)entryObj;
            EList<IModelElement> srcElems = entry.getSourceElements();
            Object srcElemStr = srcElems.stream().map(me -> me instanceof INamedElement ? ((INamedElement)me).getName() : me.toString()).collect(Collectors.joining(","));
            if (srcElems.size() > 1) {
                srcElemStr = "[" + (String)srcElemStr + "]";
            }
            IModelElement trgElem = entry.getTargetElement();
            String trgElemStr = trgElem.toString();
            if (trgElem instanceof INamedElement) {
                trgElemStr = ((INamedElement)trgElem).getName();
            }
            return "There is a dangling allocation from " + (String)srcElemStr + " to " + trgElemStr + " for some variants. Please make sure, that either all allocated elements (source) are in the same variants as the allocation target or remove the allocation.";
        }
        return "There is a dangling allocation for some variants. Please make sure, that either all allocated elements (source) are in the same variants as the allocation target or remove the allocation.";
    }

    public Collection<EClass> getTranslatedClasses() {
        return Arrays.asList(MANY_TO_ONE_ALLOCATION_ENTRY, I_MODEL_ELEMENT);
    }

    public Collection<EReference> getTranslatedReferences() {
        return Arrays.asList(AF3AllocationPackage.eINSTANCE.getManyToOneAllocationEntry_SourceElements(), AF3AllocationPackage.eINSTANCE.getManyToOneAllocationEntry_TargetElement());
    }

    public QuantifierVariable[] getQuantifierVariables() {
        return new QuantifierVariable[]{new QuantifierVariable(MANY_TO_ONE_ALLOCATION_ENTRY, VAR_A)};
    }

    protected BoolExpr createBody() {
        final Context context = this.translation.getContext();
        final Expr nullModelElement = this.translation.getNullElement(I_MODEL_ELEMENT);
        FuncDecl trgFun = this.translation.getAttributeReferenceFunctionDeclaration(MANY_TO_ONE_ALLOCATION_ENTRY, "targetElement");
        final Expr z3VarA = this.getZ3Variable(VAR_A);
        ExistentialQuantifier maniesEmpty = new ExistentialQuantifier(this.translation){

            public QuantifierVariable[] getQuantifierVariables() {
                return new QuantifierVariable[]{new ContainedQuantifierVariable(I_MODEL_ELEMENT, ManyToOneAllocationConstraint.VAR_M, MANY_TO_ONE_ALLOCATION_ENTRY, z3VarA, "sourceElements")};
            }

            protected BoolExpr createBody() {
                Expr z3VarM = this.getZ3Variable(ManyToOneAllocationConstraint.VAR_M);
                return context.mkNot((Expr)context.mkEq(z3VarM, nullModelElement));
            }
        };
        return context.mkOr(new Expr[]{context.mkNot((Expr)this.translation.translateQuantifier((IQuantifier)maniesEmpty)), context.mkEq(context.mkApp(trgFun, new Expr[]{z3VarA}), nullModelElement)});
    }
}

