/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.allocation.variability;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.fortiss.af3.allocation.model.AF3AllocationPackage;
import org.fortiss.tooling.base.model.element.ElementPackage;
import org.fortiss.variability.analysis.constraint.ProductLineConstraintBase;
import org.fortiss.variability.analysis.constraint.QuantifierVariable;
import org.fortiss.variability.model.features.configuration.VariantConfiguration;

public class OneToOneAllocationConstraint
extends ProductLineConstraintBase {
    private static final String VAR_A = "a";
    private static final EClass I_MODEL_ELEMENT = ElementPackage.eINSTANCE.getIModelElement();
    private static final EClass ONE_TO_ONE_ALLOCATION_ENTRY = AF3AllocationPackage.eINSTANCE.getOneToOneAllocationEntry();

    public OneToOneAllocationConstraint() {
        super(null);
    }

    public String getConstraintName() {
        return "1:1 Allocation Constraint";
    }

    public String createErrorMessage(List<EObject> violatingObjects, VariantConfiguration violatingConfiguration) {
        return "There are dangling allocations for some variants. Please make sure, that either both allocated elements (source and target) are in the same variants or remove the allocation.";
    }

    public Collection<EClass> getTranslatedClasses() {
        return Arrays.asList(ONE_TO_ONE_ALLOCATION_ENTRY, I_MODEL_ELEMENT);
    }

    public Collection<EReference> getTranslatedReferences() {
        return Arrays.asList(AF3AllocationPackage.eINSTANCE.getOneToOneAllocationEntry_SourceElement(), AF3AllocationPackage.eINSTANCE.getOneToOneAllocationEntry_TargetElement());
    }

    public QuantifierVariable[] getQuantifierVariables() {
        return new QuantifierVariable[]{new QuantifierVariable(ONE_TO_ONE_ALLOCATION_ENTRY, VAR_A)};
    }

    protected BoolExpr createBody() {
        Context context = this.translation.getContext();
        Expr nullModelElement = this.translation.getNullElement(I_MODEL_ELEMENT);
        FuncDecl srcFun = this.translation.getAttributeReferenceFunctionDeclaration(ONE_TO_ONE_ALLOCATION_ENTRY, "sourceElement");
        FuncDecl trgFun = this.translation.getAttributeReferenceFunctionDeclaration(ONE_TO_ONE_ALLOCATION_ENTRY, "targetElement");
        Expr a = this.getZ3Variable(VAR_A);
        return context.mkOr(new Expr[]{context.mkEq(context.mkApp(srcFun, new Expr[]{a}), nullModelElement), context.mkEq(context.mkApp(trgFun, new Expr[]{a}), nullModelElement)});
    }
}

