/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public abstract class PointerBuffer
implements Comparable<PointerBuffer> {
    private static final Factory FACTORY = Pointer.BITS64 ? x64.access$000() : x32.access$100();

    PointerBuffer() {
    }

    public static PointerBuffer allocateDirect(int capacity) {
        return FACTORY.allocateDirect(capacity);
    }

    public static PointerBuffer create(long address, int capacity) {
        return FACTORY.create(address, capacity);
    }

    public static PointerBuffer create(ByteBuffer source) {
        return FACTORY.create(source);
    }

    public static PointerBuffer setup(PointerBuffer buffer, long address, int capacity) {
        return FACTORY.setup(buffer, address, capacity);
    }

    protected abstract Buffer buffer();

    public long address0() {
        return MemoryUtil.memAddress0(this.buffer());
    }

    public int capacity() {
        return this.buffer().capacity();
    }

    public int position() {
        return this.buffer().position();
    }

    public PointerBuffer position(int newPosition) {
        this.buffer().position(newPosition);
        return this;
    }

    public int limit() {
        return this.buffer().limit();
    }

    public PointerBuffer limit(int newLimit) {
        this.buffer().limit(newLimit);
        return this;
    }

    public PointerBuffer mark() {
        this.buffer().mark();
        return this;
    }

    public PointerBuffer reset() {
        this.buffer().reset();
        return this;
    }

    public PointerBuffer clear() {
        this.buffer().clear();
        return this;
    }

    public PointerBuffer flip() {
        this.buffer().flip();
        return this;
    }

    public PointerBuffer rewind() {
        this.buffer().rewind();
        return this;
    }

    public int remaining() {
        return this.buffer().remaining();
    }

    public boolean hasRemaining() {
        return this.buffer().hasRemaining();
    }

    public abstract PointerBuffer slice();

    public abstract PointerBuffer duplicate();

    public abstract PointerBuffer asReadOnlyBuffer();

    public boolean isReadOnly() {
        return this.buffer().isReadOnly();
    }

    public abstract long get();

    public static long get(ByteBuffer source) {
        return FACTORY.get(source);
    }

    public abstract PointerBuffer put(long var1);

    public static void put(ByteBuffer target, long p) {
        FACTORY.put(target, p);
    }

    public abstract long get(int var1);

    public static long get(ByteBuffer source, int index) {
        return FACTORY.get(source, index);
    }

    public abstract PointerBuffer put(int var1, long var2);

    public static void put(ByteBuffer target, int index, long p) {
        FACTORY.put(target, index, p);
    }

    public PointerBuffer put(Pointer wrapper) {
        this.put(wrapper.address());
        return this;
    }

    public PointerBuffer put(int index, Pointer wrapper) {
        this.put(index, wrapper.address());
        return this;
    }

    public PointerBuffer put(ByteBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(ShortBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(IntBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(LongBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(FloatBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(DoubleBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer putAddressOf(PointerBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index, ByteBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index, ShortBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index, IntBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index, LongBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index, FloatBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index, DoubleBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer putAddressOf(int index, PointerBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public ByteBuffer getByteBuffer(int size) {
        return MemoryUtil.memByteBuffer(this.get(), size);
    }

    public ShortBuffer getShortBuffer(int size) {
        return MemoryUtil.memShortBuffer(this.get(), size);
    }

    public IntBuffer getIntBuffer(int size) {
        return MemoryUtil.memIntBuffer(this.get(), size);
    }

    public LongBuffer getLongBuffer(int size) {
        return MemoryUtil.memLongBuffer(this.get(), size);
    }

    public FloatBuffer getFloatBuffer(int size) {
        return MemoryUtil.memFloatBuffer(this.get(), size);
    }

    public DoubleBuffer getDoubleBuffer(int size) {
        return MemoryUtil.memDoubleBuffer(this.get(), size);
    }

    public PointerBuffer getPointerBuffer(int size) {
        return MemoryUtil.memPointerBuffer(this.get(), size);
    }

    public ByteBuffer getByteBuffer(int index, int size) {
        return MemoryUtil.memByteBuffer(this.get(index), size);
    }

    public ShortBuffer getShortBuffer(int index, int size) {
        return MemoryUtil.memShortBuffer(this.get(index), size);
    }

    public IntBuffer getIntBuffer(int index, int size) {
        return MemoryUtil.memIntBuffer(this.get(index), size);
    }

    public LongBuffer getLongBuffer(int index, int size) {
        return MemoryUtil.memLongBuffer(this.get(index), size);
    }

    public FloatBuffer getFloatBuffer(int index, int size) {
        return MemoryUtil.memFloatBuffer(this.get(index), size);
    }

    public DoubleBuffer getDoubleBuffer(int index, int size) {
        return MemoryUtil.memDoubleBuffer(this.get(index), size);
    }

    public PointerBuffer getPointerBuffer(int index, int size) {
        return MemoryUtil.memPointerBuffer(this.get(index), size);
    }

    public PointerBuffer get(long[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public abstract PointerBuffer get(long[] var1, int var2, int var3);

    public abstract PointerBuffer put(PointerBuffer var1);

    public PointerBuffer put(long[] src) {
        return this.put(src, 0, src.length);
    }

    public abstract PointerBuffer put(long[] var1, int var2, int var3);

    public abstract PointerBuffer compact();

    public abstract ByteOrder order();

    public String toString() {
        return this.getClass().getName() + "[pos=" + this.position() + " lim=" + this.limit() + " cap=" + this.capacity() + "]";
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + (int)this.get(i);
        }
        return h;
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof PointerBuffer)) {
            return false;
        }
        PointerBuffer that = (PointerBuffer)ob;
        if (this.remaining() != that.remaining()) {
            return false;
        }
        int p = this.position();
        int i = this.limit() - 1;
        int j = that.limit() - 1;
        while (i >= p) {
            long v2;
            long v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    @Override
    public int compareTo(PointerBuffer that) {
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            long v2;
            long v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }

    private static void checkBounds(int off, int len, int size) {
        if ((off | len | off + len | size - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    private static class x64
    extends PointerBuffer {
        private static final Factory FACTORYx64 = new Factory(){

            @Override
            public PointerBuffer allocateDirect(int capacity) {
                return new x64(BufferUtils.createLongBuffer(capacity));
            }

            @Override
            public PointerBuffer create(long address, int capacity) {
                return new x64(MemoryUtil.memLongBuffer(address, capacity));
            }

            @Override
            public PointerBuffer create(ByteBuffer source) {
                return new x64(MemoryUtil.memSlice(source).asLongBuffer());
            }

            @Override
            public PointerBuffer setup(PointerBuffer buffer, long address, int capacity) {
                x64 x642 = (x64)buffer;
                LongBuffer source = MemoryUtil.memSetupBuffer(x642.buffer, address, capacity);
                return source == x642.buffer ? buffer : new x64(source);
            }

            @Override
            public long get(ByteBuffer source) {
                return source.getLong();
            }

            @Override
            public long get(ByteBuffer source, int index) {
                return source.getLong(index);
            }

            @Override
            public void put(ByteBuffer target, long p) {
                target.putLong(p);
            }

            @Override
            public void put(ByteBuffer target, int index, long p) {
                target.putLong(index, p);
            }
        };
        private final LongBuffer buffer;

        private x64(LongBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public Buffer buffer() {
            return this.buffer;
        }

        @Override
        public PointerBuffer slice() {
            return new x64(this.buffer.slice());
        }

        @Override
        public PointerBuffer duplicate() {
            return new x64(this.buffer.duplicate());
        }

        @Override
        public PointerBuffer asReadOnlyBuffer() {
            return new x64(this.buffer.asReadOnlyBuffer());
        }

        @Override
        public long get() {
            return this.buffer.get();
        }

        @Override
        public PointerBuffer put(long p) {
            this.buffer.put(p);
            return this;
        }

        @Override
        public long get(int index) {
            return this.buffer.get(index);
        }

        @Override
        public PointerBuffer put(int index, long p) {
            this.buffer.put(index, p);
            return this;
        }

        @Override
        public PointerBuffer get(long[] dst, int offset, int length) {
            this.buffer.get(dst, offset, length);
            return this;
        }

        @Override
        public PointerBuffer put(PointerBuffer src) {
            this.buffer.put(((x64)src).buffer);
            return this;
        }

        @Override
        public PointerBuffer put(long[] src, int offset, int length) {
            this.buffer.put(src, offset, length);
            return this;
        }

        @Override
        public PointerBuffer compact() {
            this.buffer.compact();
            return this;
        }

        @Override
        public ByteOrder order() {
            return this.buffer.order();
        }

        static /* synthetic */ Factory access$000() {
            return FACTORYx64;
        }
    }

    private static class x32
    extends PointerBuffer {
        private static final Factory FACTORYx32 = new Factory(){

            @Override
            public PointerBuffer allocateDirect(int capacity) {
                return new x32(BufferUtils.createIntBuffer(capacity));
            }

            @Override
            public PointerBuffer create(long address, int capacity) {
                return new x32(MemoryUtil.memIntBuffer(address, capacity));
            }

            @Override
            public PointerBuffer create(ByteBuffer source) {
                return new x32(MemoryUtil.memSlice(source).asIntBuffer());
            }

            @Override
            public PointerBuffer setup(PointerBuffer buffer, long address, int capacity) {
                x32 x322 = (x32)buffer;
                IntBuffer source = MemoryUtil.memSetupBuffer(x322.buffer, address, capacity);
                return source == x322.buffer ? buffer : new x32(source);
            }

            @Override
            public long get(ByteBuffer source) {
                return (long)source.getInt() & 0xFFFFFFFFL;
            }

            @Override
            public long get(ByteBuffer source, int index) {
                return (long)source.getInt(index) & 0xFFFFFFFFL;
            }

            @Override
            public void put(ByteBuffer target, long p) {
                target.putInt((int)p);
            }

            @Override
            public void put(ByteBuffer target, int index, long p) {
                target.putInt(index, (int)p);
            }
        };
        private final IntBuffer buffer;

        private x32(IntBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public Buffer buffer() {
            return this.buffer;
        }

        @Override
        public PointerBuffer slice() {
            return new x32(this.buffer.slice());
        }

        @Override
        public PointerBuffer duplicate() {
            return new x32(this.buffer.duplicate());
        }

        @Override
        public PointerBuffer asReadOnlyBuffer() {
            return new x32(this.buffer.asReadOnlyBuffer());
        }

        @Override
        public long get() {
            return (long)this.buffer.get() & 0xFFFFFFFFL;
        }

        @Override
        public PointerBuffer put(long p) {
            this.buffer.put((int)p);
            return this;
        }

        @Override
        public long get(int index) {
            return (long)this.buffer.get(index) & 0xFFFFFFFFL;
        }

        @Override
        public PointerBuffer put(int index, long p) {
            this.buffer.put(index, (int)p);
            return this;
        }

        @Override
        public PointerBuffer get(long[] dst, int offset, int length) {
            PointerBuffer.checkBounds(offset, length, dst.length);
            if (length > this.remaining()) {
                throw new BufferUnderflowException();
            }
            int end = offset + length;
            for (int i = offset; i < end; ++i) {
                dst[i] = this.get();
            }
            return this;
        }

        @Override
        public PointerBuffer put(PointerBuffer src) {
            this.buffer.put(((x32)src).buffer);
            return this;
        }

        @Override
        public PointerBuffer put(long[] src, int offset, int length) {
            PointerBuffer.checkBounds(offset, length, src.length);
            if (length > this.remaining()) {
                throw new BufferOverflowException();
            }
            int end = offset + length;
            for (int i = offset; i < end; ++i) {
                this.put(src[i]);
            }
            return this;
        }

        @Override
        public PointerBuffer compact() {
            this.buffer.compact();
            return this;
        }

        @Override
        public ByteOrder order() {
            return this.buffer.order();
        }

        static /* synthetic */ Factory access$100() {
            return FACTORYx32;
        }
    }

    private static interface Factory {
        public PointerBuffer allocateDirect(int var1);

        public PointerBuffer create(long var1, int var3);

        public PointerBuffer create(ByteBuffer var1);

        public PointerBuffer setup(PointerBuffer var1, long var2, int var4);

        public long get(ByteBuffer var1);

        public long get(ByteBuffer var1, int var2);

        public void put(ByteBuffer var1, long var2);

        public void put(ByteBuffer var1, int var2, long var3);
    }
}

