/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class EXTDeviceEnumeration {
    public final long QueryDevicesEXT;

    protected EXTDeviceEnumeration() {
        throw new UnsupportedOperationException();
    }

    public EXTDeviceEnumeration(FunctionProvider provider) {
        this.QueryDevicesEXT = provider.getFunctionAddress("eglQueryDevicesEXT");
    }

    public static EXTDeviceEnumeration getInstance() {
        return EXTDeviceEnumeration.getInstance(EGL.getCapabilities());
    }

    public static EXTDeviceEnumeration getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTDeviceEnumeration);
    }

    public static boolean neglQueryDevicesEXT(int max_devices, long devices, long num_devices) {
        long __functionAddress = EXTDeviceEnumeration.getInstance().QueryDevicesEXT;
        return JNI.callIPPZ(__functionAddress, max_devices, devices, num_devices);
    }

    public static boolean eglQueryDevicesEXT(int max_devices, ByteBuffer devices, ByteBuffer num_devices) {
        if (Checks.CHECKS) {
            if (devices != null) {
                Checks.checkBuffer((Buffer)devices, max_devices << Pointer.POINTER_SHIFT);
            }
            Checks.checkBuffer((Buffer)num_devices, 4);
        }
        return EXTDeviceEnumeration.neglQueryDevicesEXT(max_devices, MemoryUtil.memAddressSafe(devices), MemoryUtil.memAddress(num_devices));
    }

    public static boolean eglQueryDevicesEXT(PointerBuffer devices, IntBuffer num_devices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)num_devices, 1);
        }
        return EXTDeviceEnumeration.neglQueryDevicesEXT(devices == null ? 0 : devices.remaining(), MemoryUtil.memAddressSafe(devices), MemoryUtil.memAddress(num_devices));
    }
}

