/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class EXTDeviceQuery {
    public static final int EGL_BAD_DEVICE_EXT = 12843;
    public static final int EGL_DEVICE_EXT = 12844;
    public static final long EGL_NO_DEVICE_EXT = 0L;
    public final long QueryDeviceAttribEXT;
    public final long QueryDeviceStringEXT;
    public final long QueryDisplayAttribEXT;

    protected EXTDeviceQuery() {
        throw new UnsupportedOperationException();
    }

    public EXTDeviceQuery(FunctionProvider provider) {
        this.QueryDeviceAttribEXT = provider.getFunctionAddress("eglQueryDeviceAttribEXT");
        this.QueryDeviceStringEXT = provider.getFunctionAddress("eglQueryDeviceStringEXT");
        this.QueryDisplayAttribEXT = provider.getFunctionAddress("eglQueryDisplayAttribEXT");
    }

    public static EXTDeviceQuery getInstance() {
        return EXTDeviceQuery.getInstance(EGL.getCapabilities());
    }

    public static EXTDeviceQuery getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTDeviceQuery);
    }

    public static boolean neglQueryDeviceAttribEXT(long device, int attribute, long value) {
        long __functionAddress = EXTDeviceQuery.getInstance().QueryDeviceAttribEXT;
        if (Checks.CHECKS) {
            Checks.checkPointer(device);
        }
        return JNI.callPIPZ(__functionAddress, device, attribute, value);
    }

    public static boolean eglQueryDeviceAttribEXT(long device, int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1 << Pointer.POINTER_SHIFT);
        }
        return EXTDeviceQuery.neglQueryDeviceAttribEXT(device, attribute, MemoryUtil.memAddress(value));
    }

    public static boolean eglQueryDeviceAttribEXT(long device, int attribute, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(value, 1);
        }
        return EXTDeviceQuery.neglQueryDeviceAttribEXT(device, attribute, MemoryUtil.memAddress(value));
    }

    public static long neglQueryDeviceStringEXT(long device, int name) {
        long __functionAddress = EXTDeviceQuery.getInstance().QueryDeviceStringEXT;
        if (Checks.CHECKS) {
            Checks.checkPointer(device);
        }
        return JNI.callPIP(__functionAddress, device, name);
    }

    public static String eglQueryDeviceStringEXT(long device, int name) {
        long __result = EXTDeviceQuery.neglQueryDeviceStringEXT(device, name);
        return MemoryUtil.memDecodeASCII(__result);
    }

    public static boolean neglQueryDisplayAttribEXT(long dpy, int attribute, long value) {
        long __functionAddress = EXTDeviceQuery.getInstance().QueryDisplayAttribEXT;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
        }
        return JNI.callPIPZ(__functionAddress, dpy, attribute, value);
    }

    public static boolean eglQueryDisplayAttribEXT(long dpy, int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1 << Pointer.POINTER_SHIFT);
        }
        return EXTDeviceQuery.neglQueryDisplayAttribEXT(dpy, attribute, MemoryUtil.memAddress(value));
    }

    public static boolean eglQueryDisplayAttribEXT(long dpy, int attribute, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(value, 1);
        }
        return EXTDeviceQuery.neglQueryDisplayAttribEXT(dpy, attribute, MemoryUtil.memAddress(value));
    }
}

