/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRImage {
    public static final int EGL_NATIVE_PIXMAP_KHR = 12464;
    public static final long EGL_NO_IMAGE_KHR = 0L;
    public final long CreateImageKHR;
    public final long DestroyImageKHR;

    protected KHRImage() {
        throw new UnsupportedOperationException();
    }

    public KHRImage(FunctionProvider provider) {
        this.CreateImageKHR = provider.getFunctionAddress("eglCreateImageKHR");
        this.DestroyImageKHR = provider.getFunctionAddress("eglDestroyImageKHR");
    }

    public static KHRImage getInstance() {
        return KHRImage.getInstance(EGL.getCapabilities());
    }

    public static KHRImage getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__KHRImage);
    }

    public static long neglCreateImageKHR(long dpy, long ctx, int target, long buffer, long attrib_list) {
        long __functionAddress = KHRImage.getInstance().CreateImageKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(ctx);
            Checks.checkPointer(buffer);
        }
        return JNI.callPPIPPP(__functionAddress, dpy, ctx, target, buffer, attrib_list);
    }

    public static long eglCreateImageKHR(long dpy, long ctx, int target, long buffer, ByteBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list, 12344);
        }
        return KHRImage.neglCreateImageKHR(dpy, ctx, target, buffer, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long eglCreateImageKHR(long dpy, long ctx, int target, long buffer, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return KHRImage.neglCreateImageKHR(dpy, ctx, target, buffer, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static boolean eglDestroyImageKHR(long dpy, long image) {
        long __functionAddress = KHRImage.getInstance().DestroyImageKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(image);
        }
        return JNI.callPPZ(__functionAddress, dpy, image);
    }
}

