/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.libffi.Closure;
import org.lwjgl.system.libffi.FFICIF;
import org.lwjgl.system.libffi.LibFFI;

public abstract class GLFWDropCallback
extends Closure.Void {
    private static final FFICIF CIF = GLFWDropCallback.staticAllocCIF();
    private static final PointerBuffer ARGS = GLFWDropCallback.staticAllocPointer(3);
    private static final long CLASSPATH = GLFWDropCallback.staticAllocText("org.lwjgl.glfw.GLFWDropCallback");

    protected GLFWDropCallback() {
        super(CIF, CLASSPATH);
    }

    @Override
    protected void callback(long args) {
        this.invoke(MemoryUtil.memGetAddress(MemoryUtil.memGetAddress((long)(POINTER_SIZE * 0) + args)), MemoryUtil.memGetInt(MemoryUtil.memGetAddress((long)(POINTER_SIZE * 1) + args)), MemoryUtil.memGetAddress(MemoryUtil.memGetAddress((long)(POINTER_SIZE * 2) + args)));
    }

    public abstract void invoke(long var1, int var3, long var4);

    public static GLFWDropCallback create(final SAM sam) {
        return new GLFWDropCallback(){

            @Override
            public void invoke(long window, int count, long names) {
                sam.invoke(window, count, names);
            }
        };
    }

    public static GLFWDropCallback createBuffer(final SAMBuffer sam) {
        return new GLFWDropCallback(){

            @Override
            public void invoke(long window, int count, long names) {
                sam.invoke(window, 2.getNamesBuffer(count, names));
            }
        };
    }

    public static GLFWDropCallback createString(final SAMString sam) {
        return new GLFWDropCallback(){

            @Override
            public void invoke(long window, int count, long names) {
                sam.invoke(window, 3.getNames(count, names));
            }
        };
    }

    public static ByteBuffer[] getNamesBuffer(int count, long names) {
        ByteBuffer[] buffers = new ByteBuffer[count];
        for (int i = 0; i < count; ++i) {
            buffers[i] = MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(names + (long)(POINTER_SIZE * i)));
        }
        return buffers;
    }

    public static String[] getNames(int count, long names) {
        String[] strings = new String[count];
        for (int i = 0; i < count; ++i) {
            strings[i] = MemoryUtil.memDecodeUTF8(MemoryUtil.memGetAddress(names + (long)(POINTER_SIZE * i)));
        }
        return strings;
    }

    public static void apply(int count, long names, ConsumerBuffer consumer) {
        for (int i = 0; i < count; ++i) {
            consumer.accept(i, MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(names + (long)(POINTER_SIZE * i))));
        }
    }

    public static void apply(int count, long names, ConsumerString consumer) {
        for (int i = 0; i < count; ++i) {
            consumer.accept(i, MemoryUtil.memDecodeUTF8(MemoryUtil.memGetAddress(names + (long)(POINTER_SIZE * i))));
        }
    }

    public GLFWDropCallback set(long window) {
        GLFW.glfwSetDropCallback(window, this);
        return this;
    }

    static {
        GLFWDropCallback.prepareCIF(CALL_CONVENTION_DEFAULT, CIF, LibFFI.ffi_type_void, ARGS, LibFFI.ffi_type_pointer, LibFFI.ffi_type_sint32, LibFFI.ffi_type_pointer);
    }

    public static interface ConsumerString {
        public void accept(int var1, String var2);
    }

    public static interface ConsumerBuffer {
        public void accept(int var1, ByteBuffer var2);
    }

    public static interface SAMString {
        public void invoke(long var1, String[] var3);
    }

    public static interface SAMBuffer {
        public void invoke(long var1, ByteBuffer[] var3);
    }

    public static interface SAM {
        public void invoke(long var1, int var3, long var4);
    }
}

