/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProviderLocal;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ALC11 {
    public static final int ALC_MONO_SOURCES = 4112;
    public static final int ALC_STEREO_SOURCES = 4113;
    public static final int ALC_DEFAULT_ALL_DEVICES_SPECIFIER = 4114;
    public static final int ALC_ALL_DEVICES_SPECIFIER = 4115;
    public static final int ALC_CAPTURE_DEVICE_SPECIFIER = 784;
    public static final int ALC_CAPTURE_DEFAULT_DEVICE_SPECIFIER = 785;
    public static final int ALC_CAPTURE_SAMPLES = 786;
    public final long CaptureOpenDevice;
    public final long CaptureCloseDevice;
    public final long CaptureStart;
    public final long CaptureStop;
    public final long CaptureSamples;

    protected ALC11() {
        throw new UnsupportedOperationException();
    }

    public ALC11(FunctionProviderLocal provider) {
        this.CaptureOpenDevice = provider.getFunctionAddress("alcCaptureOpenDevice");
        this.CaptureCloseDevice = provider.getFunctionAddress("alcCaptureCloseDevice");
        this.CaptureStart = provider.getFunctionAddress("alcCaptureStart");
        this.CaptureStop = provider.getFunctionAddress("alcCaptureStop");
        this.CaptureSamples = provider.getFunctionAddress("alcCaptureSamples");
    }

    public static ALC11 getInstance() {
        return ALC11.getInstance(ALC.getCapabilities());
    }

    public static ALC11 getInstance(ALCCapabilities caps) {
        return Checks.checkFunctionality(caps.__ALC11);
    }

    static ALC11 create(Set<String> ext, FunctionProviderLocal provider) {
        if (!ext.contains("OpenALC11")) {
            return null;
        }
        ALC11 funcs = new ALC11(provider);
        boolean supported = Checks.checkFunctions(funcs.CaptureOpenDevice, funcs.CaptureCloseDevice, funcs.CaptureStart, funcs.CaptureStop, funcs.CaptureSamples);
        return ALC.checkExtension("OpenALC11", funcs, supported);
    }

    public static long nalcCaptureOpenDevice(long devicename, int frequency, int format, int buffersize) {
        long __functionAddress = ALC11.getInstance().CaptureOpenDevice;
        return JNI.invokePIIIP(__functionAddress, devicename, frequency, format, buffersize);
    }

    public static long alcCaptureOpenDevice(ByteBuffer devicename, int frequency, int format, int buffersize) {
        if (Checks.CHECKS && devicename != null) {
            Checks.checkNT1(devicename);
        }
        return ALC11.nalcCaptureOpenDevice(MemoryUtil.memAddressSafe(devicename), frequency, format, buffersize);
    }

    public static long alcCaptureOpenDevice(CharSequence devicename, int frequency, int format, int buffersize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int devicenameEncoded = __buffer.stringParamUTF8(devicename, true);
        return ALC11.nalcCaptureOpenDevice(__buffer.addressSafe(devicename, devicenameEncoded), frequency, format, buffersize);
    }

    public static boolean alcCaptureCloseDevice(long device) {
        long __functionAddress = ALC11.getInstance().CaptureCloseDevice;
        if (Checks.CHECKS) {
            Checks.checkPointer(device);
        }
        return JNI.invokePZ(__functionAddress, device);
    }

    public static void alcCaptureStart(long device) {
        long __functionAddress = ALC11.getInstance().CaptureStart;
        if (Checks.CHECKS) {
            Checks.checkPointer(device);
        }
        JNI.invokePV(__functionAddress, device);
    }

    public static void alcCaptureStop(long device) {
        long __functionAddress = ALC11.getInstance().CaptureStop;
        if (Checks.CHECKS) {
            Checks.checkPointer(device);
        }
        JNI.invokePV(__functionAddress, device);
    }

    public static void nalcCaptureSamples(long device, long buffer, int samples) {
        long __functionAddress = ALC11.getInstance().CaptureSamples;
        if (Checks.CHECKS) {
            Checks.checkPointer(device);
        }
        JNI.invokePPIV(__functionAddress, device, buffer, samples);
    }

    public static void alcCaptureSamples(long device, ByteBuffer buffer, int samples) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)buffer, samples);
        }
        ALC11.nalcCaptureSamples(device, MemoryUtil.memAddress(buffer), samples);
    }

    public static void alcCaptureSamples(long device, ByteBuffer buffer) {
        ALC11.nalcCaptureSamples(device, MemoryUtil.memAddress(buffer), buffer.remaining());
    }
}

