/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class AMDSamplePositions {
    public static final int GL_SUBSAMPLE_DISTANCE_AMD = 34879;
    public final long SetMultisamplefvAMD;

    protected AMDSamplePositions() {
        throw new UnsupportedOperationException();
    }

    public AMDSamplePositions(FunctionProvider provider) {
        this.SetMultisamplefvAMD = provider.getFunctionAddress("glSetMultisamplefvAMD");
    }

    public static AMDSamplePositions getInstance() {
        return AMDSamplePositions.getInstance(GL.getCapabilities());
    }

    public static AMDSamplePositions getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__AMDSamplePositions);
    }

    static AMDSamplePositions create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_AMD_sample_positions")) {
            return null;
        }
        AMDSamplePositions funcs = new AMDSamplePositions(provider);
        boolean supported = Checks.checkFunctions(funcs.SetMultisamplefvAMD);
        return GL.checkExtension("GL_AMD_sample_positions", funcs, supported);
    }

    public static void nglSetMultisamplefvAMD(int pname, int index, long val) {
        long __functionAddress = AMDSamplePositions.getInstance().SetMultisamplefvAMD;
        JNI.callIIPV(__functionAddress, pname, index, val);
    }

    public static void glSetMultisamplefvAMD(int pname, int index, ByteBuffer val) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)val, 8);
        }
        AMDSamplePositions.nglSetMultisamplefvAMD(pname, index, MemoryUtil.memAddress(val));
    }

    public static void glSetMultisamplefvAMD(int pname, int index, FloatBuffer val) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)val, 2);
        }
        AMDSamplePositions.nglSetMultisamplefvAMD(pname, index, MemoryUtil.memAddress(val));
    }
}

