/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBInvalidateSubdata {
    public final long InvalidateTexSubImage;
    public final long InvalidateTexImage;
    public final long InvalidateBufferSubData;
    public final long InvalidateBufferData;
    public final long InvalidateFramebuffer;
    public final long InvalidateSubFramebuffer;

    protected ARBInvalidateSubdata() {
        throw new UnsupportedOperationException();
    }

    public ARBInvalidateSubdata(FunctionProvider provider) {
        this.InvalidateTexSubImage = provider.getFunctionAddress("glInvalidateTexSubImage");
        this.InvalidateTexImage = provider.getFunctionAddress("glInvalidateTexImage");
        this.InvalidateBufferSubData = provider.getFunctionAddress("glInvalidateBufferSubData");
        this.InvalidateBufferData = provider.getFunctionAddress("glInvalidateBufferData");
        this.InvalidateFramebuffer = provider.getFunctionAddress("glInvalidateFramebuffer");
        this.InvalidateSubFramebuffer = provider.getFunctionAddress("glInvalidateSubFramebuffer");
    }

    public static ARBInvalidateSubdata getInstance() {
        return ARBInvalidateSubdata.getInstance(GL.getCapabilities());
    }

    public static ARBInvalidateSubdata getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBInvalidateSubdata);
    }

    static ARBInvalidateSubdata create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_invalidate_subdata")) {
            return null;
        }
        ARBInvalidateSubdata funcs = new ARBInvalidateSubdata(provider);
        boolean supported = Checks.checkFunctions(funcs.InvalidateTexSubImage, funcs.InvalidateTexImage, funcs.InvalidateBufferSubData, funcs.InvalidateBufferData, funcs.InvalidateFramebuffer, funcs.InvalidateSubFramebuffer);
        return GL.checkExtension("GL_ARB_invalidate_subdata", funcs, supported);
    }

    public static void glInvalidateTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth) {
        long __functionAddress = ARBInvalidateSubdata.getInstance().InvalidateTexSubImage;
        JNI.callIIIIIIIIV(__functionAddress, texture, level, xoffset, yoffset, zoffset, width, height, depth);
    }

    public static void glInvalidateTexImage(int texture, int level) {
        long __functionAddress = ARBInvalidateSubdata.getInstance().InvalidateTexImage;
        JNI.callIIV(__functionAddress, texture, level);
    }

    public static void glInvalidateBufferSubData(int buffer, long offset, long length) {
        long __functionAddress = ARBInvalidateSubdata.getInstance().InvalidateBufferSubData;
        JNI.callIPPV(__functionAddress, buffer, offset, length);
    }

    public static void glInvalidateBufferData(int buffer) {
        long __functionAddress = ARBInvalidateSubdata.getInstance().InvalidateBufferData;
        JNI.callIV(__functionAddress, buffer);
    }

    public static void nglInvalidateFramebuffer(int target, int numAttachments, long attachments) {
        long __functionAddress = ARBInvalidateSubdata.getInstance().InvalidateFramebuffer;
        JNI.callIIPV(__functionAddress, target, numAttachments, attachments);
    }

    public static void glInvalidateFramebuffer(int target, int numAttachments, ByteBuffer attachments) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)attachments, numAttachments << 2);
        }
        ARBInvalidateSubdata.nglInvalidateFramebuffer(target, numAttachments, MemoryUtil.memAddress(attachments));
    }

    public static void glInvalidateFramebuffer(int target, IntBuffer attachments) {
        ARBInvalidateSubdata.nglInvalidateFramebuffer(target, attachments.remaining(), MemoryUtil.memAddress(attachments));
    }

    public static void glInvalidateFramebuffer(int target, int attachment) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int attachments = __buffer.intParam(attachment);
        ARBInvalidateSubdata.nglInvalidateFramebuffer(target, 1, __buffer.address(attachments));
    }

    public static void nglInvalidateSubFramebuffer(int target, int numAttachments, long attachments, int x, int y, int width, int height) {
        long __functionAddress = ARBInvalidateSubdata.getInstance().InvalidateSubFramebuffer;
        JNI.callIIPIIIIV(__functionAddress, target, numAttachments, attachments, x, y, width, height);
    }

    public static void glInvalidateSubFramebuffer(int target, int numAttachments, ByteBuffer attachments, int x, int y, int width, int height) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)attachments, numAttachments << 2);
        }
        ARBInvalidateSubdata.nglInvalidateSubFramebuffer(target, numAttachments, MemoryUtil.memAddress(attachments), x, y, width, height);
    }

    public static void glInvalidateSubFramebuffer(int target, IntBuffer attachments, int x, int y, int width, int height) {
        ARBInvalidateSubdata.nglInvalidateSubFramebuffer(target, attachments.remaining(), MemoryUtil.memAddress(attachments), x, y, width, height);
    }

    public static void glInvalidateSubFramebuffer(int target, int attachment, int x, int y, int width, int height) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int attachments = __buffer.intParam(attachment);
        ARBInvalidateSubdata.nglInvalidateSubFramebuffer(target, 1, __buffer.address(attachments), x, y, width, height);
    }
}

