/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;

public class ARBSparseBuffer {
    public static final int GL_SPARSE_STORAGE_BIT_ARB = 1024;
    public static final int GL_SPARSE_BUFFER_PAGE_SIZE_ARB = 33528;
    public final long BufferPageCommitmentARB;
    public final long NamedBufferPageCommitmentEXT;
    public final long NamedBufferPageCommitmentARB;

    protected ARBSparseBuffer() {
        throw new UnsupportedOperationException();
    }

    public ARBSparseBuffer(FunctionProvider provider) {
        this.BufferPageCommitmentARB = provider.getFunctionAddress("glBufferPageCommitmentARB");
        this.NamedBufferPageCommitmentEXT = provider.getFunctionAddress("glNamedBufferPageCommitmentEXT");
        this.NamedBufferPageCommitmentARB = provider.getFunctionAddress("glNamedBufferPageCommitmentARB");
    }

    public static ARBSparseBuffer getInstance() {
        return ARBSparseBuffer.getInstance(GL.getCapabilities());
    }

    public static ARBSparseBuffer getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBSparseBuffer);
    }

    static ARBSparseBuffer create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_sparse_buffer")) {
            return null;
        }
        ARBSparseBuffer funcs = new ARBSparseBuffer(provider);
        boolean supported = Checks.checkFunctions(funcs.BufferPageCommitmentARB);
        return GL.checkExtension("GL_ARB_sparse_buffer", funcs, supported);
    }

    public static void glBufferPageCommitmentARB(int target, long offset, long size, boolean commit) {
        long __functionAddress = ARBSparseBuffer.getInstance().BufferPageCommitmentARB;
        JNI.callIPPZV(__functionAddress, target, offset, size, commit);
    }

    public static void glNamedBufferPageCommitmentEXT(int buffer, long offset, long size, boolean commit) {
        long __functionAddress = ARBSparseBuffer.getInstance().NamedBufferPageCommitmentEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIPPZV(__functionAddress, buffer, offset, size, commit);
    }

    public static void glNamedBufferPageCommitmentARB(int buffer, long offset, long size, boolean commit) {
        long __functionAddress = ARBSparseBuffer.getInstance().NamedBufferPageCommitmentARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIPPZV(__functionAddress, buffer, offset, size, commit);
    }
}

