/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class ARBUniformBufferObject {
    public static final int GL_UNIFORM_BUFFER = 35345;
    public static final int GL_UNIFORM_BUFFER_BINDING = 35368;
    public static final int GL_UNIFORM_BUFFER_START = 35369;
    public static final int GL_UNIFORM_BUFFER_SIZE = 35370;
    public static final int GL_MAX_VERTEX_UNIFORM_BLOCKS = 35371;
    public static final int GL_MAX_GEOMETRY_UNIFORM_BLOCKS = 35372;
    public static final int GL_MAX_FRAGMENT_UNIFORM_BLOCKS = 35373;
    public static final int GL_MAX_COMBINED_UNIFORM_BLOCKS = 35374;
    public static final int GL_MAX_UNIFORM_BUFFER_BINDINGS = 35375;
    public static final int GL_MAX_UNIFORM_BLOCK_SIZE = 35376;
    public static final int GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = 35377;
    public static final int GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS = 35378;
    public static final int GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = 35379;
    public static final int GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT = 35380;
    public static final int GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = 35381;
    public static final int GL_ACTIVE_UNIFORM_BLOCKS = 35382;
    public static final int GL_UNIFORM_TYPE = 35383;
    public static final int GL_UNIFORM_SIZE = 35384;
    public static final int GL_UNIFORM_NAME_LENGTH = 35385;
    public static final int GL_UNIFORM_BLOCK_INDEX = 35386;
    public static final int GL_UNIFORM_OFFSET = 35387;
    public static final int GL_UNIFORM_ARRAY_STRIDE = 35388;
    public static final int GL_UNIFORM_MATRIX_STRIDE = 35389;
    public static final int GL_UNIFORM_IS_ROW_MAJOR = 35390;
    public static final int GL_UNIFORM_BLOCK_BINDING = 35391;
    public static final int GL_UNIFORM_BLOCK_DATA_SIZE = 35392;
    public static final int GL_UNIFORM_BLOCK_NAME_LENGTH = 35393;
    public static final int GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = 35394;
    public static final int GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = 35395;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = 35396;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER = 35397;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = 35398;
    public static final int GL_INVALID_INDEX = -1;
    public final long GetUniformIndices;
    public final long GetActiveUniformsiv;
    public final long GetActiveUniformName;
    public final long GetUniformBlockIndex;
    public final long GetActiveUniformBlockiv;
    public final long GetActiveUniformBlockName;
    public final long BindBufferRange;
    public final long BindBufferBase;
    public final long GetIntegeri_v;
    public final long UniformBlockBinding;

    protected ARBUniformBufferObject() {
        throw new UnsupportedOperationException();
    }

    public ARBUniformBufferObject(FunctionProvider provider) {
        this.GetUniformIndices = provider.getFunctionAddress("glGetUniformIndices");
        this.GetActiveUniformsiv = provider.getFunctionAddress("glGetActiveUniformsiv");
        this.GetActiveUniformName = provider.getFunctionAddress("glGetActiveUniformName");
        this.GetUniformBlockIndex = provider.getFunctionAddress("glGetUniformBlockIndex");
        this.GetActiveUniformBlockiv = provider.getFunctionAddress("glGetActiveUniformBlockiv");
        this.GetActiveUniformBlockName = provider.getFunctionAddress("glGetActiveUniformBlockName");
        this.BindBufferRange = provider.getFunctionAddress("glBindBufferRange");
        this.BindBufferBase = provider.getFunctionAddress("glBindBufferBase");
        this.GetIntegeri_v = provider.getFunctionAddress("glGetIntegeri_v");
        this.UniformBlockBinding = provider.getFunctionAddress("glUniformBlockBinding");
    }

    public static ARBUniformBufferObject getInstance() {
        return ARBUniformBufferObject.getInstance(GL.getCapabilities());
    }

    public static ARBUniformBufferObject getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBUniformBufferObject);
    }

    static ARBUniformBufferObject create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_uniform_buffer_object")) {
            return null;
        }
        ARBUniformBufferObject funcs = new ARBUniformBufferObject(provider);
        boolean supported = Checks.checkFunctions(funcs.GetUniformIndices, funcs.GetActiveUniformsiv, funcs.GetActiveUniformName, funcs.GetUniformBlockIndex, funcs.GetActiveUniformBlockiv, funcs.GetActiveUniformBlockName, funcs.BindBufferRange, funcs.BindBufferBase, funcs.GetIntegeri_v, funcs.UniformBlockBinding);
        return GL.checkExtension("GL_ARB_uniform_buffer_object", funcs, supported);
    }

    public static void nglGetUniformIndices(int program, int uniformCount, long uniformNames, long uniformIndices) {
        long __functionAddress = ARBUniformBufferObject.getInstance().GetUniformIndices;
        JNI.callIIPPV(__functionAddress, program, uniformCount, uniformNames, uniformIndices);
    }

    public static void glGetUniformIndices(int program, int uniformCount, ByteBuffer uniformNames, ByteBuffer uniformIndices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformNames, uniformCount << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)uniformIndices, uniformCount << 2);
        }
        ARBUniformBufferObject.nglGetUniformIndices(program, uniformCount, MemoryUtil.memAddress(uniformNames), MemoryUtil.memAddress(uniformIndices));
    }

    public static void glGetUniformIndices(int program, PointerBuffer uniformNames, IntBuffer uniformIndices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformIndices, uniformNames.remaining());
        }
        ARBUniformBufferObject.nglGetUniformIndices(program, uniformNames.remaining(), MemoryUtil.memAddress(uniformNames), MemoryUtil.memAddress(uniformIndices));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glGetUniformIndices(int program, CharSequence[] uniformNames, IntBuffer uniformIndices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformIndices, uniformNames.length);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int uniformNamesAddress = __buffer.pointerArrayParamASCII(uniformNames);
        try {
            ARBUniformBufferObject.nglGetUniformIndices(program, uniformNames.length, __buffer.address(uniformNamesAddress), MemoryUtil.memAddress(uniformIndices));
        }
        finally {
            __buffer.pointerArrayFree(uniformNamesAddress, uniformNames.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformIndices(int program, CharSequence uniformName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int uniformNamesAddress = __buffer.pointerArrayParamASCII(uniformName);
        int uniformIndices = __buffer.intParam();
        try {
            ARBUniformBufferObject.nglGetUniformIndices(program, 1, __buffer.address(uniformNamesAddress), __buffer.address(uniformIndices));
        }
        finally {
            __buffer.pointerArrayFree(uniformNamesAddress, 1);
        }
        return __buffer.intValue(uniformIndices);
    }

    public static void nglGetActiveUniformsiv(int program, int uniformCount, long uniformIndices, int pname, long params) {
        long __functionAddress = ARBUniformBufferObject.getInstance().GetActiveUniformsiv;
        JNI.callIIPIPV(__functionAddress, program, uniformCount, uniformIndices, pname, params);
    }

    public static void glGetActiveUniformsiv(int program, int uniformCount, ByteBuffer uniformIndices, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformIndices, uniformCount << 2);
            Checks.checkBuffer((Buffer)params, uniformCount << 2);
        }
        ARBUniformBufferObject.nglGetActiveUniformsiv(program, uniformCount, MemoryUtil.memAddress(uniformIndices), pname, MemoryUtil.memAddress(params));
    }

    public static void glGetActiveUniformsiv(int program, IntBuffer uniformIndices, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, uniformIndices.remaining());
        }
        ARBUniformBufferObject.nglGetActiveUniformsiv(program, uniformIndices.remaining(), MemoryUtil.memAddress(uniformIndices), pname, MemoryUtil.memAddress(params));
    }

    public static int glGetActiveUniformsi(int program, int uniformIndex, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        int uniformIndices = __buffer.intParam(uniformIndex);
        ARBUniformBufferObject.nglGetActiveUniformsiv(program, 1, __buffer.address(uniformIndices), pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetActiveUniformName(int program, int uniformIndex, int bufSize, long length, long uniformName) {
        long __functionAddress = ARBUniformBufferObject.getInstance().GetActiveUniformName;
        JNI.callIIIPPV(__functionAddress, program, uniformIndex, bufSize, length, uniformName);
    }

    public static void glGetActiveUniformName(int program, int uniformIndex, int bufSize, ByteBuffer length, ByteBuffer uniformName) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformName, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        ARBUniformBufferObject.nglGetActiveUniformName(program, uniformIndex, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(uniformName));
    }

    public static void glGetActiveUniformName(int program, int uniformIndex, IntBuffer length, ByteBuffer uniformName) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        ARBUniformBufferObject.nglGetActiveUniformName(program, uniformIndex, uniformName.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(uniformName));
    }

    public static String glGetActiveUniformName(int program, int uniformIndex, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int uniformName = __buffer.bufferParam(bufSize);
        ARBUniformBufferObject.nglGetActiveUniformName(program, uniformIndex, bufSize, __buffer.address(length), __buffer.address(uniformName));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), uniformName);
    }

    public static String glGetActiveUniformName(int program, int uniformIndex) {
        int bufSize = ARBUniformBufferObject.glGetActiveUniformsi(program, uniformIndex, 35385);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int uniformName = __buffer.bufferParam(bufSize);
        ARBUniformBufferObject.nglGetActiveUniformName(program, uniformIndex, bufSize, __buffer.address(length), __buffer.address(uniformName));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), uniformName);
    }

    public static int nglGetUniformBlockIndex(int program, long uniformBlockName) {
        long __functionAddress = ARBUniformBufferObject.getInstance().GetUniformBlockIndex;
        return JNI.callIPI(__functionAddress, program, uniformBlockName);
    }

    public static int glGetUniformBlockIndex(int program, ByteBuffer uniformBlockName) {
        if (Checks.CHECKS) {
            Checks.checkNT1(uniformBlockName);
        }
        return ARBUniformBufferObject.nglGetUniformBlockIndex(program, MemoryUtil.memAddress(uniformBlockName));
    }

    public static int glGetUniformBlockIndex(int program, CharSequence uniformBlockName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int uniformBlockNameEncoded = __buffer.stringParamASCII(uniformBlockName, true);
        return ARBUniformBufferObject.nglGetUniformBlockIndex(program, __buffer.address(uniformBlockNameEncoded));
    }

    public static void nglGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, long params) {
        long __functionAddress = ARBUniformBufferObject.getInstance().GetActiveUniformBlockiv;
        JNI.callIIIPV(__functionAddress, program, uniformBlockIndex, pname, params);
    }

    public static void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBUniformBufferObject.nglGetActiveUniformBlockiv(program, uniformBlockIndex, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBUniformBufferObject.nglGetActiveUniformBlockiv(program, uniformBlockIndex, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetActiveUniformBlocki(int program, int uniformBlockIndex, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBUniformBufferObject.nglGetActiveUniformBlockiv(program, uniformBlockIndex, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize, long length, long uniformBlockName) {
        long __functionAddress = ARBUniformBufferObject.getInstance().GetActiveUniformBlockName;
        JNI.callIIIPPV(__functionAddress, program, uniformBlockIndex, bufSize, length, uniformBlockName);
    }

    public static void glGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize, ByteBuffer length, ByteBuffer uniformBlockName) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformBlockName, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        ARBUniformBufferObject.nglGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(uniformBlockName));
    }

    public static void glGetActiveUniformBlockName(int program, int uniformBlockIndex, IntBuffer length, ByteBuffer uniformBlockName) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        ARBUniformBufferObject.nglGetActiveUniformBlockName(program, uniformBlockIndex, uniformBlockName.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(uniformBlockName));
    }

    public static String glGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int uniformBlockName = __buffer.bufferParam(bufSize);
        ARBUniformBufferObject.nglGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, __buffer.address(length), __buffer.address(uniformBlockName));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), uniformBlockName);
    }

    public static String glGetActiveUniformBlockName(int program, int uniformBlockIndex) {
        int bufSize = ARBUniformBufferObject.glGetActiveUniformBlocki(program, uniformBlockIndex, 35393);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int uniformBlockName = __buffer.bufferParam(bufSize);
        ARBUniformBufferObject.nglGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, __buffer.address(length), __buffer.address(uniformBlockName));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), uniformBlockName);
    }

    public static void glBindBufferRange(int target, int index, int buffer, long offset, long size) {
        long __functionAddress = ARBUniformBufferObject.getInstance().BindBufferRange;
        JNI.callIIIPPV(__functionAddress, target, index, buffer, offset, size);
    }

    public static void glBindBufferBase(int target, int index, int buffer) {
        long __functionAddress = ARBUniformBufferObject.getInstance().BindBufferBase;
        JNI.callIIIV(__functionAddress, target, index, buffer);
    }

    public static void nglGetIntegeri_v(int target, int index, long data) {
        long __functionAddress = ARBUniformBufferObject.getInstance().GetIntegeri_v;
        JNI.callIIPV(__functionAddress, target, index, data);
    }

    public static void glGetIntegeri_v(int target, int index, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 4);
        }
        ARBUniformBufferObject.nglGetIntegeri_v(target, index, MemoryUtil.memAddress(data));
    }

    public static void glGetIntegeri_v(int target, int index, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        ARBUniformBufferObject.nglGetIntegeri_v(target, index, MemoryUtil.memAddress(data));
    }

    public static int glGetIntegeri(int target, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.intParam();
        ARBUniformBufferObject.nglGetIntegeri_v(target, index, __buffer.address(data));
        return __buffer.intValue(data);
    }

    public static void glUniformBlockBinding(int program, int uniformBlockIndex, int uniformBlockBinding) {
        long __functionAddress = ARBUniformBufferObject.getInstance().UniformBlockBinding;
        JNI.callIIIV(__functionAddress, program, uniformBlockIndex, uniformBlockBinding);
    }
}

