/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBVertexAttrib64Bit {
    public static final int GL_DOUBLE_VEC2 = 36860;
    public static final int GL_DOUBLE_VEC3 = 36861;
    public static final int GL_DOUBLE_VEC4 = 36862;
    public static final int GL_DOUBLE_MAT2 = 36678;
    public static final int GL_DOUBLE_MAT3 = 36679;
    public static final int GL_DOUBLE_MAT4 = 36680;
    public static final int GL_DOUBLE_MAT2x3 = 36681;
    public static final int GL_DOUBLE_MAT2x4 = 36682;
    public static final int GL_DOUBLE_MAT3x2 = 36683;
    public static final int GL_DOUBLE_MAT3x4 = 36684;
    public static final int GL_DOUBLE_MAT4x2 = 36685;
    public static final int GL_DOUBLE_MAT4x3 = 36686;
    public final long VertexAttribL1d;
    public final long VertexAttribL2d;
    public final long VertexAttribL3d;
    public final long VertexAttribL4d;
    public final long VertexAttribL1dv;
    public final long VertexAttribL2dv;
    public final long VertexAttribL3dv;
    public final long VertexAttribL4dv;
    public final long VertexAttribLPointer;
    public final long GetVertexAttribLdv;
    public final long VertexArrayVertexAttribLOffsetEXT;

    protected ARBVertexAttrib64Bit() {
        throw new UnsupportedOperationException();
    }

    public ARBVertexAttrib64Bit(FunctionProvider provider) {
        this.VertexAttribL1d = provider.getFunctionAddress("glVertexAttribL1d");
        this.VertexAttribL2d = provider.getFunctionAddress("glVertexAttribL2d");
        this.VertexAttribL3d = provider.getFunctionAddress("glVertexAttribL3d");
        this.VertexAttribL4d = provider.getFunctionAddress("glVertexAttribL4d");
        this.VertexAttribL1dv = provider.getFunctionAddress("glVertexAttribL1dv");
        this.VertexAttribL2dv = provider.getFunctionAddress("glVertexAttribL2dv");
        this.VertexAttribL3dv = provider.getFunctionAddress("glVertexAttribL3dv");
        this.VertexAttribL4dv = provider.getFunctionAddress("glVertexAttribL4dv");
        this.VertexAttribLPointer = provider.getFunctionAddress("glVertexAttribLPointer");
        this.GetVertexAttribLdv = provider.getFunctionAddress("glGetVertexAttribLdv");
        this.VertexArrayVertexAttribLOffsetEXT = provider.getFunctionAddress("glVertexArrayVertexAttribLOffsetEXT");
    }

    public static ARBVertexAttrib64Bit getInstance() {
        return ARBVertexAttrib64Bit.getInstance(GL.getCapabilities());
    }

    public static ARBVertexAttrib64Bit getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBVertexAttrib64Bit);
    }

    static ARBVertexAttrib64Bit create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_vertex_attrib_64bit")) {
            return null;
        }
        ARBVertexAttrib64Bit funcs = new ARBVertexAttrib64Bit(provider);
        boolean supported = Checks.checkFunctions(funcs.VertexAttribL1d, funcs.VertexAttribL2d, funcs.VertexAttribL3d, funcs.VertexAttribL4d, funcs.VertexAttribL1dv, funcs.VertexAttribL2dv, funcs.VertexAttribL3dv, funcs.VertexAttribL4dv, funcs.VertexAttribLPointer, funcs.GetVertexAttribLdv, ext.contains("GL_EXT_direct_state_access") ? funcs.VertexArrayVertexAttribLOffsetEXT : -1L);
        return GL.checkExtension("GL_ARB_vertex_attrib_64bit", funcs, supported);
    }

    public static void glVertexAttribL1d(int index, double x) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexAttribL1d;
        JNI.callIDV(__functionAddress, index, x);
    }

    public static void glVertexAttribL2d(int index, double x, double y) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexAttribL2d;
        JNI.callIDDV(__functionAddress, index, x, y);
    }

    public static void glVertexAttribL3d(int index, double x, double y, double z) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexAttribL3d;
        JNI.callIDDDV(__functionAddress, index, x, y, z);
    }

    public static void glVertexAttribL4d(int index, double x, double y, double z, double w) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexAttribL4d;
        JNI.callIDDDDV(__functionAddress, index, x, y, z, w);
    }

    public static void nglVertexAttribL1dv(int index, long v) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexAttribL1dv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttribL1dv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 8);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL1dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribL1dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 1);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL1dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttribL2dv(int index, long v) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexAttribL2dv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttribL2dv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL2dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribL2dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 2);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL2dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttribL3dv(int index, long v) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexAttribL3dv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttribL3dv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 24);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL3dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribL3dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL3dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttribL4dv(int index, long v) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexAttribL4dv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttribL4dv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 32);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL4dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribL4dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL4dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttribLPointer(int index, int size, int type, int stride, long pointer) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexAttribLPointer;
        JNI.callIIIIPV(__functionAddress, index, size, type, stride, pointer);
    }

    public static void glVertexAttribLPointer(int index, int size, int type, int stride, ByteBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        ARBVertexAttrib64Bit.nglVertexAttribLPointer(index, size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribLPointer(int index, int size, int type, int stride, long pointerOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, true);
        }
        ARBVertexAttrib64Bit.nglVertexAttribLPointer(index, size, type, stride, pointerOffset);
    }

    public static void glVertexAttribLPointer(int index, int size, int stride, DoubleBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        ARBVertexAttrib64Bit.nglVertexAttribLPointer(index, size, 5130, stride, MemoryUtil.memAddress(pointer));
    }

    public static void nglGetVertexAttribLdv(int index, int pname, long params) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().GetVertexAttribLdv;
        JNI.callIIPV(__functionAddress, index, pname, params);
    }

    public static void glGetVertexAttribLdv(int index, int pname, ByteBuffer params) {
        ARBVertexAttrib64Bit.nglGetVertexAttribLdv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetVertexAttribLdv(int index, int pname, DoubleBuffer params) {
        ARBVertexAttrib64Bit.nglGetVertexAttribLdv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void glVertexArrayVertexAttribLOffsetEXT(int vaobj, int buffer, int index, int size, int type, int stride, long offset) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexArrayVertexAttribLOffsetEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIIIIPV(__functionAddress, vaobj, buffer, index, size, type, stride, offset);
    }
}

