/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class CGL {
    public static final int kCGLPFAAllRenderers = 1;
    public static final int kCGLPFATripleBuffer = 3;
    public static final int kCGLPFADoubleBuffer = 5;
    public static final int kCGLPFAStereo = 6;
    public static final int kCGLPFAColorSize = 8;
    public static final int kCGLPFAAlphaSize = 11;
    public static final int kCGLPFADepthSize = 12;
    public static final int kCGLPFAStencilSize = 13;
    public static final int kCGLPFAMinimumPolicy = 51;
    public static final int kCGLPFAMaximumPolicy = 52;
    public static final int kCGLPFASampleBuffers = 55;
    public static final int kCGLPFASamples = 56;
    public static final int kCGLPFAColorFloat = 58;
    public static final int kCGLPFAMultisample = 59;
    public static final int kCGLPFASupersample = 60;
    public static final int kCGLPFASampleAlpha = 61;
    public static final int kCGLPFARendererID = 70;
    public static final int kCGLPFASingleRenderer = 71;
    public static final int kCGLPFANoRecovery = 72;
    public static final int kCGLPFAAccelerated = 73;
    public static final int kCGLPFAClosestPolicy = 74;
    public static final int kCGLPFABackingStore = 76;
    public static final int kCGLPFABackingVolatile = 77;
    public static final int kCGLPFADisplayMask = 84;
    public static final int kCGLPFAAllowOfflineRenderers = 96;
    public static final int kCGLPFAAcceleratedCompute = 97;
    public static final int kCGLPFAOpenGLProfile = 99;
    public static final int kCGLPFASupportsAutomaticGraphicsSwitching = 101;
    public static final int kCGLPFAVirtualScreenCount = 128;
    public static final int kCGLPFAAuxBuffers = 7;
    public static final int kCGLPFAAccumSize = 14;
    public static final int kCGLPFAOffScreen = 53;
    public static final int kCGLPFAAuxDepthStencil = 57;
    public static final int kCGLPFAWindow = 80;
    public static final int kCGLPFACompliant = 83;
    public static final int kCGLPFAPBuffer = 90;
    public static final int kCGLPFARemotePBuffer = 91;
    public static final int kCGLPFARobust = 75;
    public static final int kCGLPFAMPSafe = 78;
    public static final int kCGLPFAMultiScreen = 81;
    public static final int kCGLPFAFullScreen = 54;
    public static final int kCGLRPOffScreen = 53;
    public static final int kCGLRPRendererID = 70;
    public static final int kCGLRPAccelerated = 73;
    public static final int kCGLRPBackingStore = 76;
    public static final int kCGLRPWindow = 80;
    public static final int kCGLRPCompliant = 83;
    public static final int kCGLRPDisplayMask = 84;
    public static final int kCGLRPBufferModes = 100;
    public static final int kCGLRPColorModes = 103;
    public static final int kCGLRPAccumModes = 104;
    public static final int kCGLRPDepthModes = 105;
    public static final int kCGLRPStencilModes = 106;
    public static final int kCGLRPMaxAuxBuffers = 107;
    public static final int kCGLRPMaxSampleBuffers = 108;
    public static final int kCGLRPMaxSamples = 109;
    public static final int kCGLRPSampleModes = 110;
    public static final int kCGLRPSampleAlpha = 111;
    public static final int kCGLRPVideoMemory = 120;
    public static final int kCGLRPTextureMemory = 121;
    public static final int kCGLRPGPUVertProcCapable = 122;
    public static final int kCGLRPGPUFragProcCapable = 123;
    public static final int kCGLRPRendererCount = 128;
    public static final int kCGLRPOnline = 129;
    public static final int kCGLRPAcceleratedCompute = 130;
    public static final int kCGLRPVideoMemoryMegabytes = 131;
    public static final int kCGLRPTextureMemoryMegabytes = 132;
    public static final int kCGLRPRobust = 75;
    public static final int kCGLRPMPSafe = 78;
    public static final int kCGLRPMultiScreen = 81;
    public static final int kCGLRPFullScreen = 54;
    public static final int kCGLCESwapRectangle = 201;
    public static final int kCGLCESwapLimit = 203;
    public static final int kCGLCERasterization = 221;
    public static final int kCGLCEStateValidation = 301;
    public static final int kCGLCESurfaceBackingSize = 305;
    public static final int kCGLCEDisplayListOptimization = 307;
    public static final int kCGLCEMPEngine = 313;
    public static final int kCGLCPSwapRectangle = 200;
    public static final int kCGLCPSwapInterval = 222;
    public static final int kCGLCPDispatchTableSize = 224;
    public static final int kCGLCPClientStorage = 226;
    public static final int kCGLCPSurfaceTexture = 228;
    public static final int kCGLCPSurfaceOrder = 235;
    public static final int kCGLCPSurfaceOpacity = 236;
    public static final int kCGLCPSurfaceBackingSize = 304;
    public static final int kCGLCPSurfaceSurfaceVolatile = 306;
    public static final int kCGLCPReclaimResources = 308;
    public static final int kCGLCPCurrentRendererID = 309;
    public static final int kCGLCPGPUVertexProcessing = 310;
    public static final int kCGLCPGPUFragmentProcessing = 311;
    public static final int kCGLCPHasDrawable = 314;
    public static final int kCGLCPMPSwapsInFlight = 315;
    public static final int kCGLGOFormatCacheSize = 501;
    public static final int kCGLGOClearFormatCache = 502;
    public static final int kCGLGORetainRenderers = 503;
    public static final int kCGLGOResetLibrary = 504;
    public static final int kCGLGOUseErrorHandler = 505;
    public static final int kCGLGOUseBuildCache = 506;
    public static final int kCGLOGLPVersion_Legacy = 4096;
    public static final int kCGLOGLPVersion_3_2_Core = 12800;
    public static final int kCGLNoError = 0;
    public static final int kCGLBadAttribute = 10000;
    public static final int kCGLBadProperty = 10001;
    public static final int kCGLBadPixelFormat = 10002;
    public static final int kCGLBadRendererInfo = 10003;
    public static final int kCGLBadContext = 10004;
    public static final int kCGLBadDrawable = 10005;
    public static final int kCGLBadDisplay = 10006;
    public static final int kCGLBadState = 10007;
    public static final int kCGLBadValue = 10008;
    public static final int kCGLBadMatch = 10009;
    public static final int kCGLBadEnumeration = 10010;
    public static final int kCGLBadOffScreen = 10011;
    public static final int kCGLBadFullScreen = 10012;
    public static final int kCGLBadWindow = 10013;
    public static final int kCGLBadAddress = 10014;
    public static final int kCGLBadCodeModule = 10015;
    public static final int kCGLBadAlloc = 10016;
    public static final int kCGLBadConnection = 10017;
    public static final int kCGLMonoscopicBit = 1;
    public static final int kCGLStereoscopicBit = 2;
    public static final int kCGLSingleBufferBit = 4;
    public static final int kCGLDoubleBufferBit = 8;
    public static final int kCGLTripleBufferBit = 16;
    public static final int kCGL0Bit = 1;
    public static final int kCGL1Bit = 2;
    public static final int kCGL2Bit = 4;
    public static final int kCGL3Bit = 8;
    public static final int kCGL4Bit = 16;
    public static final int kCGL5Bit = 32;
    public static final int kCGL6Bit = 64;
    public static final int kCGL8Bit = 128;
    public static final int kCGL10Bit = 256;
    public static final int kCGL12Bit = 512;
    public static final int kCGL16Bit = 1024;
    public static final int kCGL24Bit = 2048;
    public static final int kCGL32Bit = 4096;
    public static final int kCGL48Bit = 8192;
    public static final int kCGL64Bit = 16384;
    public static final int kCGL96Bit = 32768;
    public static final int kCGL128Bit = 65536;
    public static final int kCGLRGB444Bit = 64;
    public static final int kCGLARGB4444Bit = 128;
    public static final int kCGLRGB444A8Bit = 256;
    public static final int kCGLRGB555Bit = 512;
    public static final int kCGLARGB1555Bit = 1024;
    public static final int kCGLRGB555A8Bit = 2048;
    public static final int kCGLRGB565Bit = 4096;
    public static final int kCGLRGB565A8Bit = 8192;
    public static final int kCGLRGB888Bit = 16384;
    public static final int kCGLARGB8888Bit = 32768;
    public static final int kCGLRGB888A8Bit = 65536;
    public static final int kCGLRGB101010Bit = 131072;
    public static final int kCGLARGB2101010Bit = 262144;
    public static final int kCGLRGB101010_A8Bit = 524288;
    public static final int kCGLRGB121212Bit = 0x100000;
    public static final int kCGLARGB12121212Bit = 0x200000;
    public static final int kCGLRGB161616Bit = 0x400000;
    public static final int kCGLRGBA16161616Bit = 0x800000;
    public static final int kCGLRGBFloat64Bit = 0x1000000;
    public static final int kCGLRGBAFloat64Bit = 0x2000000;
    public static final int kCGLRGBFloat128Bit = 0x4000000;
    public static final int kCGLRGBAFloat128Bit = 0x8000000;
    public static final int kCGLRGBFloat256Bit = 0x10000000;
    public static final int kCGLRGBAFloat256Bit = 0x20000000;
    public static final int kCGLSupersampleBit = 1;
    public static final int kCGLMultisampleBit = 2;
    public final long GetCurrentContext;
    public final long SetCurrentContext;
    public final long GetShareGroup;
    public final long ChoosePixelFormat;
    public final long DestroyPixelFormat;
    public final long DescribePixelFormat;
    public final long ReleasePixelFormat;
    public final long RetainPixelFormat;
    public final long GetPixelFormatRetainCount;
    public final long QueryRendererInfo;
    public final long DestroyRendererInfo;
    public final long DescribeRenderer;
    public final long CreateContext;
    public final long DestroyContext;
    public final long CopyContext;
    public final long RetainContext;
    public final long ReleaseContext;
    public final long GetContextRetainCount;
    public final long GetPixelFormat;
    public final long CreatePBuffer;
    public final long DestroyPBuffer;
    public final long DescribePBuffer;
    public final long TexImagePBuffer;
    public final long RetainPBuffer;
    public final long ReleasePBuffer;
    public final long GetPBufferRetainCount;
    public final long SetOffScreen;
    public final long GetOffScreen;
    public final long SetFullScreen;
    public final long SetFullScreenOnDisplay;
    public final long SetPBuffer;
    public final long GetPBuffer;
    public final long ClearDrawable;
    public final long FlushDrawable;
    public final long Enable;
    public final long Disable;
    public final long IsEnabled;
    public final long SetParameter;
    public final long GetParameter;
    public final long SetVirtualScreen;
    public final long GetVirtualScreen;
    public final long UpdateContext;
    public final long SetGlobalOption;
    public final long GetGlobalOption;
    public final long LockContext;
    public final long UnlockContext;
    public final long GetVersion;
    public final long ErrorString;

    protected CGL() {
        throw new UnsupportedOperationException();
    }

    public CGL(FunctionProvider provider) {
        this.GetCurrentContext = provider.getFunctionAddress("CGLGetCurrentContext");
        this.SetCurrentContext = provider.getFunctionAddress("CGLSetCurrentContext");
        this.GetShareGroup = provider.getFunctionAddress("CGLGetShareGroup");
        this.ChoosePixelFormat = provider.getFunctionAddress("CGLChoosePixelFormat");
        this.DestroyPixelFormat = provider.getFunctionAddress("CGLDestroyPixelFormat");
        this.DescribePixelFormat = provider.getFunctionAddress("CGLDescribePixelFormat");
        this.ReleasePixelFormat = provider.getFunctionAddress("CGLReleasePixelFormat");
        this.RetainPixelFormat = provider.getFunctionAddress("CGLRetainPixelFormat");
        this.GetPixelFormatRetainCount = provider.getFunctionAddress("CGLGetPixelFormatRetainCount");
        this.QueryRendererInfo = provider.getFunctionAddress("CGLQueryRendererInfo");
        this.DestroyRendererInfo = provider.getFunctionAddress("CGLDestroyRendererInfo");
        this.DescribeRenderer = provider.getFunctionAddress("CGLDescribeRenderer");
        this.CreateContext = provider.getFunctionAddress("CGLCreateContext");
        this.DestroyContext = provider.getFunctionAddress("CGLDestroyContext");
        this.CopyContext = provider.getFunctionAddress("CGLCopyContext");
        this.RetainContext = provider.getFunctionAddress("CGLRetainContext");
        this.ReleaseContext = provider.getFunctionAddress("CGLReleaseContext");
        this.GetContextRetainCount = provider.getFunctionAddress("CGLGetContextRetainCount");
        this.GetPixelFormat = provider.getFunctionAddress("CGLGetPixelFormat");
        this.CreatePBuffer = provider.getFunctionAddress("CGLCreatePBuffer");
        this.DestroyPBuffer = provider.getFunctionAddress("CGLDestroyPBuffer");
        this.DescribePBuffer = provider.getFunctionAddress("CGLDescribePBuffer");
        this.TexImagePBuffer = provider.getFunctionAddress("CGLTexImagePBuffer");
        this.RetainPBuffer = provider.getFunctionAddress("CGLRetainPBuffer");
        this.ReleasePBuffer = provider.getFunctionAddress("CGLReleasePBuffer");
        this.GetPBufferRetainCount = provider.getFunctionAddress("CGLGetPBufferRetainCount");
        this.SetOffScreen = provider.getFunctionAddress("CGLSetOffScreen");
        this.GetOffScreen = provider.getFunctionAddress("CGLGetOffScreen");
        this.SetFullScreen = provider.getFunctionAddress("CGLSetFullScreen");
        this.SetFullScreenOnDisplay = provider.getFunctionAddress("CGLSetFullScreenOnDisplay");
        this.SetPBuffer = provider.getFunctionAddress("CGLSetPBuffer");
        this.GetPBuffer = provider.getFunctionAddress("CGLGetPBuffer");
        this.ClearDrawable = provider.getFunctionAddress("CGLClearDrawable");
        this.FlushDrawable = provider.getFunctionAddress("CGLFlushDrawable");
        this.Enable = provider.getFunctionAddress("CGLEnable");
        this.Disable = provider.getFunctionAddress("CGLDisable");
        this.IsEnabled = provider.getFunctionAddress("CGLIsEnabled");
        this.SetParameter = provider.getFunctionAddress("CGLSetParameter");
        this.GetParameter = provider.getFunctionAddress("CGLGetParameter");
        this.SetVirtualScreen = provider.getFunctionAddress("CGLSetVirtualScreen");
        this.GetVirtualScreen = provider.getFunctionAddress("CGLGetVirtualScreen");
        this.UpdateContext = provider.getFunctionAddress("CGLUpdateContext");
        this.SetGlobalOption = provider.getFunctionAddress("CGLSetGlobalOption");
        this.GetGlobalOption = provider.getFunctionAddress("CGLGetGlobalOption");
        this.LockContext = provider.getFunctionAddress("CGLLockContext");
        this.UnlockContext = provider.getFunctionAddress("CGLUnlockContext");
        this.GetVersion = provider.getFunctionAddress("CGLGetVersion");
        this.ErrorString = provider.getFunctionAddress("CGLErrorString");
    }

    public static CGL getInstance() {
        return CGL.getInstance(GL.getCapabilities());
    }

    public static CGL getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__CGL);
    }

    static CGL create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("CGL")) {
            return null;
        }
        CGL funcs = new CGL(provider);
        boolean supported = Checks.checkFunctions(funcs.GetCurrentContext, funcs.SetCurrentContext, funcs.GetShareGroup, funcs.ChoosePixelFormat, funcs.DestroyPixelFormat, funcs.DescribePixelFormat, funcs.ReleasePixelFormat, funcs.RetainPixelFormat, funcs.GetPixelFormatRetainCount, funcs.QueryRendererInfo, funcs.DestroyRendererInfo, funcs.DescribeRenderer, funcs.CreateContext, funcs.DestroyContext, funcs.CopyContext, funcs.RetainContext, funcs.ReleaseContext, funcs.GetContextRetainCount, funcs.GetPixelFormat, funcs.CreatePBuffer, funcs.DestroyPBuffer, funcs.DescribePBuffer, funcs.TexImagePBuffer, funcs.RetainPBuffer, funcs.ReleasePBuffer, funcs.GetPBufferRetainCount, funcs.SetOffScreen, funcs.GetOffScreen, funcs.SetFullScreen, funcs.SetFullScreenOnDisplay, funcs.SetPBuffer, funcs.GetPBuffer, funcs.ClearDrawable, funcs.FlushDrawable, funcs.Enable, funcs.Disable, funcs.IsEnabled, funcs.SetParameter, funcs.GetParameter, funcs.SetVirtualScreen, funcs.GetVirtualScreen, funcs.UpdateContext, funcs.SetGlobalOption, funcs.GetGlobalOption, funcs.LockContext, funcs.UnlockContext, funcs.GetVersion, funcs.ErrorString);
        return GL.checkExtension("CGL", funcs, supported);
    }

    public static long CGLGetCurrentContext() {
        long __functionAddress = CGL.getInstance().GetCurrentContext;
        return JNI.callP(__functionAddress);
    }

    public static int CGLSetCurrentContext(long context) {
        long __functionAddress = CGL.getInstance().SetCurrentContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(context);
        }
        return JNI.callPI(__functionAddress, context);
    }

    public static long CGLGetShareGroup(long ctx) {
        long __functionAddress = CGL.getInstance().GetShareGroup;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPP(__functionAddress, ctx);
    }

    public static int nCGLChoosePixelFormat(long attribs, long pix, long npix) {
        long __functionAddress = CGL.getInstance().ChoosePixelFormat;
        return JNI.callPPPI(__functionAddress, attribs, pix, npix);
    }

    public static int CGLChoosePixelFormat(ByteBuffer attribs, ByteBuffer pix, ByteBuffer npix) {
        if (Checks.CHECKS) {
            if (pix != null) {
                Checks.checkBuffer((Buffer)pix, 1 << Pointer.POINTER_SHIFT);
            }
            Checks.checkBuffer((Buffer)npix, 4);
        }
        return CGL.nCGLChoosePixelFormat(MemoryUtil.memAddress(attribs), MemoryUtil.memAddressSafe(pix), MemoryUtil.memAddress(npix));
    }

    public static int CGLChoosePixelFormat(IntBuffer attribs, PointerBuffer pix, IntBuffer npix) {
        if (Checks.CHECKS) {
            if (pix != null) {
                Checks.checkBuffer(pix, 1);
            }
            Checks.checkBuffer((Buffer)npix, 1);
        }
        return CGL.nCGLChoosePixelFormat(MemoryUtil.memAddress(attribs), MemoryUtil.memAddressSafe(pix), MemoryUtil.memAddress(npix));
    }

    public static int CGLDestroyPixelFormat(long pix) {
        long __functionAddress = CGL.getInstance().DestroyPixelFormat;
        if (Checks.CHECKS) {
            Checks.checkPointer(pix);
        }
        return JNI.callPI(__functionAddress, pix);
    }

    public static int nCGLDescribePixelFormat(long pix, int pix_num, int attrib, long value) {
        long __functionAddress = CGL.getInstance().DescribePixelFormat;
        if (Checks.CHECKS) {
            Checks.checkPointer(pix);
        }
        return JNI.callPIIPI(__functionAddress, pix, pix_num, attrib, value);
    }

    public static int CGLDescribePixelFormat(long pix, int pix_num, int attrib, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        return CGL.nCGLDescribePixelFormat(pix, pix_num, attrib, MemoryUtil.memAddress(value));
    }

    public static int CGLDescribePixelFormat(long pix, int pix_num, int attrib, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return CGL.nCGLDescribePixelFormat(pix, pix_num, attrib, MemoryUtil.memAddress(value));
    }

    public static void CGLReleasePixelFormat(long pix) {
        long __functionAddress = CGL.getInstance().ReleasePixelFormat;
        if (Checks.CHECKS) {
            Checks.checkPointer(pix);
        }
        JNI.callPV(__functionAddress, pix);
    }

    public static long CGLRetainPixelFormat(long pix) {
        long __functionAddress = CGL.getInstance().RetainPixelFormat;
        if (Checks.CHECKS) {
            Checks.checkPointer(pix);
        }
        return JNI.callPP(__functionAddress, pix);
    }

    public static int CGLGetPixelFormatRetainCount(long pix) {
        long __functionAddress = CGL.getInstance().GetPixelFormatRetainCount;
        if (Checks.CHECKS) {
            Checks.checkPointer(pix);
        }
        return JNI.callPI(__functionAddress, pix);
    }

    public static int nCGLQueryRendererInfo(int display_mask, long rend, long nrend) {
        long __functionAddress = CGL.getInstance().QueryRendererInfo;
        return JNI.callIPPI(__functionAddress, display_mask, rend, nrend);
    }

    public static int CGLQueryRendererInfo(int display_mask, ByteBuffer rend, ByteBuffer nrend) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)rend, 1 << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)nrend, 4);
        }
        return CGL.nCGLQueryRendererInfo(display_mask, MemoryUtil.memAddress(rend), MemoryUtil.memAddress(nrend));
    }

    public static int CGLQueryRendererInfo(int display_mask, PointerBuffer rend, IntBuffer nrend) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(rend, 1);
            Checks.checkBuffer((Buffer)nrend, 1);
        }
        return CGL.nCGLQueryRendererInfo(display_mask, MemoryUtil.memAddress(rend), MemoryUtil.memAddress(nrend));
    }

    public static int CGLDestroyRendererInfo(long rend) {
        long __functionAddress = CGL.getInstance().DestroyRendererInfo;
        if (Checks.CHECKS) {
            Checks.checkPointer(rend);
        }
        return JNI.callPI(__functionAddress, rend);
    }

    public static int nCGLDescribeRenderer(long rend, int rend_num, int prop, long value) {
        long __functionAddress = CGL.getInstance().DescribeRenderer;
        if (Checks.CHECKS) {
            Checks.checkPointer(rend);
        }
        return JNI.callPIIPI(__functionAddress, rend, rend_num, prop, value);
    }

    public static int CGLDescribeRenderer(long rend, int rend_num, int prop, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        return CGL.nCGLDescribeRenderer(rend, rend_num, prop, MemoryUtil.memAddress(value));
    }

    public static int CGLDescribeRenderer(long rend, int rend_num, int prop, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return CGL.nCGLDescribeRenderer(rend, rend_num, prop, MemoryUtil.memAddress(value));
    }

    public static int nCGLCreateContext(long pix, long share, long ctx) {
        long __functionAddress = CGL.getInstance().CreateContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(pix);
            Checks.checkPointer(share);
        }
        return JNI.callPPPI(__functionAddress, pix, share, ctx);
    }

    public static int CGLCreateContext(long pix, long share, ByteBuffer ctx) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)ctx, 1 << Pointer.POINTER_SHIFT);
        }
        return CGL.nCGLCreateContext(pix, share, MemoryUtil.memAddress(ctx));
    }

    public static int CGLCreateContext(long pix, long share, PointerBuffer ctx) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(ctx, 1);
        }
        return CGL.nCGLCreateContext(pix, share, MemoryUtil.memAddress(ctx));
    }

    public static int CGLDestroyContext(long ctx) {
        long __functionAddress = CGL.getInstance().DestroyContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPI(__functionAddress, ctx);
    }

    public static int CGLCopyContext(long src, long dst, int mask) {
        long __functionAddress = CGL.getInstance().CopyContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(src);
            Checks.checkPointer(dst);
        }
        return JNI.callPPII(__functionAddress, src, dst, mask);
    }

    public static long CGLRetainContext(long ctx) {
        long __functionAddress = CGL.getInstance().RetainContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPP(__functionAddress, ctx);
    }

    public static void CGLReleaseContext(long ctx) {
        long __functionAddress = CGL.getInstance().ReleaseContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        JNI.callPV(__functionAddress, ctx);
    }

    public static int CGLGetContextRetainCount(long ctx) {
        long __functionAddress = CGL.getInstance().GetContextRetainCount;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPI(__functionAddress, ctx);
    }

    public static long CGLGetPixelFormat(long ctx) {
        long __functionAddress = CGL.getInstance().GetPixelFormat;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPP(__functionAddress, ctx);
    }

    public static int nCGLCreatePBuffer(int width, int height, int target, int internalFormat, int max_level, long pbuffer) {
        long __functionAddress = CGL.getInstance().CreatePBuffer;
        return JNI.callIIIIIPI(__functionAddress, width, height, target, internalFormat, max_level, pbuffer);
    }

    public static int CGLCreatePBuffer(int width, int height, int target, int internalFormat, int max_level, ByteBuffer pbuffer) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pbuffer, 1 << Pointer.POINTER_SHIFT);
        }
        return CGL.nCGLCreatePBuffer(width, height, target, internalFormat, max_level, MemoryUtil.memAddress(pbuffer));
    }

    public static int CGLCreatePBuffer(int width, int height, int target, int internalFormat, int max_level, PointerBuffer pbuffer) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(pbuffer, 1);
        }
        return CGL.nCGLCreatePBuffer(width, height, target, internalFormat, max_level, MemoryUtil.memAddress(pbuffer));
    }

    public static int CGLDestroyPBuffer(long pbuffer) {
        long __functionAddress = CGL.getInstance().DestroyPBuffer;
        if (Checks.CHECKS) {
            Checks.checkPointer(pbuffer);
        }
        return JNI.callPI(__functionAddress, pbuffer);
    }

    public static int nCGLDescribePBuffer(long obj, long width, long height, long target, long internalFormat, long mipmap) {
        long __functionAddress = CGL.getInstance().DescribePBuffer;
        if (Checks.CHECKS) {
            Checks.checkPointer(obj);
        }
        return JNI.callPPPPPPI(__functionAddress, obj, width, height, target, internalFormat, mipmap);
    }

    public static int CGLDescribePBuffer(long obj, ByteBuffer width, ByteBuffer height, ByteBuffer target, ByteBuffer internalFormat, ByteBuffer mipmap) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)width, 4);
            Checks.checkBuffer((Buffer)height, 4);
            Checks.checkBuffer((Buffer)target, 4);
            Checks.checkBuffer((Buffer)internalFormat, 4);
            Checks.checkBuffer((Buffer)mipmap, 4);
        }
        return CGL.nCGLDescribePBuffer(obj, MemoryUtil.memAddress(width), MemoryUtil.memAddress(height), MemoryUtil.memAddress(target), MemoryUtil.memAddress(internalFormat), MemoryUtil.memAddress(mipmap));
    }

    public static int CGLDescribePBuffer(long obj, IntBuffer width, IntBuffer height, IntBuffer target, IntBuffer internalFormat, IntBuffer mipmap) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)width, 1);
            Checks.checkBuffer((Buffer)height, 1);
            Checks.checkBuffer((Buffer)target, 1);
            Checks.checkBuffer((Buffer)internalFormat, 1);
            Checks.checkBuffer((Buffer)mipmap, 1);
        }
        return CGL.nCGLDescribePBuffer(obj, MemoryUtil.memAddress(width), MemoryUtil.memAddress(height), MemoryUtil.memAddress(target), MemoryUtil.memAddress(internalFormat), MemoryUtil.memAddress(mipmap));
    }

    public static int CGLTexImagePBuffer(long ctx, long pbuffer, int source) {
        long __functionAddress = CGL.getInstance().TexImagePBuffer;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
            Checks.checkPointer(pbuffer);
        }
        return JNI.callPPII(__functionAddress, ctx, pbuffer, source);
    }

    public static long CGLRetainPBuffer(long pbuffer) {
        long __functionAddress = CGL.getInstance().RetainPBuffer;
        if (Checks.CHECKS) {
            Checks.checkPointer(pbuffer);
        }
        return JNI.callPP(__functionAddress, pbuffer);
    }

    public static void CGLReleasePBuffer(long pbuffer) {
        long __functionAddress = CGL.getInstance().ReleasePBuffer;
        if (Checks.CHECKS) {
            Checks.checkPointer(pbuffer);
        }
        JNI.callPV(__functionAddress, pbuffer);
    }

    public static int CGLGetPBufferRetainCount(long pbuffer) {
        long __functionAddress = CGL.getInstance().GetPBufferRetainCount;
        if (Checks.CHECKS) {
            Checks.checkPointer(pbuffer);
        }
        return JNI.callPI(__functionAddress, pbuffer);
    }

    public static int nCGLSetOffScreen(long ctx, int width, int height, int rowbytes, long baseaddr) {
        long __functionAddress = CGL.getInstance().SetOffScreen;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPIIIPI(__functionAddress, ctx, width, height, rowbytes, baseaddr);
    }

    public static int CGLSetOffScreen(long ctx, int width, int height, int rowbytes, ByteBuffer baseaddr) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)baseaddr, rowbytes * height);
        }
        return CGL.nCGLSetOffScreen(ctx, width, height, rowbytes, MemoryUtil.memAddress(baseaddr));
    }

    public static int nCGLGetOffScreen(long ctx, long width, long height, long rowbytes, long baseaddr) {
        long __functionAddress = CGL.getInstance().GetOffScreen;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPPPPPI(__functionAddress, ctx, width, height, rowbytes, baseaddr);
    }

    public static int CGLGetOffScreen(long ctx, ByteBuffer width, ByteBuffer height, ByteBuffer rowbytes, ByteBuffer baseaddr) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)width, 4);
            Checks.checkBuffer((Buffer)height, 4);
            Checks.checkBuffer((Buffer)rowbytes, 4);
            Checks.checkBuffer((Buffer)baseaddr, 1 << Pointer.POINTER_SHIFT);
        }
        return CGL.nCGLGetOffScreen(ctx, MemoryUtil.memAddress(width), MemoryUtil.memAddress(height), MemoryUtil.memAddress(rowbytes), MemoryUtil.memAddress(baseaddr));
    }

    public static int CGLGetOffScreen(long ctx, IntBuffer width, IntBuffer height, IntBuffer rowbytes, PointerBuffer baseaddr) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)width, 1);
            Checks.checkBuffer((Buffer)height, 1);
            Checks.checkBuffer((Buffer)rowbytes, 1);
            Checks.checkBuffer(baseaddr, 1);
        }
        return CGL.nCGLGetOffScreen(ctx, MemoryUtil.memAddress(width), MemoryUtil.memAddress(height), MemoryUtil.memAddress(rowbytes), MemoryUtil.memAddress(baseaddr));
    }

    public static int CGLSetFullScreen(long ctx) {
        long __functionAddress = CGL.getInstance().SetFullScreen;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPI(__functionAddress, ctx);
    }

    public static int CGLSetFullScreenOnDisplay(long ctx, int display_mask) {
        long __functionAddress = CGL.getInstance().SetFullScreenOnDisplay;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPII(__functionAddress, ctx, display_mask);
    }

    public static int CGLSetPBuffer(long ctx, long pbuffer, int face, int level, int screen) {
        long __functionAddress = CGL.getInstance().SetPBuffer;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
            Checks.checkPointer(pbuffer);
        }
        return JNI.callPPIIII(__functionAddress, ctx, pbuffer, face, level, screen);
    }

    public static int nCGLGetPBuffer(long ctx, long pbuffer, long face, long level, long screen) {
        long __functionAddress = CGL.getInstance().GetPBuffer;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPPPPPI(__functionAddress, ctx, pbuffer, face, level, screen);
    }

    public static int CGLGetPBuffer(long ctx, ByteBuffer pbuffer, ByteBuffer face, ByteBuffer level, ByteBuffer screen) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pbuffer, 1 << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)face, 4);
            Checks.checkBuffer((Buffer)level, 4);
            Checks.checkBuffer((Buffer)screen, 4);
        }
        return CGL.nCGLGetPBuffer(ctx, MemoryUtil.memAddress(pbuffer), MemoryUtil.memAddress(face), MemoryUtil.memAddress(level), MemoryUtil.memAddress(screen));
    }

    public static int CGLGetPBuffer(long ctx, PointerBuffer pbuffer, IntBuffer face, IntBuffer level, IntBuffer screen) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(pbuffer, 1);
            Checks.checkBuffer((Buffer)face, 1);
            Checks.checkBuffer((Buffer)level, 1);
            Checks.checkBuffer((Buffer)screen, 1);
        }
        return CGL.nCGLGetPBuffer(ctx, MemoryUtil.memAddress(pbuffer), MemoryUtil.memAddress(face), MemoryUtil.memAddress(level), MemoryUtil.memAddress(screen));
    }

    public static int CGLClearDrawable(long ctx) {
        long __functionAddress = CGL.getInstance().ClearDrawable;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPI(__functionAddress, ctx);
    }

    public static int CGLFlushDrawable(long ctx) {
        long __functionAddress = CGL.getInstance().FlushDrawable;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPI(__functionAddress, ctx);
    }

    public static int CGLEnable(long ctx, int pname) {
        long __functionAddress = CGL.getInstance().Enable;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPII(__functionAddress, ctx, pname);
    }

    public static int CGLDisable(long ctx, int pname) {
        long __functionAddress = CGL.getInstance().Disable;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPII(__functionAddress, ctx, pname);
    }

    public static int nCGLIsEnabled(long ctx, int pname, long enable) {
        long __functionAddress = CGL.getInstance().IsEnabled;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPIPI(__functionAddress, ctx, pname, enable);
    }

    public static int CGLIsEnabled(long ctx, int pname, ByteBuffer enable) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)enable, 4);
        }
        return CGL.nCGLIsEnabled(ctx, pname, MemoryUtil.memAddress(enable));
    }

    public static int CGLIsEnabled(long ctx, int pname, IntBuffer enable) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)enable, 1);
        }
        return CGL.nCGLIsEnabled(ctx, pname, MemoryUtil.memAddress(enable));
    }

    public static int nCGLSetParameter(long ctx, int pname, long params) {
        long __functionAddress = CGL.getInstance().SetParameter;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPIPI(__functionAddress, ctx, pname, params);
    }

    public static int CGLSetParameter(long ctx, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        return CGL.nCGLSetParameter(ctx, pname, MemoryUtil.memAddress(params));
    }

    public static int CGLSetParameter(long ctx, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        return CGL.nCGLSetParameter(ctx, pname, MemoryUtil.memAddress(params));
    }

    public static int CGLSetParameter(long ctx, int pname, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam(param);
        return CGL.nCGLSetParameter(ctx, pname, __buffer.address(params));
    }

    public static int nCGLGetParameter(long ctx, int pname, long params) {
        long __functionAddress = CGL.getInstance().GetParameter;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPIPI(__functionAddress, ctx, pname, params);
    }

    public static int CGLGetParameter(long ctx, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        return CGL.nCGLGetParameter(ctx, pname, MemoryUtil.memAddress(params));
    }

    public static int CGLGetParameter(long ctx, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        return CGL.nCGLGetParameter(ctx, pname, MemoryUtil.memAddress(params));
    }

    public static int CGLSetVirtualScreen(long ctx, int screen) {
        long __functionAddress = CGL.getInstance().SetVirtualScreen;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPII(__functionAddress, ctx, screen);
    }

    public static int nCGLGetVirtualScreen(long ctx, long screen) {
        long __functionAddress = CGL.getInstance().GetVirtualScreen;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPPI(__functionAddress, ctx, screen);
    }

    public static int CGLGetVirtualScreen(long ctx, ByteBuffer screen) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)screen, 4);
        }
        return CGL.nCGLGetVirtualScreen(ctx, MemoryUtil.memAddress(screen));
    }

    public static int CGLGetVirtualScreen(long ctx, IntBuffer screen) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)screen, 1);
        }
        return CGL.nCGLGetVirtualScreen(ctx, MemoryUtil.memAddress(screen));
    }

    public static int CGLUpdateContext(long ctx) {
        long __functionAddress = CGL.getInstance().UpdateContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(ctx);
        }
        return JNI.callPI(__functionAddress, ctx);
    }

    public static int nCGLSetGlobalOption(int pname, long params) {
        long __functionAddress = CGL.getInstance().SetGlobalOption;
        return JNI.callIPI(__functionAddress, pname, params);
    }

    public static int CGLSetGlobalOption(int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        return CGL.nCGLSetGlobalOption(pname, MemoryUtil.memAddress(params));
    }

    public static int CGLSetGlobalOption(int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        return CGL.nCGLSetGlobalOption(pname, MemoryUtil.memAddress(params));
    }

    public static int CGLSetGlobalOption(int pname, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam(param);
        return CGL.nCGLSetGlobalOption(pname, __buffer.address(params));
    }

    public static int nCGLGetGlobalOption(int pname, long params) {
        long __functionAddress = CGL.getInstance().GetGlobalOption;
        return JNI.callIPI(__functionAddress, pname, params);
    }

    public static int CGLGetGlobalOption(int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        return CGL.nCGLGetGlobalOption(pname, MemoryUtil.memAddress(params));
    }

    public static int CGLGetGlobalOption(int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        return CGL.nCGLGetGlobalOption(pname, MemoryUtil.memAddress(params));
    }

    public static int CGLLockContext(long context) {
        long __functionAddress = CGL.getInstance().LockContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(context);
        }
        return JNI.callPI(__functionAddress, context);
    }

    public static int CGLUnlockContext(long context) {
        long __functionAddress = CGL.getInstance().UnlockContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(context);
        }
        return JNI.callPI(__functionAddress, context);
    }

    public static void nCGLGetVersion(long majorvers, long minorvers) {
        long __functionAddress = CGL.getInstance().GetVersion;
        JNI.callPPV(__functionAddress, majorvers, minorvers);
    }

    public static void CGLGetVersion(ByteBuffer majorvers, ByteBuffer minorvers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)majorvers, 4);
            Checks.checkBuffer((Buffer)minorvers, 4);
        }
        CGL.nCGLGetVersion(MemoryUtil.memAddress(majorvers), MemoryUtil.memAddress(minorvers));
    }

    public static void CGLGetVersion(IntBuffer majorvers, IntBuffer minorvers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)majorvers, 1);
            Checks.checkBuffer((Buffer)minorvers, 1);
        }
        CGL.nCGLGetVersion(MemoryUtil.memAddress(majorvers), MemoryUtil.memAddress(minorvers));
    }

    public static long nCGLErrorString(int error) {
        long __functionAddress = CGL.getInstance().ErrorString;
        return JNI.callIP(__functionAddress, error);
    }

    public static String CGLErrorString(int error) {
        long __result = CGL.nCGLErrorString(error);
        return MemoryUtil.memDecodeASCII(__result);
    }
}

