/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTDebugLabel {
    public static final int GL_BUFFER_OBJECT_EXT = 37201;
    public static final int GL_SHADER_OBJECT_EXT = 35656;
    public static final int GL_PROGRAM_OBJECT_EXT = 35648;
    public static final int GL_VERTEX_ARRAY_OBJECT_EXT = 37204;
    public static final int GL_QUERY_OBJECT_EXT = 37203;
    public static final int GL_PROGRAM_PIPELINE_OBJECT_EXT = 35407;
    public final long LabelObjectEXT;
    public final long GetObjectLabelEXT;

    protected EXTDebugLabel() {
        throw new UnsupportedOperationException();
    }

    public EXTDebugLabel(FunctionProvider provider) {
        this.LabelObjectEXT = provider.getFunctionAddress("glLabelObjectEXT");
        this.GetObjectLabelEXT = provider.getFunctionAddress("glGetObjectLabelEXT");
    }

    public static EXTDebugLabel getInstance() {
        return EXTDebugLabel.getInstance(GL.getCapabilities());
    }

    public static EXTDebugLabel getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTDebugLabel);
    }

    static EXTDebugLabel create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_debug_label")) {
            return null;
        }
        EXTDebugLabel funcs = new EXTDebugLabel(provider);
        boolean supported = Checks.checkFunctions(funcs.LabelObjectEXT, funcs.GetObjectLabelEXT);
        return GL.checkExtension("GL_EXT_debug_label", funcs, supported);
    }

    public static void nglLabelObjectEXT(int type, int object, int length, long label) {
        long __functionAddress = EXTDebugLabel.getInstance().LabelObjectEXT;
        JNI.callIIIPV(__functionAddress, type, object, length, label);
    }

    public static void glLabelObjectEXT(int type, int object, int length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)label, length);
        }
        EXTDebugLabel.nglLabelObjectEXT(type, object, length, MemoryUtil.memAddress(label));
    }

    public static void glLabelObjectEXT(int type, int object, ByteBuffer label) {
        EXTDebugLabel.nglLabelObjectEXT(type, object, label.remaining(), MemoryUtil.memAddress(label));
    }

    public static void glLabelObjectEXT(int type, int object, CharSequence label) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int labelEncoded = __buffer.stringParamUTF8(label, false);
        int labelEncodedLen = __buffer.getOffset() - labelEncoded;
        EXTDebugLabel.nglLabelObjectEXT(type, object, labelEncodedLen, __buffer.address(labelEncoded));
    }

    public static void nglGetObjectLabelEXT(int type, int object, int bufSize, long length, long label) {
        long __functionAddress = EXTDebugLabel.getInstance().GetObjectLabelEXT;
        JNI.callIIIPPV(__functionAddress, type, object, bufSize, length, label);
    }

    public static void glGetObjectLabelEXT(int type, int object, int bufSize, ByteBuffer length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)label, bufSize);
            Checks.checkBuffer((Buffer)length, 4);
        }
        EXTDebugLabel.nglGetObjectLabelEXT(type, object, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(label));
    }

    public static void glGetObjectLabelEXT(int type, int object, IntBuffer length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        EXTDebugLabel.nglGetObjectLabelEXT(type, object, label.remaining(), MemoryUtil.memAddress(length), MemoryUtil.memAddress(label));
    }

    public static String glGetObjectLabelEXT(int type, int object, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int label = __buffer.bufferParam(bufSize);
        EXTDebugLabel.nglGetObjectLabelEXT(type, object, bufSize, __buffer.address(length), __buffer.address(label));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), label);
    }
}

