/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class GL14 {
    public static final int GL_GENERATE_MIPMAP = 33169;
    public static final int GL_GENERATE_MIPMAP_HINT = 33170;
    public static final int GL_CONSTANT_COLOR = 32769;
    public static final int GL_ONE_MINUS_CONSTANT_COLOR = 32770;
    public static final int GL_CONSTANT_ALPHA = 32771;
    public static final int GL_ONE_MINUS_CONSTANT_ALPHA = 32772;
    public static final int GL_FUNC_ADD = 32774;
    public static final int GL_MIN = 32775;
    public static final int GL_MAX = 32776;
    public static final int GL_FUNC_SUBTRACT = 32778;
    public static final int GL_FUNC_REVERSE_SUBTRACT = 32779;
    public static final int GL_DEPTH_COMPONENT16 = 33189;
    public static final int GL_DEPTH_COMPONENT24 = 33190;
    public static final int GL_DEPTH_COMPONENT32 = 33191;
    public static final int GL_TEXTURE_DEPTH_SIZE = 34890;
    public static final int GL_DEPTH_TEXTURE_MODE = 34891;
    public static final int GL_TEXTURE_COMPARE_MODE = 34892;
    public static final int GL_TEXTURE_COMPARE_FUNC = 34893;
    public static final int GL_COMPARE_R_TO_TEXTURE = 34894;
    public static final int GL_FOG_COORDINATE_SOURCE = 33872;
    public static final int GL_FOG_COORDINATE = 33873;
    public static final int GL_FRAGMENT_DEPTH = 33874;
    public static final int GL_CURRENT_FOG_COORDINATE = 33875;
    public static final int GL_FOG_COORDINATE_ARRAY_TYPE = 33876;
    public static final int GL_FOG_COORDINATE_ARRAY_STRIDE = 33877;
    public static final int GL_FOG_COORDINATE_ARRAY_POINTER = 33878;
    public static final int GL_FOG_COORDINATE_ARRAY = 33879;
    public static final int GL_POINT_SIZE_MIN = 33062;
    public static final int GL_POINT_SIZE_MAX = 33063;
    public static final int GL_POINT_FADE_THRESHOLD_SIZE = 33064;
    public static final int GL_POINT_DISTANCE_ATTENUATION = 33065;
    public static final int GL_COLOR_SUM = 33880;
    public static final int GL_CURRENT_SECONDARY_COLOR = 33881;
    public static final int GL_SECONDARY_COLOR_ARRAY_SIZE = 33882;
    public static final int GL_SECONDARY_COLOR_ARRAY_TYPE = 33883;
    public static final int GL_SECONDARY_COLOR_ARRAY_STRIDE = 33884;
    public static final int GL_SECONDARY_COLOR_ARRAY_POINTER = 33885;
    public static final int GL_SECONDARY_COLOR_ARRAY = 33886;
    public static final int GL_BLEND_DST_RGB = 32968;
    public static final int GL_BLEND_SRC_RGB = 32969;
    public static final int GL_BLEND_DST_ALPHA = 32970;
    public static final int GL_BLEND_SRC_ALPHA = 32971;
    public static final int GL_INCR_WRAP = 34055;
    public static final int GL_DECR_WRAP = 34056;
    public static final int GL_TEXTURE_FILTER_CONTROL = 34048;
    public static final int GL_TEXTURE_LOD_BIAS = 34049;
    public static final int GL_MAX_TEXTURE_LOD_BIAS = 34045;
    public static final int GL_MIRRORED_REPEAT = 33648;
    public final long BlendColor;
    public final long BlendEquation;
    public final long FogCoordf;
    public final long FogCoordd;
    public final long FogCoordfv;
    public final long FogCoorddv;
    public final long FogCoordPointer;
    public final long MultiDrawArrays;
    public final long MultiDrawElements;
    public final long PointParameterf;
    public final long PointParameteri;
    public final long PointParameterfv;
    public final long PointParameteriv;
    public final long SecondaryColor3b;
    public final long SecondaryColor3s;
    public final long SecondaryColor3i;
    public final long SecondaryColor3f;
    public final long SecondaryColor3d;
    public final long SecondaryColor3ub;
    public final long SecondaryColor3us;
    public final long SecondaryColor3ui;
    public final long SecondaryColor3bv;
    public final long SecondaryColor3sv;
    public final long SecondaryColor3iv;
    public final long SecondaryColor3fv;
    public final long SecondaryColor3dv;
    public final long SecondaryColor3ubv;
    public final long SecondaryColor3usv;
    public final long SecondaryColor3uiv;
    public final long SecondaryColorPointer;
    public final long BlendFuncSeparate;
    public final long WindowPos2i;
    public final long WindowPos2s;
    public final long WindowPos2f;
    public final long WindowPos2d;
    public final long WindowPos2iv;
    public final long WindowPos2sv;
    public final long WindowPos2fv;
    public final long WindowPos2dv;
    public final long WindowPos3i;
    public final long WindowPos3s;
    public final long WindowPos3f;
    public final long WindowPos3d;
    public final long WindowPos3iv;
    public final long WindowPos3sv;
    public final long WindowPos3fv;
    public final long WindowPos3dv;

    protected GL14() {
        throw new UnsupportedOperationException();
    }

    public GL14(FunctionProvider provider, boolean fc) {
        this.BlendColor = provider.getFunctionAddress("glBlendColor");
        this.BlendEquation = provider.getFunctionAddress("glBlendEquation");
        this.FogCoordf = GL.getFunctionAddress(provider, "glFogCoordf", fc);
        this.FogCoordd = GL.getFunctionAddress(provider, "glFogCoordd", fc);
        this.FogCoordfv = GL.getFunctionAddress(provider, "glFogCoordfv", fc);
        this.FogCoorddv = GL.getFunctionAddress(provider, "glFogCoorddv", fc);
        this.FogCoordPointer = GL.getFunctionAddress(provider, "glFogCoordPointer", fc);
        this.MultiDrawArrays = provider.getFunctionAddress("glMultiDrawArrays");
        this.MultiDrawElements = provider.getFunctionAddress("glMultiDrawElements");
        this.PointParameterf = provider.getFunctionAddress("glPointParameterf");
        this.PointParameteri = provider.getFunctionAddress("glPointParameteri");
        this.PointParameterfv = provider.getFunctionAddress("glPointParameterfv");
        this.PointParameteriv = provider.getFunctionAddress("glPointParameteriv");
        this.SecondaryColor3b = GL.getFunctionAddress(provider, "glSecondaryColor3b", fc);
        this.SecondaryColor3s = GL.getFunctionAddress(provider, "glSecondaryColor3s", fc);
        this.SecondaryColor3i = GL.getFunctionAddress(provider, "glSecondaryColor3i", fc);
        this.SecondaryColor3f = GL.getFunctionAddress(provider, "glSecondaryColor3f", fc);
        this.SecondaryColor3d = GL.getFunctionAddress(provider, "glSecondaryColor3d", fc);
        this.SecondaryColor3ub = GL.getFunctionAddress(provider, "glSecondaryColor3ub", fc);
        this.SecondaryColor3us = GL.getFunctionAddress(provider, "glSecondaryColor3us", fc);
        this.SecondaryColor3ui = GL.getFunctionAddress(provider, "glSecondaryColor3ui", fc);
        this.SecondaryColor3bv = GL.getFunctionAddress(provider, "glSecondaryColor3bv", fc);
        this.SecondaryColor3sv = GL.getFunctionAddress(provider, "glSecondaryColor3sv", fc);
        this.SecondaryColor3iv = GL.getFunctionAddress(provider, "glSecondaryColor3iv", fc);
        this.SecondaryColor3fv = GL.getFunctionAddress(provider, "glSecondaryColor3fv", fc);
        this.SecondaryColor3dv = GL.getFunctionAddress(provider, "glSecondaryColor3dv", fc);
        this.SecondaryColor3ubv = GL.getFunctionAddress(provider, "glSecondaryColor3ubv", fc);
        this.SecondaryColor3usv = GL.getFunctionAddress(provider, "glSecondaryColor3usv", fc);
        this.SecondaryColor3uiv = GL.getFunctionAddress(provider, "glSecondaryColor3uiv", fc);
        this.SecondaryColorPointer = GL.getFunctionAddress(provider, "glSecondaryColorPointer", fc);
        this.BlendFuncSeparate = provider.getFunctionAddress("glBlendFuncSeparate");
        this.WindowPos2i = GL.getFunctionAddress(provider, "glWindowPos2i", fc);
        this.WindowPos2s = GL.getFunctionAddress(provider, "glWindowPos2s", fc);
        this.WindowPos2f = GL.getFunctionAddress(provider, "glWindowPos2f", fc);
        this.WindowPos2d = GL.getFunctionAddress(provider, "glWindowPos2d", fc);
        this.WindowPos2iv = GL.getFunctionAddress(provider, "glWindowPos2iv", fc);
        this.WindowPos2sv = GL.getFunctionAddress(provider, "glWindowPos2sv", fc);
        this.WindowPos2fv = GL.getFunctionAddress(provider, "glWindowPos2fv", fc);
        this.WindowPos2dv = GL.getFunctionAddress(provider, "glWindowPos2dv", fc);
        this.WindowPos3i = GL.getFunctionAddress(provider, "glWindowPos3i", fc);
        this.WindowPos3s = GL.getFunctionAddress(provider, "glWindowPos3s", fc);
        this.WindowPos3f = GL.getFunctionAddress(provider, "glWindowPos3f", fc);
        this.WindowPos3d = GL.getFunctionAddress(provider, "glWindowPos3d", fc);
        this.WindowPos3iv = GL.getFunctionAddress(provider, "glWindowPos3iv", fc);
        this.WindowPos3sv = GL.getFunctionAddress(provider, "glWindowPos3sv", fc);
        this.WindowPos3fv = GL.getFunctionAddress(provider, "glWindowPos3fv", fc);
        this.WindowPos3dv = GL.getFunctionAddress(provider, "glWindowPos3dv", fc);
    }

    public static GL14 getInstance() {
        return GL14.getInstance(GL.getCapabilities());
    }

    public static GL14 getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__GL14);
    }

    static GL14 create(Set<String> ext, FunctionProvider provider, boolean fc) {
        if (!ext.contains("OpenGL14")) {
            return null;
        }
        GL14 funcs = new GL14(provider, fc);
        boolean supported = (fc || Checks.checkFunctions(funcs.FogCoordf, funcs.FogCoordd, funcs.FogCoordfv, funcs.FogCoorddv, funcs.FogCoordPointer, funcs.SecondaryColor3b, funcs.SecondaryColor3s, funcs.SecondaryColor3i, funcs.SecondaryColor3f, funcs.SecondaryColor3d, funcs.SecondaryColor3ub, funcs.SecondaryColor3us, funcs.SecondaryColor3ui, funcs.SecondaryColor3bv, funcs.SecondaryColor3sv, funcs.SecondaryColor3iv, funcs.SecondaryColor3fv, funcs.SecondaryColor3dv, funcs.SecondaryColor3ubv, funcs.SecondaryColor3usv, funcs.SecondaryColor3uiv, funcs.SecondaryColorPointer, funcs.WindowPos2i, funcs.WindowPos2s, funcs.WindowPos2f, funcs.WindowPos2d, funcs.WindowPos2iv, funcs.WindowPos2sv, funcs.WindowPos2fv, funcs.WindowPos2dv, funcs.WindowPos3i, funcs.WindowPos3s, funcs.WindowPos3f, funcs.WindowPos3d, funcs.WindowPos3iv, funcs.WindowPos3sv, funcs.WindowPos3fv, funcs.WindowPos3dv)) && Checks.checkFunctions(funcs.BlendColor, funcs.BlendEquation, funcs.MultiDrawArrays, funcs.MultiDrawElements, funcs.PointParameterf, funcs.PointParameteri, funcs.PointParameterfv, funcs.PointParameteriv, funcs.BlendFuncSeparate);
        return GL.checkExtension("OpenGL14", funcs, supported);
    }

    public static void glBlendColor(float red, float green, float blue, float alpha) {
        long __functionAddress = GL14.getInstance().BlendColor;
        JNI.callFFFFV(__functionAddress, red, green, blue, alpha);
    }

    public static void glBlendEquation(int mode) {
        long __functionAddress = GL14.getInstance().BlendEquation;
        JNI.callIV(__functionAddress, mode);
    }

    public static void glFogCoordf(float coord) {
        long __functionAddress = GL14.getInstance().FogCoordf;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callFV(__functionAddress, coord);
    }

    public static void glFogCoordd(double coord) {
        long __functionAddress = GL14.getInstance().FogCoordd;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callDV(__functionAddress, coord);
    }

    public static void nglFogCoordfv(long coord) {
        long __functionAddress = GL14.getInstance().FogCoordfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, coord);
    }

    public static void glFogCoordfv(ByteBuffer coord) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coord, 4);
        }
        GL14.nglFogCoordfv(MemoryUtil.memAddress(coord));
    }

    public static void glFogCoordfv(FloatBuffer coord) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coord, 1);
        }
        GL14.nglFogCoordfv(MemoryUtil.memAddress(coord));
    }

    public static void nglFogCoorddv(long coord) {
        long __functionAddress = GL14.getInstance().FogCoorddv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, coord);
    }

    public static void glFogCoorddv(ByteBuffer coord) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coord, 8);
        }
        GL14.nglFogCoorddv(MemoryUtil.memAddress(coord));
    }

    public static void glFogCoorddv(DoubleBuffer coord) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coord, 1);
        }
        GL14.nglFogCoorddv(MemoryUtil.memAddress(coord));
    }

    public static void nglFogCoordPointer(int type, int stride, long pointer) {
        long __functionAddress = GL14.getInstance().FogCoordPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIPV(__functionAddress, type, stride, pointer);
    }

    public static void glFogCoordPointer(int type, int stride, ByteBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL14.nglFogCoordPointer(type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glFogCoordPointer(int type, int stride, long pointerOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, true);
        }
        GL14.nglFogCoordPointer(type, stride, pointerOffset);
    }

    public static void glFogCoordPointer(int type, int stride, ShortBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL14.nglFogCoordPointer(type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glFogCoordPointer(int type, int stride, FloatBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL14.nglFogCoordPointer(type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void nglMultiDrawArrays(int mode, long first, long count, int primcount) {
        long __functionAddress = GL14.getInstance().MultiDrawArrays;
        JNI.callIPPIV(__functionAddress, mode, first, count, primcount);
    }

    public static void glMultiDrawArrays(int mode, ByteBuffer first, ByteBuffer count, int primcount) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)first, primcount << 2);
            Checks.checkBuffer((Buffer)count, primcount << 2);
        }
        GL14.nglMultiDrawArrays(mode, MemoryUtil.memAddress(first), MemoryUtil.memAddress(count), primcount);
    }

    public static void glMultiDrawArrays(int mode, IntBuffer first, IntBuffer count) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)count, first.remaining());
        }
        GL14.nglMultiDrawArrays(mode, MemoryUtil.memAddress(first), MemoryUtil.memAddress(count), first.remaining());
    }

    public static void nglMultiDrawElements(int mode, long count, int type, long indices, int primcount) {
        long __functionAddress = GL14.getInstance().MultiDrawElements;
        JNI.callIPIPIV(__functionAddress, mode, count, type, indices, primcount);
    }

    public static void glMultiDrawElements(int mode, ByteBuffer count, int type, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)count, primcount << 2);
            Checks.checkBuffer((Buffer)indices, primcount << Pointer.POINTER_SHIFT);
        }
        GL14.nglMultiDrawElements(mode, MemoryUtil.memAddress(count), type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glMultiDrawElements(int mode, IntBuffer count, int type, PointerBuffer indices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(indices, count.remaining());
        }
        GL14.nglMultiDrawElements(mode, MemoryUtil.memAddress(count), type, MemoryUtil.memAddress(indices), count.remaining());
    }

    public static void glPointParameterf(int pname, float param) {
        long __functionAddress = GL14.getInstance().PointParameterf;
        JNI.callIFV(__functionAddress, pname, param);
    }

    public static void glPointParameteri(int pname, int param) {
        long __functionAddress = GL14.getInstance().PointParameteri;
        JNI.callIIV(__functionAddress, pname, param);
    }

    public static void nglPointParameterfv(int pname, long params) {
        long __functionAddress = GL14.getInstance().PointParameterfv;
        JNI.callIPV(__functionAddress, pname, params);
    }

    public static void glPointParameterfv(int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 12);
        }
        GL14.nglPointParameterfv(pname, MemoryUtil.memAddress(params));
    }

    public static void glPointParameterfv(int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 3);
        }
        GL14.nglPointParameterfv(pname, MemoryUtil.memAddress(params));
    }

    public static void nglPointParameteriv(int pname, long params) {
        long __functionAddress = GL14.getInstance().PointParameteriv;
        JNI.callIPV(__functionAddress, pname, params);
    }

    public static void glPointParameteriv(int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 12);
        }
        GL14.nglPointParameteriv(pname, MemoryUtil.memAddress(params));
    }

    public static void glPointParameteriv(int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 3);
        }
        GL14.nglPointParameteriv(pname, MemoryUtil.memAddress(params));
    }

    public static void glSecondaryColor3b(byte red, byte green, byte blue) {
        long __functionAddress = GL14.getInstance().SecondaryColor3b;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callBBBV(__functionAddress, red, green, blue);
    }

    public static void glSecondaryColor3s(short red, short green, short blue) {
        long __functionAddress = GL14.getInstance().SecondaryColor3s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callSSSV(__functionAddress, red, green, blue);
    }

    public static void glSecondaryColor3i(int red, int green, int blue) {
        long __functionAddress = GL14.getInstance().SecondaryColor3i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIV(__functionAddress, red, green, blue);
    }

    public static void glSecondaryColor3f(float red, float green, float blue) {
        long __functionAddress = GL14.getInstance().SecondaryColor3f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callFFFV(__functionAddress, red, green, blue);
    }

    public static void glSecondaryColor3d(double red, double green, double blue) {
        long __functionAddress = GL14.getInstance().SecondaryColor3d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callDDDV(__functionAddress, red, green, blue);
    }

    public static void glSecondaryColor3ub(byte red, byte green, byte blue) {
        long __functionAddress = GL14.getInstance().SecondaryColor3ub;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callBBBV(__functionAddress, red, green, blue);
    }

    public static void glSecondaryColor3us(short red, short green, short blue) {
        long __functionAddress = GL14.getInstance().SecondaryColor3us;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callSSSV(__functionAddress, red, green, blue);
    }

    public static void glSecondaryColor3ui(int red, int green, int blue) {
        long __functionAddress = GL14.getInstance().SecondaryColor3ui;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIV(__functionAddress, red, green, blue);
    }

    public static void nglSecondaryColor3bv(long v) {
        long __functionAddress = GL14.getInstance().SecondaryColor3bv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, v);
    }

    public static void glSecondaryColor3bv(ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GL14.nglSecondaryColor3bv(MemoryUtil.memAddress(v));
    }

    public static void nglSecondaryColor3sv(long v) {
        long __functionAddress = GL14.getInstance().SecondaryColor3sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, v);
    }

    public static void glSecondaryColor3sv(ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 6);
        }
        GL14.nglSecondaryColor3sv(MemoryUtil.memAddress(v));
    }

    public static void glSecondaryColor3sv(ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GL14.nglSecondaryColor3sv(MemoryUtil.memAddress(v));
    }

    public static void nglSecondaryColor3iv(long v) {
        long __functionAddress = GL14.getInstance().SecondaryColor3iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, v);
    }

    public static void glSecondaryColor3iv(ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 12);
        }
        GL14.nglSecondaryColor3iv(MemoryUtil.memAddress(v));
    }

    public static void glSecondaryColor3iv(IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GL14.nglSecondaryColor3iv(MemoryUtil.memAddress(v));
    }

    public static void nglSecondaryColor3fv(long v) {
        long __functionAddress = GL14.getInstance().SecondaryColor3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, v);
    }

    public static void glSecondaryColor3fv(ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 12);
        }
        GL14.nglSecondaryColor3fv(MemoryUtil.memAddress(v));
    }

    public static void glSecondaryColor3fv(FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GL14.nglSecondaryColor3fv(MemoryUtil.memAddress(v));
    }

    public static void nglSecondaryColor3dv(long v) {
        long __functionAddress = GL14.getInstance().SecondaryColor3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, v);
    }

    public static void glSecondaryColor3dv(ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 24);
        }
        GL14.nglSecondaryColor3dv(MemoryUtil.memAddress(v));
    }

    public static void glSecondaryColor3dv(DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GL14.nglSecondaryColor3dv(MemoryUtil.memAddress(v));
    }

    public static void nglSecondaryColor3ubv(long v) {
        long __functionAddress = GL14.getInstance().SecondaryColor3ubv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, v);
    }

    public static void glSecondaryColor3ubv(ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GL14.nglSecondaryColor3ubv(MemoryUtil.memAddress(v));
    }

    public static void nglSecondaryColor3usv(long v) {
        long __functionAddress = GL14.getInstance().SecondaryColor3usv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, v);
    }

    public static void glSecondaryColor3usv(ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 6);
        }
        GL14.nglSecondaryColor3usv(MemoryUtil.memAddress(v));
    }

    public static void glSecondaryColor3usv(ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GL14.nglSecondaryColor3usv(MemoryUtil.memAddress(v));
    }

    public static void nglSecondaryColor3uiv(long v) {
        long __functionAddress = GL14.getInstance().SecondaryColor3uiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, v);
    }

    public static void glSecondaryColor3uiv(ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 12);
        }
        GL14.nglSecondaryColor3uiv(MemoryUtil.memAddress(v));
    }

    public static void glSecondaryColor3uiv(IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GL14.nglSecondaryColor3uiv(MemoryUtil.memAddress(v));
    }

    public static void nglSecondaryColorPointer(int size, int type, int stride, long pointer) {
        long __functionAddress = GL14.getInstance().SecondaryColorPointer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIPV(__functionAddress, size, type, stride, pointer);
    }

    public static void glSecondaryColorPointer(int size, int type, int stride, ByteBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL14.nglSecondaryColorPointer(size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glSecondaryColorPointer(int size, int type, int stride, long pointerOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, true);
        }
        GL14.nglSecondaryColorPointer(size, type, stride, pointerOffset);
    }

    public static void glSecondaryColorPointer(int size, int type, int stride, ShortBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL14.nglSecondaryColorPointer(size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glSecondaryColorPointer(int size, int type, int stride, IntBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL14.nglSecondaryColorPointer(size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glSecondaryColorPointer(int size, int type, int stride, FloatBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL14.nglSecondaryColorPointer(size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glBlendFuncSeparate(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha) {
        long __functionAddress = GL14.getInstance().BlendFuncSeparate;
        JNI.callIIIIV(__functionAddress, sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
    }

    public static void glWindowPos2i(int x, int y) {
        long __functionAddress = GL14.getInstance().WindowPos2i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIV(__functionAddress, x, y);
    }

    public static void glWindowPos2s(short x, short y) {
        long __functionAddress = GL14.getInstance().WindowPos2s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callSSV(__functionAddress, x, y);
    }

    public static void glWindowPos2f(float x, float y) {
        long __functionAddress = GL14.getInstance().WindowPos2f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callFFV(__functionAddress, x, y);
    }

    public static void glWindowPos2d(double x, double y) {
        long __functionAddress = GL14.getInstance().WindowPos2d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callDDV(__functionAddress, x, y);
    }

    public static void nglWindowPos2iv(long p) {
        long __functionAddress = GL14.getInstance().WindowPos2iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, p);
    }

    public static void glWindowPos2iv(ByteBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 8);
        }
        GL14.nglWindowPos2iv(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos2iv(IntBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 2);
        }
        GL14.nglWindowPos2iv(MemoryUtil.memAddress(p));
    }

    public static void nglWindowPos2sv(long p) {
        long __functionAddress = GL14.getInstance().WindowPos2sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, p);
    }

    public static void glWindowPos2sv(ByteBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 4);
        }
        GL14.nglWindowPos2sv(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos2sv(ShortBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 2);
        }
        GL14.nglWindowPos2sv(MemoryUtil.memAddress(p));
    }

    public static void nglWindowPos2fv(long p) {
        long __functionAddress = GL14.getInstance().WindowPos2fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, p);
    }

    public static void glWindowPos2fv(ByteBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 8);
        }
        GL14.nglWindowPos2fv(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos2fv(FloatBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 2);
        }
        GL14.nglWindowPos2fv(MemoryUtil.memAddress(p));
    }

    public static void nglWindowPos2dv(long p) {
        long __functionAddress = GL14.getInstance().WindowPos2dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, p);
    }

    public static void glWindowPos2dv(ByteBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 16);
        }
        GL14.nglWindowPos2dv(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos2dv(DoubleBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 2);
        }
        GL14.nglWindowPos2dv(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos3i(int x, int y, int z) {
        long __functionAddress = GL14.getInstance().WindowPos3i;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIV(__functionAddress, x, y, z);
    }

    public static void glWindowPos3s(short x, short y, short z) {
        long __functionAddress = GL14.getInstance().WindowPos3s;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callSSSV(__functionAddress, x, y, z);
    }

    public static void glWindowPos3f(float x, float y, float z) {
        long __functionAddress = GL14.getInstance().WindowPos3f;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callFFFV(__functionAddress, x, y, z);
    }

    public static void glWindowPos3d(double x, double y, double z) {
        long __functionAddress = GL14.getInstance().WindowPos3d;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callDDDV(__functionAddress, x, y, z);
    }

    public static void nglWindowPos3iv(long p) {
        long __functionAddress = GL14.getInstance().WindowPos3iv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, p);
    }

    public static void glWindowPos3iv(ByteBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 12);
        }
        GL14.nglWindowPos3iv(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos3iv(IntBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 3);
        }
        GL14.nglWindowPos3iv(MemoryUtil.memAddress(p));
    }

    public static void nglWindowPos3sv(long p) {
        long __functionAddress = GL14.getInstance().WindowPos3sv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, p);
    }

    public static void glWindowPos3sv(ByteBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 6);
        }
        GL14.nglWindowPos3sv(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos3sv(ShortBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 3);
        }
        GL14.nglWindowPos3sv(MemoryUtil.memAddress(p));
    }

    public static void nglWindowPos3fv(long p) {
        long __functionAddress = GL14.getInstance().WindowPos3fv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, p);
    }

    public static void glWindowPos3fv(ByteBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 12);
        }
        GL14.nglWindowPos3fv(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos3fv(FloatBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 3);
        }
        GL14.nglWindowPos3fv(MemoryUtil.memAddress(p));
    }

    public static void nglWindowPos3dv(long p) {
        long __functionAddress = GL14.getInstance().WindowPos3dv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, p);
    }

    public static void glWindowPos3dv(ByteBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 24);
        }
        GL14.nglWindowPos3dv(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos3dv(DoubleBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 3);
        }
        GL14.nglWindowPos3dv(MemoryUtil.memAddress(p));
    }
}

