/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class GLX11 {
    public static final int GLX_VENDOR = 1;
    public static final int GLX_VERSION = 2;
    public static final int GLX_EXTENSIONS = 3;
    public final long QueryExtensionsString;
    public final long GetClientString;
    public final long QueryServerString;

    protected GLX11() {
        throw new UnsupportedOperationException();
    }

    public GLX11(FunctionProvider provider) {
        this.QueryExtensionsString = provider.getFunctionAddress("glXQueryExtensionsString");
        this.GetClientString = provider.getFunctionAddress("glXGetClientString");
        this.QueryServerString = provider.getFunctionAddress("glXQueryServerString");
    }

    public static GLX11 getInstance() {
        return GLX11.getInstance(GL.getCapabilities());
    }

    public static GLX11 getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__GLX11);
    }

    static GLX11 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLX11")) {
            return null;
        }
        GLX11 funcs = new GLX11(provider);
        boolean supported = Checks.checkFunctions(funcs.QueryExtensionsString, funcs.GetClientString, funcs.QueryServerString);
        return GL.checkExtension("GLX11", funcs, supported);
    }

    public static long nglXQueryExtensionsString(long display, int screen) {
        long __functionAddress = GLX11.getInstance().QueryExtensionsString;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPIP(__functionAddress, display, screen);
    }

    public static String glXQueryExtensionsString(long display, int screen) {
        long __result = GLX11.nglXQueryExtensionsString(display, screen);
        return MemoryUtil.memDecodeASCII(__result);
    }

    public static long nglXGetClientString(long display, int name) {
        long __functionAddress = GLX11.getInstance().GetClientString;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPIP(__functionAddress, display, name);
    }

    public static String glXGetClientString(long display, int name) {
        long __result = GLX11.nglXGetClientString(display, name);
        return MemoryUtil.memDecodeASCII(__result);
    }

    public static long nglXQueryServerString(long display, int screen, int name) {
        long __functionAddress = GLX11.getInstance().QueryServerString;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPIIP(__functionAddress, display, screen, name);
    }

    public static String glXQueryServerString(long display, int screen, int name) {
        long __result = GLX11.nglXQueryServerString(display, screen, name);
        return MemoryUtil.memDecodeASCII(__result);
    }
}

