/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class GLXSGIXSwapBarrier {
    public final long BindSwapBarrierSGIX;
    public final long QueryMaxSwapBarriersSGIX;

    protected GLXSGIXSwapBarrier() {
        throw new UnsupportedOperationException();
    }

    public GLXSGIXSwapBarrier(FunctionProvider provider) {
        this.BindSwapBarrierSGIX = provider.getFunctionAddress("glXBindSwapBarrierSGIX");
        this.QueryMaxSwapBarriersSGIX = provider.getFunctionAddress("glXQueryMaxSwapBarriersSGIX");
    }

    public static GLXSGIXSwapBarrier getInstance() {
        return GLXSGIXSwapBarrier.getInstance(GL.getCapabilities());
    }

    public static GLXSGIXSwapBarrier getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__GLXSGIXSwapBarrier);
    }

    static GLXSGIXSwapBarrier create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLX_SGIX_swap_barrier")) {
            return null;
        }
        GLXSGIXSwapBarrier funcs = new GLXSGIXSwapBarrier(provider);
        boolean supported = Checks.checkFunctions(funcs.BindSwapBarrierSGIX, funcs.QueryMaxSwapBarriersSGIX);
        return GL.checkExtension("GLX_SGIX_swap_barrier", funcs, supported);
    }

    public static void glXBindSwapBarrierSGIX(long display, long drawable, int barrier) {
        long __functionAddress = GLXSGIXSwapBarrier.getInstance().BindSwapBarrierSGIX;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(drawable);
        }
        JNI.callPPIV(__functionAddress, display, drawable, barrier);
    }

    public static int nglXQueryMaxSwapBarriersSGIX(long display, int screen, long max) {
        long __functionAddress = GLXSGIXSwapBarrier.getInstance().QueryMaxSwapBarriersSGIX;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPIPI(__functionAddress, display, screen, max);
    }

    public static int glXQueryMaxSwapBarriersSGIX(long display, int screen, ByteBuffer max) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)max, 4);
        }
        return GLXSGIXSwapBarrier.nglXQueryMaxSwapBarriersSGIX(display, screen, MemoryUtil.memAddress(max));
    }

    public static int glXQueryMaxSwapBarriersSGIX(long display, int screen, IntBuffer max) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)max, 1);
        }
        return GLXSGIXSwapBarrier.nglXQueryMaxSwapBarriersSGIX(display, screen, MemoryUtil.memAddress(max));
    }
}

